/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.memory;

import generic.Span;
import generic.ULongSpan;
import ghidra.async.AsyncFence;
import ghidra.async.AsyncUtils;
import ghidra.dbg.memory.MemoryReader;
import ghidra.dbg.memory.MemoryWriter;
import ghidra.generic.util.datastruct.SemisparseByteArray;
import ghidra.util.Msg;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.lang3.exception.ExceptionUtils;

@Deprecated(forRemoval=true, since="11.2")
public class CachedMemory
implements MemoryReader,
MemoryWriter {
    private final SemisparseByteArray memory = new SemisparseByteArray();
    private final NavigableMap<Long, PendingRead> pendingByLoc = new TreeMap<Long, PendingRead>((arg_0, arg_1) -> ((ULongSpan.Domain)ULongSpan.DOMAIN).compare(arg_0, arg_1));
    private final MemoryReader reader;
    private final MemoryWriter writer;

    public CachedMemory(MemoryReader reader, MemoryWriter writer) {
        this.reader = reader;
        this.writer = writer;
    }

    @Override
    public CompletableFuture<Void> writeMemory(long addr, byte[] data) {
        return this.writer.writeMemory(addr, data).thenAccept(__ -> this.memory.putData(addr, data));
    }

    protected synchronized CompletableFuture<Void> waitForReads(long addr, int len) {
        ULongSpan.ULongSpanSet undefined = this.memory.getUninitialized(addr, addr + (long)len - 1L);
        AsyncFence fence = new AsyncFence();
        for (ULongSpan span : undefined.spans()) {
            this.findPendingOrSchedule(span, fence);
        }
        return fence.ready();
    }

    protected synchronized void findPendingOrSchedule(ULongSpan span, AsyncFence fence) {
        ULongSpan.DefaultULongSpanSet needRequests = new ULongSpan.DefaultULongSpanSet();
        needRequests.add((Span)span);
        Map.Entry<Long, PendingRead> prec = this.pendingByLoc.lowerEntry((Long)span.min());
        if (prec != null) {
            PendingRead pending = prec.getValue();
            if (!pending.future.isCompletedExceptionally() && span.intersects((Span)pending.span)) {
                needRequests.remove((Span)pending.span);
                fence.include(pending.future);
            }
        }
        NavigableMap<Long, PendingRead> applicablePending = this.pendingByLoc.subMap((Long)span.min(), true, (Long)span.max(), true);
        for (Map.Entry ent : applicablePending.entrySet()) {
            PendingRead pending = (PendingRead)ent.getValue();
            if (pending.future.isCompletedExceptionally()) continue;
            needRequests.remove((Span)pending.span);
            fence.include(pending.future);
        }
        for (ULongSpan needed : needRequests.spans()) {
            long lower = (Long)needed.min();
            CompletableFuture<byte[]> futureRead = this.reader.readMemory(lower, (int)needed.length());
            CompletionStage futureStored = ((CompletableFuture)futureRead.thenAcceptAsync(data -> {
                CachedMemory cachedMemory = this;
                synchronized (cachedMemory) {
                    if (this.pendingByLoc.remove(lower) != null) {
                        this.memory.putData(lower, data);
                    }
                }
            })).exceptionally(e -> {
                Msg.error((Object)this, (Object)"Unexpected error caching memory: ", (Throwable)e);
                CachedMemory cachedMemory = this;
                synchronized (cachedMemory) {
                    this.pendingByLoc.remove(lower);
                }
                return (Void)ExceptionUtils.rethrow((Throwable)e);
            });
            this.pendingByLoc.put(lower, new PendingRead(span, (CompletableFuture<Void>)futureStored));
            fence.include((CompletableFuture)futureStored);
        }
    }

    @Override
    public CompletableFuture<byte[]> readMemory(long addr, int len) {
        AssertionError defaultErr = new AssertionError((Object)"No data available even after a successful read?");
        AtomicReference<AssertionError> exc = new AtomicReference<AssertionError>(defaultErr);
        return this.waitForReads(addr, len).handle((v, e) -> {
            int available = this.memory.contiguousAvailableAfter(addr);
            if (available == 0) {
                if (e == null) {
                    throw new AssertionError((Object)("No data available at " + Long.toUnsignedString(addr, 16) + " even after a successful read?"));
                }
                return (byte[])ExceptionUtils.rethrow((Throwable)e);
            }
            if (e != null && !this.isTimeout((Throwable)e)) {
                Msg.error((Object)this, (Object)("Some reads requested by the cache failed. Returning a partial result: " + String.valueOf(exc.get())));
            }
            byte[] result = new byte[Math.min(len, available)];
            this.memory.getData(addr, result);
            return result;
        });
    }

    public void updateMemory(long address, byte[] data) {
        this.memory.putData(address, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        List<PendingRead> toCancel;
        CachedMemory cachedMemory = this;
        synchronized (cachedMemory) {
            this.memory.clear();
            toCancel = List.copyOf(this.pendingByLoc.values());
            this.pendingByLoc.clear();
        }
        for (PendingRead pendingRead : toCancel) {
            pendingRead.future.cancel(true);
        }
    }

    protected boolean isTimeout(Throwable e) {
        return (e = AsyncUtils.unwrapThrowable((Throwable)e)) instanceof TimeoutException;
    }

    protected static class PendingRead {
        final ULongSpan span;
        final CompletableFuture<Void> future;

        protected PendingRead(ULongSpan span, CompletableFuture<Void> future) {
            this.span = span;
            this.future = future;
        }
    }
}

