/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target;

import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.util.CollectionUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import java.util.Set;
import java.util.concurrent.CompletableFuture;

@Deprecated(forRemoval=true, since="11.2")
@DebuggerTargetObjectIface(value="BreakpointSpecContainer")
public interface TargetBreakpointSpecContainer
extends TargetObject {
    public static final String SUPPORTED_BREAK_KINDS_ATTRIBUTE_NAME = "_supported_breakpoint_kinds";

    @TargetAttributeType(name="_supported_breakpoint_kinds", required=true, hidden=true)
    default public TargetBreakpointKindSet getSupportedBreakpointKinds() {
        return this.getTypedAttributeNowByName(SUPPORTED_BREAK_KINDS_ATTRIBUTE_NAME, TargetBreakpointKindSet.class, TargetBreakpointKindSet.of());
    }

    public CompletableFuture<Void> placeBreakpoint(String var1, Set<TargetBreakpointSpec.TargetBreakpointKind> var2);

    public CompletableFuture<Void> placeBreakpoint(AddressRange var1, Set<TargetBreakpointSpec.TargetBreakpointKind> var2);

    default public CompletableFuture<Void> placeBreakpoint(Address address, Set<TargetBreakpointSpec.TargetBreakpointKind> kinds) {
        return this.placeBreakpoint((AddressRange)new AddressRangeImpl(address, address), kinds);
    }

    public static interface TargetBreakpointKindSet
    extends Set<TargetBreakpointSpec.TargetBreakpointKind> {
        public static final TargetBreakpointKindSet EMPTY = new EmptyTargetBreakpointKindSet();

        public static TargetBreakpointKindSet of() {
            return EMPTY;
        }

        public static TargetBreakpointKindSet of(TargetBreakpointSpec.TargetBreakpointKind ... kinds) {
            return new ImmutableTargetBreakpointKindSet(kinds);
        }

        public static TargetBreakpointKindSet copyOf(Set<TargetBreakpointSpec.TargetBreakpointKind> set) {
            return new ImmutableTargetBreakpointKindSet(set);
        }

        public static class ImmutableTargetBreakpointKindSet
        extends CollectionUtils.AbstractNSet<TargetBreakpointSpec.TargetBreakpointKind>
        implements TargetBreakpointKindSet {
            public ImmutableTargetBreakpointKindSet(TargetBreakpointSpec.TargetBreakpointKind ... kinds) {
                super(kinds);
            }

            public ImmutableTargetBreakpointKindSet(Set<TargetBreakpointSpec.TargetBreakpointKind> set) {
                super(set);
            }
        }

        public static class EmptyTargetBreakpointKindSet
        extends CollectionUtils.AbstractEmptySet<TargetBreakpointSpec.TargetBreakpointKind>
        implements TargetBreakpointKindSet {
        }
    }
}

