/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.DebuggerTargetObjectIface;
import ghidra.dbg.target.TargetMethod;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.DefaultSchemaContext;
import ghidra.dbg.target.schema.DefaultTargetObjectSchema;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.SchemaBuilder;
import ghidra.dbg.target.schema.TargetAttributeType;
import ghidra.dbg.target.schema.TargetElementType;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchemaInfo;
import ghidra.util.Msg;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.reflect.TypeUtils;
import utilities.util.reflection.ReflectionUtilities;

@Deprecated(forRemoval=true, since="11.2")
public class AnnotatedSchemaContext
extends DefaultSchemaContext {
    protected final Map<Class<? extends TargetObject>, TargetObjectSchema.SchemaName> namesByClass = new LinkedHashMap<Class<? extends TargetObject>, TargetObjectSchema.SchemaName>();
    protected final Map<Class<? extends TargetObject>, TargetObjectSchema> schemasByClass = new LinkedHashMap<Class<? extends TargetObject>, TargetObjectSchema>();

    static <T> Stream<Class<? extends T>> filterBounds(Class<T> base, Stream<Class<?>> bounds) {
        return bounds.filter(base::isAssignableFrom).map(c -> c.asSubclass(base));
    }

    static Stream<Class<?>> resolveUpperBounds(Class<? extends TargetObject> cls, Type type) {
        if (type == null) {
            return Stream.empty();
        }
        if (type instanceof Class) {
            return Stream.of((Class)type);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            return AnnotatedSchemaContext.resolveUpperBounds(cls, pt.getRawType());
        }
        if (type instanceof WildcardType) {
            WildcardType wt = (WildcardType)type;
            return Stream.of(TypeUtils.getImplicitUpperBounds((WildcardType)wt)).flatMap(t -> AnnotatedSchemaContext.resolveUpperBounds(cls, t));
        }
        if (type instanceof TypeVariable) {
            Class declCls;
            Map args;
            Type argTv;
            TypeVariable tv = (TypeVariable)type;
            Object decl = tv.getGenericDeclaration();
            if (decl instanceof Class && (argTv = (Type)(args = TypeUtils.getTypeArguments(cls, (Class)(declCls = (Class)decl))).get(tv)) != null) {
                return AnnotatedSchemaContext.resolveUpperBounds(cls, argTv);
            }
            return Stream.of(TypeUtils.getImplicitBounds((TypeVariable)tv)).flatMap(t -> AnnotatedSchemaContext.resolveUpperBounds(cls, t));
        }
        throw new AssertionError((Object)("Cannot handle type: " + String.valueOf(type)));
    }

    static Set<Class<? extends TargetObject>> getBoundsOfFetchElements(Class<? extends TargetObject> cls) {
        try {
            Method method = cls.getMethod("fetchElements", DebuggerObjectModel.RefreshBehavior.class);
            Type ret = method.getGenericReturnType();
            Map argsCf = TypeUtils.getTypeArguments((Type)ret, CompletableFuture.class);
            Type typeCfT = (Type)argsCf.get(CompletableFuture.class.getTypeParameters()[0]);
            Map argsMap = TypeUtils.getTypeArguments((Type)typeCfT, Map.class);
            Type typeCfMapV = (Type)argsMap.get(Map.class.getTypeParameters()[1]);
            return AnnotatedSchemaContext.filterBounds(TargetObject.class, AnnotatedSchemaContext.resolveUpperBounds(cls, typeCfMapV)).collect(Collectors.toSet());
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }

    static Set<Class<? extends TargetObject>> getBoundsOfObjectAttributeGetter(Class<? extends TargetObject> cls, Method getter) {
        Class<?> retCls = getter.getReturnType();
        if (TargetObject.class.isAssignableFrom(retCls)) {
            return Set.of(retCls.asSubclass(TargetObject.class));
        }
        throw new IllegalArgumentException("Getter " + String.valueOf(getter) + " for attribute must return primitive or subclass of " + String.valueOf(TargetObject.class));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetObjectSchema.SchemaName nameFromAnnotatedClass(Class<? extends TargetObject> cls) {
        Map<Class<? extends TargetObject>, TargetObjectSchema.SchemaName> map = this.namesByClass;
        synchronized (map) {
            TargetObjectSchemaInfo info = cls.getAnnotation(TargetObjectSchemaInfo.class);
            if (info == null) {
                DebuggerTargetObjectIface iface = cls.getAnnotation(DebuggerTargetObjectIface.class);
                if (iface == null) {
                    Msg.warn((Object)this, (Object)("Class " + String.valueOf(cls) + " is not annotated with @" + TargetObjectSchemaInfo.class.getSimpleName()));
                }
                return EnumerableTargetObjectSchema.OBJECT.getName();
            }
            return this.namesByClass.computeIfAbsent(cls, c -> {
                String name = info.name();
                if (name.equals("")) {
                    return new TargetObjectSchema.SchemaName(cls.getSimpleName());
                }
                return new TargetObjectSchema.SchemaName(name);
            });
        }
    }

    protected void addPublicMethodsFromClass(SchemaBuilder builder, Class<? extends TargetObject> declCls, Class<? extends TargetObject> cls) {
        for (Method declMethod : declCls.getDeclaredMethods()) {
            TargetObjectSchema.AttributeSchema attrSchema;
            Method method;
            TargetAttributeType at;
            int mod = declMethod.getModifiers();
            if (!Modifier.isPublic(mod) || (at = declMethod.getAnnotation(TargetAttributeType.class)) == null) continue;
            try {
                method = cls.getMethod(declMethod.getName(), declMethod.getParameterTypes());
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw new AssertionError((Object)e);
            }
            try {
                attrSchema = this.attributeSchemaFromAnnotatedMethod(declCls, method, at);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not get schema name for attribute accessor " + String.valueOf(method) + " in " + String.valueOf(cls), e);
            }
            if (attrSchema == null) continue;
            builder.addAttributeSchema(attrSchema, declMethod);
        }
    }

    protected void addExportedTargetMethodsFromClass(SchemaBuilder builder, Class<? extends TargetObject> declCls, Class<? extends TargetObject> cls) {
        for (Method declMethod : declCls.getDeclaredMethods()) {
            TargetObjectSchema.AttributeSchema exists;
            TargetMethod.Export export;
            int mod = declMethod.getModifiers();
            if (!Modifier.isPublic(mod) || (export = declMethod.getAnnotation(TargetMethod.Export.class)) == null || (exists = builder.getAttributeSchema(export.value())) != null) continue;
            TargetObjectSchema.SchemaName snMethod = new TargetObjectSchema.SchemaName("Method");
            if (this.getSchemaOrNull(snMethod) == null) {
                this.builder(snMethod).addInterface(TargetMethod.class).setDefaultElementSchema(EnumerableTargetObjectSchema.VOID.getName()).addAttributeSchema(new DefaultTargetObjectSchema.DefaultAttributeSchema("_display", EnumerableTargetObjectSchema.STRING.getName(), true, true, true), "default").addAttributeSchema(new DefaultTargetObjectSchema.DefaultAttributeSchema("_return_type", EnumerableTargetObjectSchema.TYPE.getName(), true, true, true), "default").addAttributeSchema(new DefaultTargetObjectSchema.DefaultAttributeSchema("_parameters", EnumerableTargetObjectSchema.MAP_PARAMETERS.getName(), true, true, true), "default").setDefaultAttributeSchema(TargetObjectSchema.AttributeSchema.DEFAULT_VOID).buildAndAdd();
            }
            builder.addAttributeSchema(new DefaultTargetObjectSchema.DefaultAttributeSchema(export.value(), snMethod, true, true, true), declMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TargetObjectSchema fromAnnotatedClass(Class<? extends TargetObject> cls) {
        Map<Class<? extends TargetObject>, TargetObjectSchema.SchemaName> map = this.namesByClass;
        synchronized (map) {
            TargetObjectSchema.SchemaName name = this.nameFromAnnotatedClass(cls);
            TargetObjectSchema enumerable = EnumerableTargetObjectSchema.MinimalSchemaContext.INSTANCE.getSchemaOrNull(name);
            if (enumerable != null) {
                throw new IllegalArgumentException("Class " + String.valueOf(cls) + " is assigned name " + String.valueOf(name) + ". This usually means it's missing the @" + TargetObjectSchemaInfo.class.getSimpleName() + " annotation, or that the class was referenced by accident.");
            }
            return this.schemasByClass.computeIfAbsent(cls, c -> {
                SchemaBuilder builder = this.builderForClass(cls, name);
                return builder.buildAndAdd();
            });
        }
    }

    public SchemaBuilder builderForClass(Class<? extends TargetObject> cls) {
        return this.builderForClass(cls, this.nameFromAnnotatedClass(cls));
    }

    public SchemaBuilder builderForClass(Class<? extends TargetObject> cls, TargetObjectSchema.SchemaName name) {
        TargetElementType[] parent2;
        TargetObjectSchemaInfo info = cls.getAnnotation(TargetObjectSchemaInfo.class);
        if (info == null) {
            throw new IllegalArgumentException("Class " + String.valueOf(cls) + " is not annotated with @" + TargetObjectSchemaInfo.class.getSimpleName());
        }
        SchemaBuilder builder = this.builder(name);
        LinkedHashSet allParents = ReflectionUtilities.getAllParents(cls);
        for (TargetElementType[] parent2 : allParents) {
            DebuggerTargetObjectIface ifaceAnnot = parent2.getAnnotation(DebuggerTargetObjectIface.class);
            if (ifaceAnnot == null) continue;
            builder.addInterface(parent2.asSubclass(TargetObject.class));
        }
        builder.setCanonicalContainer(info.canonicalContainer());
        builder.setElementResyncMode(info.elementResync());
        builder.setAttributeResyncMode(info.attributeResync());
        boolean sawDefaultElementType = false;
        parent2 = info.elements();
        int ifaceAnnot = parent2.length;
        for (int i = 0; i < ifaceAnnot; ++i) {
            TargetElementType et = parent2[i];
            if (et.index().equals("")) {
                sawDefaultElementType = true;
            }
            builder.addElementSchema(et.index(), this.nameFromClass(et.type()), et);
        }
        if (!sawDefaultElementType) {
            TargetObjectSchema.SchemaName schemaName;
            Set<Class<? extends TargetObject>> bounds = AnnotatedSchemaContext.getBoundsOfFetchElements(cls);
            if (bounds.size() != 1) {
                throw new IllegalArgumentException("Could not identify unique element class (" + String.valueOf(bounds) + ") for " + String.valueOf(cls));
            }
            Class<? extends TargetObject> bound = bounds.iterator().next();
            try {
                schemaName = this.nameFromClass(bound);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException("Could not get schema name from bound " + String.valueOf(bound) + " of " + String.valueOf(cls) + ".fetchElements()", e);
            }
            builder.setDefaultElementSchema(schemaName);
        }
        this.addPublicMethodsFromClass(builder, cls, cls);
        for (Class parent3 : allParents) {
            if (!TargetObject.class.isAssignableFrom(parent3)) continue;
            this.addPublicMethodsFromClass(builder, parent3.asSubclass(TargetObject.class), cls);
        }
        for (TargetAttributeType at : info.attributes()) {
            AnnotatedAttributeSchema attrSchema = this.attributeSchemaFromAnnotation(at);
            TargetObjectSchema.AttributeSchema exists = builder.getAttributeSchema(attrSchema.getName());
            if (exists != null) {
                attrSchema = attrSchema.lower((AnnotatedAttributeSchema)exists);
            }
            builder.replaceAttributeSchema(attrSchema, at);
        }
        this.addExportedTargetMethodsFromClass(builder, cls, cls);
        for (Class parent4 : allParents) {
            if (!TargetObject.class.isAssignableFrom(parent4)) continue;
            this.addExportedTargetMethodsFromClass(builder, parent4.asSubclass(TargetObject.class), cls);
        }
        return builder;
    }

    protected String attributeNameFromBean(String beanName, boolean isBool) {
        String string = beanName = isBool ? StringUtils.removeStartIgnoreCase((String)beanName, (String)"is") : StringUtils.removeStartIgnoreCase((String)beanName, (String)"get");
        if (beanName.equals("")) {
            throw new IllegalArgumentException("Attribute getter must have a name");
        }
        return beanName.replaceAll("([A-Z]+)([A-Z][a-z])", "$1_$2").replaceAll("([a-z])([A-Z])", "$1_$2").toLowerCase();
    }

    protected AnnotatedAttributeSchema attributeSchemaFromAnnotation(TargetAttributeType at) {
        return new AnnotatedAttributeSchema(at.name(), this.nameFromClass(at.type()), at.required(), at.fixed(), at.hidden(), at.type());
    }

    protected TargetObjectSchema.AttributeSchema attributeSchemaFromAnnotatedMethod(Class<? extends TargetObject> cls, Method method, TargetAttributeType at) {
        TargetObjectSchema.SchemaName primitiveName;
        if (method.getParameterCount() != 0) {
            throw new IllegalArgumentException("Non-getter method " + String.valueOf(method) + " is annotated with @" + TargetAttributeType.class.getSimpleName());
        }
        String name = at.name();
        Class<?> ret = method.getReturnType();
        if (name.equals("")) {
            name = this.attributeNameFromBean(method.getName(), EnumerableTargetObjectSchema.BOOL.getTypes().contains(ret));
        }
        if ((primitiveName = EnumerableTargetObjectSchema.nameForPrimitive(ret)) != null) {
            return new AnnotatedAttributeSchema(name, primitiveName, at.required(), at.fixed(), at.hidden(), ret);
        }
        Set<Class<? extends TargetObject>> bounds = AnnotatedSchemaContext.getBoundsOfObjectAttributeGetter(cls, method);
        if (bounds.size() != 1) {
            throw new IllegalArgumentException("Could not identify unique attribute class for method " + String.valueOf(method) + ": " + String.valueOf(bounds));
        }
        Class<? extends TargetObject> bound = bounds.iterator().next();
        return new AnnotatedAttributeSchema(name, this.nameFromClass(bound), at.required(), at.fixed(), at.hidden(), bound);
    }

    protected TargetObjectSchema.SchemaName nameFromClass(Class<?> cls) {
        TargetObjectSchema.SchemaName name = EnumerableTargetObjectSchema.nameForPrimitive(cls);
        if (name != null) {
            return name;
        }
        if (TargetObject.class.isAssignableFrom(cls)) {
            return this.nameFromAnnotatedClass(cls.asSubclass(TargetObject.class));
        }
        throw new IllegalArgumentException("Cannot figure schema from class: " + String.valueOf(cls));
    }

    protected void fillDependencies() {
        while (this.fillDependenciesRound()) {
        }
    }

    protected boolean fillDependenciesRound() {
        HashSet<Class<? extends TargetObject>> classes = new HashSet<Class<? extends TargetObject>>(this.namesByClass.keySet());
        classes.removeAll(this.schemasByClass.keySet());
        if (classes.isEmpty()) {
            return false;
        }
        for (Class clazz : classes) {
            this.fromAnnotatedClass(clazz);
        }
        return true;
    }

    public TargetObjectSchema getSchemaForClass(Class<? extends TargetObject> cls) {
        TargetObjectSchema schema = this.fromAnnotatedClass(cls);
        this.fillDependencies();
        return schema;
    }

    public static class AnnotatedAttributeSchema
    extends DefaultTargetObjectSchema.DefaultAttributeSchema {
        protected final Class<?> javaClass;

        public AnnotatedAttributeSchema(String name, TargetObjectSchema.SchemaName schema, boolean isRequired, boolean isFixed, boolean isHidden, Class<?> javaClass) {
            super(name, schema, isRequired, isFixed, isHidden);
            this.javaClass = javaClass;
        }

        public AnnotatedAttributeSchema lower(AnnotatedAttributeSchema that) {
            if (this.javaClass.isAssignableFrom(that.javaClass)) {
                return that;
            }
            if (that.javaClass.isAssignableFrom(this.javaClass)) {
                return this;
            }
            throw new IllegalArgumentException("Cannot find lower of " + String.valueOf(this.javaClass) + " and " + String.valueOf(that.javaClass) + ". They are unrelated.");
        }
    }
}

