/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@Deprecated(since="11.2")
public class DefaultTargetObjectSchema
implements TargetObjectSchema,
Comparable<DefaultTargetObjectSchema> {
    private static final String INDENT = "  ";
    private final SchemaContext context;
    private final TargetObjectSchema.SchemaName name;
    private final Class<?> type;
    private final Set<Class<? extends TargetObject>> interfaces;
    private final boolean isCanonicalContainer;
    private final Map<String, TargetObjectSchema.SchemaName> elementSchemas;
    private final TargetObjectSchema.SchemaName defaultElementSchema;
    private final TargetObjectSchema.ResyncMode elementResync;
    private final Map<String, TargetObjectSchema.AttributeSchema> attributeSchemas;
    private final Map<String, String> attributeAliases;
    private final TargetObjectSchema.AttributeSchema defaultAttributeSchema;
    private final TargetObjectSchema.ResyncMode attributeResync;

    DefaultTargetObjectSchema(SchemaContext context, TargetObjectSchema.SchemaName name, Class<?> type, Set<Class<? extends TargetObject>> interfaces, boolean isCanonicalContainer, Map<String, TargetObjectSchema.SchemaName> elementSchemas, TargetObjectSchema.SchemaName defaultElementSchema, TargetObjectSchema.ResyncMode elementResync, Map<String, TargetObjectSchema.AttributeSchema> attributeSchemas, Map<String, String> attributeAliases, TargetObjectSchema.AttributeSchema defaultAttributeSchema, TargetObjectSchema.ResyncMode attributeResync) {
        this.context = context;
        this.name = name;
        this.type = type;
        this.interfaces = Collections.unmodifiableSet(new LinkedHashSet<Class<? extends TargetObject>>(interfaces));
        this.isCanonicalContainer = isCanonicalContainer;
        this.elementSchemas = Collections.unmodifiableMap(new LinkedHashMap<String, TargetObjectSchema.SchemaName>(elementSchemas));
        this.defaultElementSchema = defaultElementSchema;
        this.elementResync = elementResync;
        AliasResolver resolver = new AliasResolver(attributeSchemas, attributeAliases, defaultAttributeSchema);
        this.attributeAliases = Collections.unmodifiableMap(resolver.resolveAliases());
        this.attributeSchemas = Collections.unmodifiableMap(resolver.resolveSchemas());
        this.defaultAttributeSchema = defaultAttributeSchema;
        this.attributeResync = attributeResync;
    }

    @Override
    public SchemaContext getContext() {
        return this.context;
    }

    @Override
    public TargetObjectSchema.SchemaName getName() {
        return this.name;
    }

    @Override
    public Class<?> getType() {
        return this.type;
    }

    @Override
    public Set<Class<? extends TargetObject>> getInterfaces() {
        return this.interfaces;
    }

    @Override
    public boolean isCanonicalContainer() {
        return this.isCanonicalContainer;
    }

    @Override
    public Map<String, TargetObjectSchema.SchemaName> getElementSchemas() {
        return this.elementSchemas;
    }

    @Override
    public TargetObjectSchema.SchemaName getDefaultElementSchema() {
        return this.defaultElementSchema;
    }

    @Override
    public TargetObjectSchema.ResyncMode getElementResyncMode() {
        return this.elementResync;
    }

    @Override
    public Map<String, TargetObjectSchema.AttributeSchema> getAttributeSchemas() {
        return this.attributeSchemas;
    }

    @Override
    public Map<String, String> getAttributeAliases() {
        return this.attributeAliases;
    }

    @Override
    public TargetObjectSchema.AttributeSchema getDefaultAttributeSchema() {
        return this.defaultAttributeSchema;
    }

    @Override
    public TargetObjectSchema.ResyncMode getAttributeResyncMode() {
        return this.attributeResync;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append("schema ");
        sb.append(this.name);
        if (this.isCanonicalContainer) {
            sb.append("*");
        }
        sb.append(" {\n  ");
        sb.append("ifaces = [");
        for (Class<? extends TargetObject> iface : this.interfaces) {
            sb.append(DebuggerObjectModel.requireIfaceName(iface));
            sb.append(" ");
        }
        sb.append("]\n  ");
        sb.append("elements(resync " + String.valueOf((Object)this.elementResync) + ") = ");
        sb.append(this.elementSchemas);
        sb.append(" default " + String.valueOf(this.defaultElementSchema));
        sb.append("\n  ");
        sb.append("attributes(resync " + String.valueOf((Object)this.attributeResync) + ") = ");
        sb.append(this.attributeSchemas);
        sb.append(" default " + String.valueOf(this.defaultAttributeSchema));
        sb.append(" aliases " + String.valueOf(this.attributeAliases));
        sb.append("\n}");
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof DefaultTargetObjectSchema)) {
            return false;
        }
        DefaultTargetObjectSchema that = (DefaultTargetObjectSchema)obj;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.type, that.type)) {
            return false;
        }
        if (!Objects.equals(this.interfaces, that.interfaces)) {
            return false;
        }
        if (this.isCanonicalContainer != that.isCanonicalContainer) {
            return false;
        }
        if (!Objects.equals(this.elementSchemas, that.elementSchemas)) {
            return false;
        }
        if (!Objects.equals(this.defaultElementSchema, that.defaultElementSchema)) {
            return false;
        }
        if (!Objects.equals((Object)this.elementResync, (Object)that.elementResync)) {
            return false;
        }
        if (!Objects.equals(this.attributeSchemas, that.attributeSchemas)) {
            return false;
        }
        if (!Objects.equals(this.attributeAliases, that.attributeAliases)) {
            return false;
        }
        if (!Objects.equals(this.defaultAttributeSchema, that.defaultAttributeSchema)) {
            return false;
        }
        return Objects.equals((Object)this.attributeResync, (Object)that.attributeResync);
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    @Override
    public int compareTo(DefaultTargetObjectSchema o) {
        return this.name.compareTo(o.name);
    }

    protected static class AliasResolver {
        private final Map<String, TargetObjectSchema.AttributeSchema> schemas;
        private final Map<String, String> aliases;
        private final TargetObjectSchema.AttributeSchema defaultSchema;
        private Map<String, String> resolvedAliases;

        public AliasResolver(Map<String, TargetObjectSchema.AttributeSchema> schemas, Map<String, String> aliases, TargetObjectSchema.AttributeSchema defaultSchema) {
            this.schemas = schemas;
            this.aliases = aliases;
            this.defaultSchema = defaultSchema;
        }

        public Map<String, String> resolveAliases() {
            this.resolvedAliases = new LinkedHashMap<String, String>();
            for (String alias : this.aliases.keySet()) {
                if (alias.equals("")) {
                    throw new IllegalArgumentException("Key '' cannot be an alias");
                }
                if (this.schemas.containsKey(alias)) {
                    throw new IllegalArgumentException("Key '%s' cannot be both an attribute and an alias".formatted(alias));
                }
                this.resolveAlias(alias, new LinkedHashSet<String>());
            }
            return this.resolvedAliases;
        }

        protected String resolveAlias(String alias, LinkedHashSet<String> visited) {
            String already = this.resolvedAliases.get(alias);
            if (already != null) {
                return already;
            }
            if (!visited.add(alias)) {
                throw new IllegalArgumentException("Cycle of aliases: " + String.valueOf(visited));
            }
            String to = this.aliases.get(alias);
            if (to == null) {
                return alias;
            }
            if (to.equals("")) {
                throw new IllegalArgumentException("Cannot alias to key '' (from %s)".formatted(alias));
            }
            String result = this.resolveAlias(to, visited);
            this.resolvedAliases.put(alias, result);
            return result;
        }

        public Map<String, TargetObjectSchema.AttributeSchema> resolveSchemas() {
            LinkedHashMap<String, TargetObjectSchema.AttributeSchema> resolved = new LinkedHashMap<String, TargetObjectSchema.AttributeSchema>(this.schemas);
            for (Map.Entry<String, String> ent : this.resolvedAliases.entrySet()) {
                resolved.put(ent.getKey(), this.schemas.getOrDefault(ent.getValue(), this.defaultSchema));
            }
            return resolved;
        }
    }

    public static class DefaultAttributeSchema
    implements TargetObjectSchema.AttributeSchema,
    Comparable<DefaultAttributeSchema> {
        private final String name;
        private final TargetObjectSchema.SchemaName schema;
        private final boolean isRequired;
        private final boolean isFixed;
        private final boolean isHidden;

        public DefaultAttributeSchema(String name, TargetObjectSchema.SchemaName schema, boolean isRequired, boolean isFixed, boolean isHidden) {
            if (name.equals("") && isRequired) {
                throw new IllegalArgumentException("The default attribute schema cannot be required");
            }
            this.name = name;
            this.schema = schema;
            this.isRequired = isRequired;
            this.isFixed = isFixed;
            this.isHidden = isHidden;
        }

        public String toString() {
            return String.format("<attr name=%s schema=%s required=%s fixed=%s hidden=%s>", this.name, this.schema, this.isRequired, this.isFixed, this.isHidden);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof DefaultAttributeSchema)) {
                return false;
            }
            DefaultAttributeSchema that = (DefaultAttributeSchema)obj;
            if (!Objects.equals(this.name, that.name)) {
                return false;
            }
            if (!Objects.equals(this.schema, that.schema)) {
                return false;
            }
            if (this.isRequired != that.isRequired) {
                return false;
            }
            if (this.isFixed != that.isFixed) {
                return false;
            }
            return this.isHidden == that.isHidden;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        @Override
        public int compareTo(DefaultAttributeSchema o) {
            return this.name.compareTo(o.name);
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public TargetObjectSchema.SchemaName getSchema() {
            return this.schema;
        }

        @Override
        public boolean isRequired() {
            return this.isRequired;
        }

        @Override
        public boolean isFixed() {
            return this.isFixed;
        }

        @Override
        public boolean isHidden() {
            return this.isHidden;
        }
    }
}

