/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.DefaultSchemaContext;
import ghidra.dbg.target.schema.DefaultTargetObjectSchema;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchema;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

@Deprecated(since="11.2")
public class SchemaBuilder {
    private final DefaultSchemaContext context;
    private final TargetObjectSchema.SchemaName name;
    private Class<?> type = TargetObject.class;
    private Set<Class<? extends TargetObject>> interfaces = new LinkedHashSet<Class<? extends TargetObject>>();
    private boolean isCanonicalContainer = false;
    private Map<String, TargetObjectSchema.SchemaName> elementSchemas = new LinkedHashMap<String, TargetObjectSchema.SchemaName>();
    private TargetObjectSchema.SchemaName defaultElementSchema = EnumerableTargetObjectSchema.OBJECT.getName();
    private TargetObjectSchema.ResyncMode elementResync = TargetObjectSchema.DEFAULT_ELEMENT_RESYNC;
    private Map<String, TargetObjectSchema.AttributeSchema> attributeSchemas = new LinkedHashMap<String, TargetObjectSchema.AttributeSchema>();
    private Map<String, String> attributeAliases = new LinkedHashMap<String, String>();
    private TargetObjectSchema.AttributeSchema defaultAttributeSchema = TargetObjectSchema.AttributeSchema.DEFAULT_ANY;
    private TargetObjectSchema.ResyncMode attributeResync = TargetObjectSchema.DEFAULT_ATTRIBUTE_RESYNC;
    private Map<String, Object> elementOrigins = new LinkedHashMap<String, Object>();
    private Map<String, Object> attributeOrigins = new LinkedHashMap<String, Object>();

    public SchemaBuilder(DefaultSchemaContext context, TargetObjectSchema.SchemaName name) {
        this.context = context;
        this.name = name;
    }

    public SchemaBuilder(DefaultSchemaContext context, TargetObjectSchema schema) {
        this(context, schema.getName());
        this.setType(schema.getType());
        this.setInterfaces(schema.getInterfaces());
        this.setCanonicalContainer(schema.isCanonicalContainer());
        this.elementSchemas.putAll(schema.getElementSchemas());
        this.setDefaultElementSchema(schema.getDefaultElementSchema());
        this.setElementResyncMode(schema.getElementResyncMode());
        this.attributeSchemas.putAll(schema.getAttributeSchemas());
        this.setDefaultAttributeSchema(schema.getDefaultAttributeSchema());
        this.setAttributeResyncMode(schema.getAttributeResyncMode());
    }

    public SchemaBuilder setType(Class<?> type) {
        this.type = type;
        return this;
    }

    public Class<?> getType() {
        return this.type;
    }

    public SchemaBuilder setInterfaces(Set<Class<? extends TargetObject>> interfaces) {
        this.interfaces.clear();
        this.interfaces.addAll(interfaces);
        return this;
    }

    public Set<Class<? extends TargetObject>> getInterfaces() {
        return Set.copyOf(this.interfaces);
    }

    public SchemaBuilder addInterface(Class<? extends TargetObject> iface) {
        this.interfaces.add(iface);
        return this;
    }

    public SchemaBuilder removeInterface(Class<? extends TargetObject> iface) {
        this.interfaces.remove(iface);
        return this;
    }

    public SchemaBuilder setCanonicalContainer(boolean isCanonicalContainer) {
        this.isCanonicalContainer = isCanonicalContainer;
        return this;
    }

    public boolean isCanonicalContaineration() {
        return this.isCanonicalContainer;
    }

    public SchemaBuilder addElementSchema(String index, TargetObjectSchema.SchemaName schema, Object origin) {
        if (index.equals("")) {
            return this.setDefaultElementSchema(schema);
        }
        if (this.elementSchemas.containsKey(index)) {
            throw new IllegalArgumentException("Duplicate element index '" + index + "' origin1=" + String.valueOf(this.elementOrigins.get(index)) + " origin2=" + String.valueOf(origin));
        }
        this.elementSchemas.put(index, schema);
        this.elementOrigins.put(index, origin);
        return this;
    }

    public SchemaBuilder removeElementSchema(String index) {
        if (index.equals("")) {
            return this.setDefaultElementSchema(EnumerableTargetObjectSchema.OBJECT.getName());
        }
        this.elementSchemas.remove(index);
        this.elementOrigins.remove(index);
        return this;
    }

    public Map<String, TargetObjectSchema.SchemaName> getElementSchemas() {
        return Map.copyOf(this.elementSchemas);
    }

    public SchemaBuilder setDefaultElementSchema(TargetObjectSchema.SchemaName defaultElementSchema) {
        this.defaultElementSchema = defaultElementSchema;
        return this;
    }

    public TargetObjectSchema.SchemaName getDefaultElementSchema() {
        return this.defaultElementSchema;
    }

    public SchemaBuilder setElementResyncMode(TargetObjectSchema.ResyncMode elementResync) {
        this.elementResync = elementResync;
        return this;
    }

    public TargetObjectSchema.ResyncMode getElementResyncMode() {
        return this.elementResync;
    }

    public SchemaBuilder addAttributeSchema(TargetObjectSchema.AttributeSchema schema, Object origin) {
        if (schema.getName().equals("")) {
            return this.setDefaultAttributeSchema(schema);
        }
        if (this.attributeOrigins.containsKey(schema.getName())) {
            throw new IllegalArgumentException("Duplicate attribute name '%s' adding schema origin1=%s origin2=%s".formatted(schema.getName(), this.attributeOrigins.get(schema.getName()), origin));
        }
        this.attributeSchemas.put(schema.getName(), schema);
        this.attributeOrigins.put(schema.getName(), origin);
        return this;
    }

    public SchemaBuilder removeAttributeSchema(String name) {
        if (name.equals("")) {
            return this.setDefaultAttributeSchema(TargetObjectSchema.AttributeSchema.DEFAULT_ANY);
        }
        this.attributeSchemas.remove(name);
        this.attributeAliases.remove(name);
        this.attributeOrigins.remove(name);
        return this;
    }

    public Map<String, TargetObjectSchema.AttributeSchema> getAttributeSchemas() {
        return Map.copyOf(this.attributeSchemas);
    }

    public TargetObjectSchema.AttributeSchema getAttributeSchema(String name) {
        return this.attributeSchemas.get(name);
    }

    public SchemaBuilder replaceAttributeSchema(TargetObjectSchema.AttributeSchema schema, Object origin) {
        if (schema.getName().equals("")) {
            return this.setDefaultAttributeSchema(schema);
        }
        this.attributeAliases.remove(schema.getName());
        this.attributeSchemas.put(schema.getName(), schema);
        this.attributeOrigins.put(schema.getName(), origin);
        return this;
    }

    protected void validateAlias(String from, String to) {
        if (from.equals("")) {
            throw new IllegalArgumentException("Key '' cannot be an alias");
        }
        if (to.equals("")) {
            throw new IllegalArgumentException("Cannot alias to key '' (from %s)".formatted(from));
        }
    }

    public SchemaBuilder addAttributeAlias(String from, String to, Object origin) {
        this.validateAlias(from, to);
        if (this.attributeOrigins.containsKey(from)) {
            throw new IllegalArgumentException("Duplicate attribute name '%s' adding alias origin1=%s origin2=%s".formatted(from, this.attributeOrigins.get(from), origin));
        }
        this.attributeAliases.put(from, to);
        this.attributeOrigins.put(from, origin);
        return this;
    }

    public SchemaBuilder replaceAttributeAlias(String from, String to, Object origin) {
        this.validateAlias(from, to);
        this.attributeSchemas.remove(from);
        this.attributeAliases.put(from, to);
        this.attributeOrigins.put(from, origin);
        return this;
    }

    public SchemaBuilder setDefaultAttributeSchema(TargetObjectSchema.AttributeSchema defaultAttributeSchema) {
        this.defaultAttributeSchema = defaultAttributeSchema;
        return this;
    }

    public TargetObjectSchema.AttributeSchema getDefaultAttributeSchema() {
        return this.defaultAttributeSchema;
    }

    public SchemaBuilder setAttributeResyncMode(TargetObjectSchema.ResyncMode attributeResync) {
        this.attributeResync = attributeResync;
        return this;
    }

    public TargetObjectSchema.ResyncMode getAttributeResyncMode() {
        return this.attributeResync;
    }

    public TargetObjectSchema buildAndAdd() {
        TargetObjectSchema schema = this.build();
        this.context.putSchema(schema);
        return schema;
    }

    public TargetObjectSchema build() {
        return new DefaultTargetObjectSchema(this.context, this.name, this.type, this.interfaces, this.isCanonicalContainer, this.elementSchemas, this.defaultElementSchema, this.elementResync, this.attributeSchemas, this.attributeAliases, this.defaultAttributeSchema, this.attributeResync);
    }
}

