/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.target.schema;

import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.DefaultSchemaContext;
import ghidra.dbg.target.schema.DefaultTargetObjectSchema;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.SchemaBuilder;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.util.Msg;
import ghidra.util.xml.XmlUtilities;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;

@Deprecated(since="11.2")
public class XmlSchemaContext
extends DefaultSchemaContext {
    protected static final String ELEM_CONTEXT = "context";
    protected static final String ATTR_CANONICAL = "canonical";
    protected static final String ELEM_SCHEMA = "schema";
    protected static final String ATTR_ELEMENT_RESYNC = "elementResync";
    protected static final String ATTR_ATTRIBUTE_RESYNC = "attributeResync";
    protected static final String ELEM_INTERFACE = "interface";
    protected static final String ELEM_ELEMENT = "element";
    protected static final String ATTR_INDEX = "index";
    protected static final String ELEM_ATTRIBUTE = "attribute";
    protected static final String ATTR_NAME = "name";
    protected static final String ATTR_SCHEMA = "schema";
    protected static final String ATTR_REQUIRED = "required";
    protected static final String ATTR_FIXED = "fixed";
    protected static final String ATTR_HIDDEN = "hidden";
    protected static final String ELEM_ATTRIBUTE_ALIAS = "attribute-alias";
    protected static final String ATTR_FROM = "from";
    protected static final String ATTR_TO = "to";
    protected static final String YES = "yes";
    protected static final Set<String> TRUES = Set.of("true", "yes", "y", "1");
    protected final Map<String, TargetObjectSchema.SchemaName> names = new HashMap<String, TargetObjectSchema.SchemaName>();

    protected static boolean parseBoolean(Element ele, String attrName) {
        return TRUES.contains(ele.getAttributeValue(attrName, "no").toLowerCase());
    }

    public static String serialize(SchemaContext ctx) {
        return XmlUtilities.toString((Element)XmlSchemaContext.contextToXml(ctx));
    }

    public static Element contextToXml(SchemaContext ctx) {
        Element result = new Element(ELEM_CONTEXT);
        for (TargetObjectSchema schema : ctx.getAllSchemas()) {
            Element schemaElem = XmlSchemaContext.schemaToXml(schema);
            if (schemaElem == null) continue;
            result.addContent((Content)schemaElem);
        }
        return result;
    }

    public static Element attributeSchemaToXml(TargetObjectSchema.AttributeSchema as) {
        Element attrElem = new Element(ELEM_ATTRIBUTE);
        if (!as.getName().equals("")) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)ATTR_NAME, (String)as.getName());
        }
        XmlUtilities.setStringAttr((Element)attrElem, (String)"schema", (String)as.getSchema().toString());
        if (as.isRequired()) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)ATTR_REQUIRED, (String)YES);
        }
        if (as.isFixed()) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)ATTR_FIXED, (String)YES);
        }
        if (as.isHidden()) {
            XmlUtilities.setStringAttr((Element)attrElem, (String)ATTR_HIDDEN, (String)YES);
        }
        return attrElem;
    }

    public static Element aliasToXml(Map.Entry<String, String> alias) {
        Element aliasElem = new Element(ELEM_ATTRIBUTE_ALIAS);
        XmlUtilities.setStringAttr((Element)aliasElem, (String)ATTR_FROM, (String)alias.getKey());
        XmlUtilities.setStringAttr((Element)aliasElem, (String)ATTR_TO, (String)alias.getValue());
        return aliasElem;
    }

    public static Element schemaToXml(TargetObjectSchema schema) {
        if (!TargetObject.class.isAssignableFrom(schema.getType())) {
            return null;
        }
        if (schema == EnumerableTargetObjectSchema.OBJECT) {
            return null;
        }
        Element result = new Element("schema");
        XmlUtilities.setStringAttr((Element)result, (String)ATTR_NAME, (String)schema.getName().toString());
        for (Class<? extends TargetObject> clazz : schema.getInterfaces()) {
            Element element = new Element(ELEM_INTERFACE);
            XmlUtilities.setStringAttr((Element)element, (String)ATTR_NAME, (String)DebuggerObjectModel.requireIfaceName(clazz));
            result.addContent((Content)element);
        }
        if (schema.isCanonicalContainer()) {
            XmlUtilities.setStringAttr((Element)result, (String)ATTR_CANONICAL, (String)YES);
        }
        XmlUtilities.setStringAttr((Element)result, (String)ATTR_ELEMENT_RESYNC, (String)schema.getElementResyncMode().name());
        XmlUtilities.setStringAttr((Element)result, (String)ATTR_ATTRIBUTE_RESYNC, (String)schema.getAttributeResyncMode().name());
        for (Map.Entry entry : schema.getElementSchemas().entrySet()) {
            Element element = new Element(ELEM_ELEMENT);
            XmlUtilities.setStringAttr((Element)element, (String)ATTR_INDEX, (String)((String)entry.getKey()));
            XmlUtilities.setStringAttr((Element)element, (String)"schema", (String)((TargetObjectSchema.SchemaName)entry.getValue()).toString());
            result.addContent((Content)element);
        }
        Element deElem = new Element(ELEM_ELEMENT);
        XmlUtilities.setStringAttr((Element)deElem, (String)"schema", (String)schema.getDefaultElementSchema().toString());
        result.addContent((Content)deElem);
        for (Map.Entry<String, TargetObjectSchema.AttributeSchema> entry : schema.getAttributeSchemas().entrySet()) {
            TargetObjectSchema.AttributeSchema as = entry.getValue();
            if (!entry.getKey().equals(as.getName())) continue;
            Element attrElem = XmlSchemaContext.attributeSchemaToXml(as);
            result.addContent((Content)attrElem);
        }
        TargetObjectSchema.AttributeSchema attributeSchema = schema.getDefaultAttributeSchema();
        Element element = XmlSchemaContext.attributeSchemaToXml(attributeSchema);
        result.addContent((Content)element);
        for (Map.Entry<String, String> alias : schema.getAttributeAliases().entrySet()) {
            Element aliasElem = XmlSchemaContext.aliasToXml(alias);
            result.addContent((Content)aliasElem);
        }
        return result;
    }

    public static XmlSchemaContext deserialize(String xml) throws JDOMException {
        return XmlSchemaContext.deserialize(xml.getBytes());
    }

    public static XmlSchemaContext deserialize(byte[] xml) throws JDOMException {
        try {
            return XmlSchemaContext.deserialize(new ByteArrayInputStream(xml));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static XmlSchemaContext deserialize(File file) throws JDOMException, IOException {
        return XmlSchemaContext.deserialize(new FileInputStream(file));
    }

    public static XmlSchemaContext deserialize(InputStream is) throws JDOMException, IOException {
        SAXBuilder sb = XmlUtilities.createSecureSAXBuilder((boolean)false, (boolean)false);
        Document doc = sb.build(Objects.requireNonNull(is));
        return XmlSchemaContext.contextFromXml(doc.getRootElement());
    }

    public static XmlSchemaContext contextFromXml(Element contextElem) {
        XmlSchemaContext ctx = new XmlSchemaContext();
        for (Element schemaElem : XmlUtilities.getChildren((Element)contextElem, (String)"schema")) {
            ctx.schemaFromXml(schemaElem);
        }
        return ctx;
    }

    public synchronized TargetObjectSchema.SchemaName name(String name) {
        return this.names.computeIfAbsent(name, TargetObjectSchema.SchemaName::new);
    }

    private String requireAttributeValue(Element elem, String name) {
        String value = elem.getAttributeValue(name);
        if (value == null) {
            throw new IllegalArgumentException("Missing attribute '%s' in %s".formatted(name, elem));
        }
        return value;
    }

    public TargetObjectSchema schemaFromXml(Element schemaElem) {
        TargetObjectSchema.SchemaName schema;
        SchemaBuilder builder = this.builder(this.name(schemaElem.getAttributeValue(ATTR_NAME, "")));
        for (Element ifaceElem : XmlUtilities.getChildren((Element)schemaElem, (String)ELEM_INTERFACE)) {
            String ifaceName = this.requireAttributeValue(ifaceElem, ATTR_NAME);
            Class<? extends TargetObject> iface = TargetObject.INTERFACES_BY_NAME.get(ifaceName);
            if (iface == null) {
                Msg.warn((Object)this, (Object)("Unknown interface name: '" + ifaceName + "'"));
                continue;
            }
            builder.addInterface(iface);
        }
        builder.setCanonicalContainer(XmlSchemaContext.parseBoolean(schemaElem, ATTR_CANONICAL));
        builder.setElementResyncMode(TargetObjectSchema.ResyncMode.valueOf(schemaElem.getAttributeValue(ATTR_ELEMENT_RESYNC, TargetObjectSchema.ResyncMode.NEVER.name())));
        builder.setAttributeResyncMode(TargetObjectSchema.ResyncMode.valueOf(schemaElem.getAttributeValue(ATTR_ATTRIBUTE_RESYNC, TargetObjectSchema.ResyncMode.NEVER.name())));
        for (Element elemElem : XmlUtilities.getChildren((Element)schemaElem, (String)ELEM_ELEMENT)) {
            schema = this.name(this.requireAttributeValue(elemElem, "schema"));
            String index = elemElem.getAttributeValue(ATTR_INDEX, "");
            builder.addElementSchema(index, schema, elemElem);
        }
        for (Element attrElem : XmlUtilities.getChildren((Element)schemaElem, (String)ELEM_ATTRIBUTE)) {
            schema = this.name(this.requireAttributeValue(attrElem, "schema"));
            boolean required = XmlSchemaContext.parseBoolean(attrElem, ATTR_REQUIRED);
            boolean fixed = XmlSchemaContext.parseBoolean(attrElem, ATTR_FIXED);
            boolean hidden = XmlSchemaContext.parseBoolean(attrElem, ATTR_HIDDEN);
            String name = attrElem.getAttributeValue(ATTR_NAME, "");
            builder.addAttributeSchema(new DefaultTargetObjectSchema.DefaultAttributeSchema(name, schema, required, fixed, hidden), attrElem);
        }
        for (Element aliasElem : XmlUtilities.getChildren((Element)schemaElem, (String)ELEM_ATTRIBUTE_ALIAS)) {
            String from = this.requireAttributeValue(aliasElem, ATTR_FROM);
            String to = this.requireAttributeValue(aliasElem, ATTR_TO);
            builder.addAttributeAlias(from, to, aliasElem);
        }
        return builder.buildAndAdd();
    }
}

