/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Set;

@Deprecated(since="11.2")
public class PathPattern
implements PathPredicates {
    private final List<String> pattern;

    public PathPattern(List<String> pattern) {
        this.pattern = List.copyOf(pattern);
    }

    public String toString() {
        return String.format("<PathPattern %s>", PathUtils.toString(this.pattern));
    }

    public String toPatternString() {
        return PathUtils.toString(this.pattern);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof PathPattern)) {
            return false;
        }
        PathPattern that = (PathPattern)obj;
        return Objects.equals(this.pattern, that.pattern);
    }

    public int hashCode() {
        return this.pattern.hashCode();
    }

    @Override
    public PathPredicates or(PathPredicates that) {
        if (this.equals(that)) {
            return this;
        }
        PathMatcher result = new PathMatcher();
        result.addPattern(this);
        if (that instanceof PathPattern) {
            result.addPattern(this);
        } else if (that instanceof PathMatcher) {
            PathMatcher matcher = (PathMatcher)that;
            result.patterns.addAll(matcher.patterns);
        } else {
            throw new AssertionError();
        }
        return result;
    }

    public static boolean isWildcard(String pat) {
        return "[]".equals(pat) || "".equals(pat);
    }

    protected boolean matchesUpTo(List<String> path, int length) {
        for (int i = 0; i < length; ++i) {
            if (PathPredicates.keyMatches(this.pattern.get(i), path.get(i))) continue;
            return false;
        }
        return true;
    }

    protected boolean matchesBackTo(List<String> path, int length) {
        int patternMax = this.pattern.size() - 1;
        int pathMax = path.size() - 1;
        for (int i = 0; i < length; ++i) {
            if (PathPredicates.keyMatches(this.pattern.get(patternMax - i), path.get(pathMax - i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean matches(List<String> path) {
        if (path.size() != this.pattern.size()) {
            return false;
        }
        return this.matchesUpTo(path, path.size());
    }

    @Override
    public boolean successorCouldMatch(List<String> path, boolean strict) {
        if (path.size() > this.pattern.size()) {
            return false;
        }
        if (strict && path.size() == this.pattern.size()) {
            return false;
        }
        return this.matchesUpTo(path, path.size());
    }

    @Override
    public boolean ancestorMatches(List<String> path, boolean strict) {
        if (path.size() < this.pattern.size()) {
            return false;
        }
        if (strict && path.size() == this.pattern.size()) {
            return false;
        }
        return this.matchesUpTo(path, this.pattern.size());
    }

    @Override
    public boolean ancestorCouldMatchRight(List<String> path, boolean strict) {
        if (path.size() > this.pattern.size()) {
            return false;
        }
        if (strict && path.size() == this.pattern.size()) {
            return false;
        }
        return this.matchesBackTo(path, path.size());
    }

    protected static boolean containsWildcards(List<String> pattern) {
        for (String pat : pattern) {
            if (!PathPattern.isWildcard(pat)) continue;
            return true;
        }
        return false;
    }

    @Override
    public List<String> getSingletonPath() {
        if (PathPattern.containsWildcards(this.pattern)) {
            return null;
        }
        return this.pattern;
    }

    public List<String> asPath() {
        return this.pattern;
    }

    public int countWildcards() {
        return (int)this.pattern.stream().filter(k -> PathPattern.isWildcard(k)).count();
    }

    @Override
    public PathPattern getSingletonPattern() {
        return this;
    }

    @Override
    public Collection<PathPattern> getPatterns() {
        return List.of(this);
    }

    @Override
    public Set<String> getNextKeys(List<String> path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        if (!this.matchesUpTo(path, path.size())) {
            return Set.of();
        }
        return Set.of(this.pattern.get(path.size()));
    }

    @Override
    public Set<String> getNextNames(List<String> path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        if (!this.matchesUpTo(path, path.size())) {
            return Set.of();
        }
        String pat = this.pattern.get(path.size());
        if (PathUtils.isName(pat)) {
            return Set.of(pat);
        }
        return Set.of();
    }

    @Override
    public Set<String> getNextIndices(List<String> path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        if (!this.matchesUpTo(path, path.size())) {
            return Set.of();
        }
        String pat = this.pattern.get(path.size());
        if (PathUtils.isIndex(pat)) {
            return Set.of(PathUtils.parseIndex(pat));
        }
        return Set.of();
    }

    @Override
    public Set<String> getPrevKeys(List<String> path) {
        if (path.size() >= this.pattern.size()) {
            return Set.of();
        }
        if (!this.matchesBackTo(path, path.size())) {
            return Set.of();
        }
        return Set.of(this.pattern.get(this.pattern.size() - 1 - path.size()));
    }

    @Override
    public boolean isEmpty() {
        return false;
    }

    @Override
    public PathPattern applyKeys(PathPredicates.Align align, List<String> indices) {
        List<String> result = Arrays.asList(new String[this.pattern.size()]);
        ListIterator<String> iit = align.iterator(indices);
        ListIterator<String> pit = align.iterator(this.pattern);
        while (pit.hasNext()) {
            int i = pit.nextIndex();
            String pat = pit.next();
            if (iit.hasNext() && PathPattern.isWildcard(pat)) {
                String index = iit.next();
                if (PathUtils.isIndex(pat)) {
                    result.set(i, PathUtils.makeKey(index));
                    continue;
                }
                result.set(i, index);
                continue;
            }
            result.set(i, pat);
        }
        return new PathPattern(result);
    }

    public List<String> matchKeys(List<String> path) {
        int length = this.pattern.size();
        if (length != path.size()) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>();
        for (int i = 0; i < length; ++i) {
            String key;
            String pat = this.pattern.get(i);
            if (!PathPredicates.keyMatches(pat, key = path.get(i))) {
                return null;
            }
            if (!PathPattern.isWildcard(pat)) continue;
            if (PathUtils.isIndex(pat)) {
                result.add(PathUtils.parseIndex(key));
                continue;
            }
            result.add(key);
        }
        return result;
    }

    public void doRemoveRight(int count, PathMatcher result) {
        if (count > this.pattern.size()) {
            return;
        }
        result.addPattern(this.pattern.subList(0, this.pattern.size() - count));
    }

    @Override
    public PathMatcher removeRight(int count) {
        PathMatcher result = new PathMatcher();
        this.doRemoveRight(count, result);
        return result;
    }
}

