/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import ghidra.async.AsyncFence;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathUtils;
import ghidra.util.ReversedListIterator;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

@Deprecated(since="11.2")
public interface PathPredicates {
    public static final PathPredicates EMPTY = new PathPredicates(){

        @Override
        public PathPredicates or(PathPredicates that) {
            return that;
        }

        @Override
        public boolean matches(List<String> path) {
            return false;
        }

        @Override
        public boolean successorCouldMatch(List<String> path, boolean strict) {
            return false;
        }

        @Override
        public boolean ancestorMatches(List<String> path, boolean strict) {
            return false;
        }

        @Override
        public boolean ancestorCouldMatchRight(List<String> path, boolean strict) {
            return false;
        }

        @Override
        public Set<String> getNextKeys(List<String> path) {
            return Set.of();
        }

        @Override
        public Set<String> getNextNames(List<String> path) {
            return Set.of();
        }

        @Override
        public Set<String> getNextIndices(List<String> path) {
            return Set.of();
        }

        @Override
        public Set<String> getPrevKeys(List<String> path) {
            return Set.of();
        }

        @Override
        public List<String> getSingletonPath() {
            return null;
        }

        @Override
        public PathPattern getSingletonPattern() {
            return null;
        }

        @Override
        public Collection<PathPattern> getPatterns() {
            return List.of();
        }

        @Override
        public PathPredicates removeRight(int count) {
            return this;
        }

        @Override
        public PathPredicates applyKeys(Align align, List<String> keys) {
            return this;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }
    };

    public static boolean keyMatches(String pat, String key) {
        if (key.equals(pat)) {
            return true;
        }
        if ("[]".equals(pat)) {
            return PathUtils.isIndex(key);
        }
        if ("".equals(pat)) {
            return PathUtils.isName(key);
        }
        return false;
    }

    public static boolean anyMatches(Set<String> pats, String key) {
        return pats.stream().anyMatch(p -> PathPredicates.keyMatches(p, key));
    }

    public static PathPredicates pattern(String ... keyPatterns) {
        return new PathPattern(List.of(keyPatterns));
    }

    public static PathPredicates pattern(List<String> keyPatterns) {
        return new PathPattern(keyPatterns);
    }

    public static PathPredicates parse(String pattern) {
        return new PathPattern(PathUtils.parse(pattern));
    }

    public PathPredicates or(PathPredicates var1);

    public boolean matches(List<String> var1);

    public boolean successorCouldMatch(List<String> var1, boolean var2);

    public boolean ancestorMatches(List<String> var1, boolean var2);

    public boolean ancestorCouldMatchRight(List<String> var1, boolean var2);

    public Set<String> getNextKeys(List<String> var1);

    public Set<String> getNextNames(List<String> var1);

    public Set<String> getNextIndices(List<String> var1);

    public Set<String> getPrevKeys(List<String> var1);

    public List<String> getSingletonPath();

    public PathPattern getSingletonPattern();

    public Collection<PathPattern> getPatterns();

    public PathPredicates removeRight(int var1);

    default public NavigableMap<List<String>, ?> getCachedValues(TargetObject seed) {
        return this.getCachedValues(List.of(), seed);
    }

    default public NavigableMap<List<String>, ?> getCachedValues(List<String> path, Object val) {
        TreeMap<List<String>, Object> result = new TreeMap<List<String>, Object>(PathUtils.PathComparator.KEYED);
        this.getCachedValues(result, path, val);
        return result;
    }

    default public void getCachedValues(Map<List<String>, Object> result, List<String> path, Object val) {
        if (this.matches(path)) {
            result.put(path, val);
        }
        if (val instanceof TargetObject && this.successorCouldMatch(path, true)) {
            Set<String> nextIndices;
            TargetObject cur = (TargetObject)val;
            Set<String> nextNames = this.getNextNames(path);
            if (!nextNames.isEmpty()) {
                for (Map.Entry<String, ?> ent : cur.getCachedAttributes().entrySet()) {
                    Object value = ent.getValue();
                    String name = ent.getKey();
                    if (!PathPredicates.anyMatches(nextNames, name)) continue;
                    this.getCachedValues(result, PathUtils.extend(path, name), value);
                }
            }
            if (!(nextIndices = this.getNextIndices(path)).isEmpty()) {
                for (Map.Entry<String, ? extends TargetObject> ent : cur.getCachedElements().entrySet()) {
                    TargetObject obj = ent.getValue();
                    String index = ent.getKey();
                    if (!PathPredicates.anyMatches(nextIndices, index)) continue;
                    this.getCachedValues(result, PathUtils.index(path, index), obj);
                }
            }
        }
    }

    default public NavigableMap<List<String>, TargetObject> getCachedSuccessors(TargetObject seed) {
        TreeMap<List<String>, TargetObject> result = new TreeMap<List<String>, TargetObject>(PathUtils.PathComparator.KEYED);
        this.getCachedSuccessors(result, List.of(), seed);
        return result;
    }

    default public void getCachedSuccessors(Map<List<String>, TargetObject> result, List<String> path, TargetObject cur) {
        block11: {
            Set<String> nextIndices;
            if (this.matches(path)) {
                result.put(path, cur);
            }
            if (!this.successorCouldMatch(path, true)) break block11;
            Set<String> nextNames = this.getNextNames(path);
            if (nextNames.equals(PathMatcher.WILD_SINGLETON)) {
                for (Map.Entry entry : cur.getCachedAttributes().entrySet()) {
                    Object v = entry.getValue();
                    if (!(v instanceof TargetObject)) continue;
                    TargetObject targetObject = (TargetObject)v;
                    name = (String)entry.getKey();
                    this.getCachedSuccessors(result, PathUtils.extend(path, (String)name), targetObject);
                }
            } else {
                for (String string : nextNames) {
                    name = cur.getCachedAttribute(string);
                    if (!(name instanceof TargetObject)) continue;
                    TargetObject targetObject = (TargetObject)name;
                    this.getCachedSuccessors(result, PathUtils.extend(path, string), targetObject);
                }
            }
            if ((nextIndices = this.getNextIndices(path)).equals(PathMatcher.WILD_SINGLETON)) {
                for (Map.Entry<String, ? extends TargetObject> entry : cur.getCachedElements().entrySet()) {
                    TargetObject obj = entry.getValue();
                    if (obj == null) {
                        return;
                    }
                    String index = entry.getKey();
                    this.getCachedSuccessors(result, PathUtils.index(path, index), obj);
                }
            } else {
                Map<String, ? extends TargetObject> map = cur.getCachedElements();
                for (String index : nextIndices) {
                    TargetObject obj = map.get(index);
                    if (obj == null) {
                        return;
                    }
                    this.getCachedSuccessors(result, PathUtils.index(path, index), obj);
                }
            }
        }
    }

    default public CompletableFuture<NavigableMap<List<String>, TargetObject>> fetchSuccessors(TargetObject seed) {
        TreeMap<List<String>, TargetObject> result = new TreeMap<List<String>, TargetObject>(PathUtils.PathComparator.KEYED);
        return this.fetchSuccessors(result, List.of(), seed).thenApply(__ -> result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    default public CompletableFuture<Void> fetchSuccessors(Map<List<String>, TargetObject> result, List<String> path, TargetObject cur) {
        AsyncFence fence = new AsyncFence();
        if (this.matches(path)) {
            Map<List<String>, TargetObject> map = result;
            synchronized (map) {
                result.put(path, cur);
            }
        }
        if (this.successorCouldMatch(path, true)) {
            Set<String> nextIndices;
            Set<String> nextNames = this.getNextNames(path);
            if (!nextNames.isEmpty()) {
                fence.include((CompletableFuture)cur.fetchAttributes().thenCompose(attrs -> {
                    AsyncFence aFence = new AsyncFence();
                    for (Map.Entry ent : attrs.entrySet()) {
                        String name;
                        Object value = ent.getValue();
                        if (!(value instanceof TargetObject) || !PathPredicates.anyMatches(nextNames, name = (String)ent.getKey())) continue;
                        TargetObject obj = (TargetObject)value;
                        aFence.include(this.fetchSuccessors(result, PathUtils.extend(path, name), obj));
                    }
                    return aFence.ready();
                }));
            }
            if (!(nextIndices = this.getNextIndices(path)).isEmpty()) {
                fence.include((CompletableFuture)cur.fetchElements().thenCompose(elems -> {
                    AsyncFence eFence = new AsyncFence();
                    for (Map.Entry ent : elems.entrySet()) {
                        TargetObject obj = (TargetObject)ent.getValue();
                        String index = (String)ent.getKey();
                        if (!PathPredicates.anyMatches(nextIndices, index)) continue;
                        eFence.include(this.fetchSuccessors(result, PathUtils.index(path, index), obj));
                    }
                    return eFence.ready();
                }));
            }
        }
        return fence.ready();
    }

    public PathPredicates applyKeys(Align var1, List<String> var2);

    default public PathPredicates applyKeys(Align align, String ... keys) {
        return this.applyKeys(align, List.of(keys));
    }

    default public PathPredicates applyKeys(String ... keys) {
        return this.applyKeys(Align.LEFT, keys);
    }

    default public PathPredicates applyIntKeys(int radix, Align align, List<Integer> keys) {
        return this.applyKeys(align, keys.stream().map(k -> Integer.toString(k, radix)).collect(Collectors.toList()));
    }

    default public PathPredicates applyIntKeys(int radix, Align align, int ... keys) {
        return this.applyKeys(align, IntStream.of(keys).mapToObj(k -> Integer.toString(k, radix)).collect(Collectors.toList()));
    }

    default public PathPredicates applyIntKeys(int ... keys) {
        return this.applyIntKeys(10, Align.LEFT, keys);
    }

    public boolean isEmpty();

    public static enum Align {
        LEFT{

            @Override
            <T> ListIterator<T> iterator(List<T> list) {
                return list.listIterator();
            }
        }
        ,
        RIGHT{

            @Override
            <T> ListIterator<T> iterator(List<T> list) {
                return new ReversedListIterator(list.listIterator(list.size()));
            }
        };


        abstract <T> ListIterator<T> iterator(List<T> var1);
    }
}

