/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Deprecated(since="11.2")
public final class PathUtils
extends Enum<PathUtils> {
    private static final /* synthetic */ PathUtils[] $VALUES;

    public static PathUtils[] values() {
        return (PathUtils[])$VALUES.clone();
    }

    public static PathUtils valueOf(String name) {
        return Enum.valueOf(PathUtils.class, name);
    }

    public static List<String> parse(String path, String sepRE) {
        return new PathParser(path, sepRE).parse();
    }

    public static List<String> parse(String path) {
        return PathUtils.parse(path, "\\.");
    }

    public static String toString(List<String> path, String sep) {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (String e : path) {
            if (!PathUtils.isIndex(e) && !first) {
                sb.append(sep);
            }
            first = false;
            sb.append(e);
        }
        return sb.toString();
    }

    public static String toString(List<String> path) {
        return PathUtils.toString(path, ".");
    }

    public static List<String> extend(List<String> path, String key) {
        ArrayList<String> result = new ArrayList<String>(path.size() + 1);
        result.addAll(path);
        result.add(key);
        return List.copyOf(result);
    }

    public static List<String> extend(List<String> path, List<String> sub) {
        ArrayList<String> result = new ArrayList<String>(path.size() + sub.size());
        result.addAll(path);
        result.addAll(sub);
        return List.copyOf(result);
    }

    public static String makeIndex(long i) {
        return Long.toString(i);
    }

    public static String makeIndex(int i) {
        return Integer.toString(i);
    }

    public static String makeKey(String index) {
        return "[" + index + "]";
    }

    public static List<String> index(List<String> path, String index) {
        return PathUtils.extend(path, PathUtils.makeKey(index));
    }

    public static List<String> parent(List<String> path) {
        if (path.isEmpty()) {
            return null;
        }
        return path.subList(0, path.size() - 1);
    }

    public static String getKey(List<String> path) {
        if (path.isEmpty()) {
            return null;
        }
        return path.get(path.size() - 1);
    }

    public static String parseIndex(String key) {
        if (PathUtils.isIndex(key)) {
            return key.substring(1, key.length() - 1);
        }
        throw new IllegalArgumentException("Index keys must be of the form '[index]'. Got " + key);
    }

    public static String getIndex(List<String> path) {
        String key = PathUtils.getKey(path);
        return key == null ? null : PathUtils.parseIndex(key);
    }

    public static boolean isIndex(String key) {
        return key == null ? false : key.startsWith("[") && key.endsWith("]");
    }

    public static boolean isIndex(List<String> path) {
        return PathUtils.isIndex(PathUtils.getKey(path));
    }

    public static boolean isName(String key) {
        return key == null ? false : !PathUtils.isIndex(key);
    }

    public static boolean isName(List<String> path) {
        return PathUtils.isName(PathUtils.getKey(path));
    }

    public static boolean isAncestor(List<String> ancestor, List<String> successor) {
        if (ancestor.size() > successor.size()) {
            return false;
        }
        return Objects.equals(ancestor, successor.subList(0, ancestor.size()));
    }

    public static List<String> relativize(List<String> ancestor, List<String> successor) {
        if (!PathUtils.isAncestor(ancestor, successor)) {
            throw new IllegalArgumentException("First must be an ancestor of the second");
        }
        return successor.subList(ancestor.size(), successor.size());
    }

    public static boolean isLink(List<String> parentPath, String name, List<String> attributePath) {
        return !Objects.equals(PathUtils.extend(parentPath, name), attributePath);
    }

    public static boolean isElementLink(List<String> parentPath, String index, List<String> elementPath) {
        return !Objects.equals(PathUtils.index(parentPath, index), elementPath);
    }

    public static boolean isHidden(String key) {
        return key.startsWith("_");
    }

    public static boolean isInvocation(String key) {
        return key.endsWith(")");
    }

    public static Map.Entry<String, String> parseInvocation(String name) {
        if (!PathUtils.isInvocation(name)) {
            throw new IllegalArgumentException("Invocation keys must be of the form 'method(params)'. Got " + name);
        }
        int i = name.indexOf(40);
        if (i == -1) {
            throw new IllegalArgumentException("Invocation keys must be of the form 'method(params)'. Got " + name);
        }
        return Map.entry(name.substring(0, i), name.substring(i + 1, name.length() - 1));
    }

    private static /* synthetic */ PathUtils[] $values() {
        return new PathUtils[0];
    }

    static {
        $VALUES = PathUtils.$values();
    }

    protected static class PathParser {
        protected static final Pattern LBRACKET = Pattern.compile("\\[");
        protected static final Pattern RBRACKET = Pattern.compile("\\]");
        protected static final Pattern BRACKETED = Pattern.compile("\\[.*?\\]");
        protected static final Pattern LPAREN = Pattern.compile("\\(");
        protected static final Pattern RPAREN = Pattern.compile("\\)");
        protected final CharBuffer buf;
        protected final Pattern sep;
        protected final List<String> result = new ArrayList<String>();

        protected PathParser(CharSequence path, String sepRE) {
            this.buf = CharBuffer.wrap(path);
            this.sep = Pattern.compile(sepRE);
        }

        protected String match(Pattern pat) {
            Matcher mat = pat.matcher(this.buf);
            if (!mat.lookingAt()) {
                throw new IllegalArgumentException("Expecting " + String.valueOf(pat) + ", but had " + String.valueOf(this.buf));
            }
            String tok = mat.group();
            int length = mat.end() - mat.start();
            this.buf.position(this.buf.position() + length);
            return tok;
        }

        protected void advanceParenthesized() {
            while (this.buf.hasRemaining()) {
                if (RPAREN.matcher(this.buf).lookingAt()) {
                    this.buf.get();
                    break;
                }
                if (LPAREN.matcher(this.buf).lookingAt()) {
                    this.buf.get();
                    this.advanceParenthesized();
                    continue;
                }
                this.buf.get();
            }
        }

        protected String parseName() {
            int p = this.buf.position();
            while (this.buf.hasRemaining() && !this.sep.matcher(this.buf).lookingAt() && !LBRACKET.matcher(this.buf).lookingAt()) {
                if (LPAREN.matcher(this.buf).lookingAt()) {
                    this.buf.get();
                    this.advanceParenthesized();
                    continue;
                }
                this.buf.get();
            }
            int e = this.buf.position();
            this.buf.position(p);
            String tok = this.buf.subSequence(0, e - p).toString();
            this.buf.position(e);
            return tok;
        }

        protected String parseNext() {
            if (this.sep.matcher(this.buf).lookingAt()) {
                this.match(this.sep);
                return this.parseName();
            }
            if (LBRACKET.matcher(this.buf).lookingAt()) {
                return this.match(BRACKETED);
            }
            throw new IllegalArgumentException("Expected " + String.valueOf(this.sep) + " or " + String.valueOf(LBRACKET) + ", but had " + String.valueOf(this.buf));
        }

        protected List<String> parse() {
            String first = this.parseName();
            if (first.length() != 0) {
                this.result.add(first);
            }
            while (this.buf.hasRemaining()) {
                this.result.add(this.parseNext());
            }
            return this.result;
        }
    }

    public static enum PathComparator implements Comparator<List<String>>
    {
        KEYED{

            @Override
            public int compare(List<String> o1, List<String> o2) {
                int min = Math.min(o1.size(), o2.size());
                for (int i = 0; i < min; ++i) {
                    String e2;
                    String e1 = o1.get(i);
                    int c = e1.compareTo(e2 = o2.get(i));
                    if (c == 0) continue;
                    return c;
                }
                return Integer.compare(o1.size(), o2.size());
            }
        }
        ,
        LONGEST_FIRST{

            @Override
            public int compare(List<String> o1, List<String> o2) {
                int c = Integer.compare(o2.size(), o1.size());
                if (c != 0) {
                    return c;
                }
                return KEYED.compare(o1, o2);
            }
        };

    }

    public static enum TargetObjectKeyComparator implements Comparator<String>
    {
        ATTRIBUTE{

            @Override
            public int compare(String o1, String o2) {
                return o1.compareTo(o2);
            }
        }
        ,
        ELEMENT{

            @Override
            public int compare(String o1, String o2) {
                String[] p1 = o1.split(",");
                String[] p2 = o2.split(",");
                int min = Math.min(p1.length, p2.length);
                for (int i = 0; i < min; ++i) {
                    int c = ELEMENT_DIM.compare(p1[i], p2[i]);
                    if (c == 0) continue;
                    return c;
                }
                return Integer.compare(p1.length, p2.length);
            }
        }
        ,
        ELEMENT_DIM{

            @Override
            public int compare(String o1, String o2) {
                Long l1 = null;
                Long l2 = null;
                try {
                    l1 = Long.parseLong(o1, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                try {
                    l2 = Long.parseLong(o2, 16);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
                if (l1 != null && l2 != null) {
                    return l1.compareTo(l2);
                }
                if (l1 != null) {
                    return -1;
                }
                if (l2 != null) {
                    return 1;
                }
                return o1.compareTo(o2);
            }
        }
        ,
        CHILD{

            @Override
            public int compare(String o1, String o2) {
                boolean ii2;
                boolean ii1 = o1.startsWith("[") && o1.endsWith("]");
                boolean bl = ii2 = o2.startsWith("[") && o2.endsWith("]");
                if (ii1 && ii2) {
                    return ELEMENT.compare(o1.substring(1, o1.length() - 1), o2.substring(1, o2.length() - 1));
                }
                if (ii1) {
                    return -1;
                }
                if (ii2) {
                    return 1;
                }
                return ATTRIBUTE.compare(o1, o2);
            }
        };

    }
}

