/*
 * Decompiled with CFR 0.152.
 */
package ghidra.dbg.util;

import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Deprecated(since="11.2")
public class ShellUtils {
    public static List<String> parseArgs(String args) {
        ArrayList<String> argsList = new ArrayList<String>();
        StringBuilder curArg = new StringBuilder();
        State state = State.NORMAL;
        block27: for (int i = 0; i < args.length(); ++i) {
            char c = args.charAt(i);
            switch (state.ordinal()) {
                case 0: {
                    switch (c) {
                        case '\\': {
                            state = State.NORMAL_ESCAPE;
                            continue block27;
                        }
                        case '\"': {
                            state = State.DQUOTE;
                            continue block27;
                        }
                        case '\'': {
                            state = State.SQUOTE;
                            continue block27;
                        }
                        case ' ': {
                            argsList.add(curArg.toString());
                            curArg.setLength(0);
                            continue block27;
                        }
                    }
                    curArg.append(c);
                    continue block27;
                }
                case 1: {
                    curArg.append(c);
                    state = State.NORMAL;
                    continue block27;
                }
                case 2: {
                    switch (c) {
                        case '\\': {
                            state = State.DQUOTE_ESCAPE;
                            continue block27;
                        }
                        case '\"': {
                            state = State.NORMAL;
                            continue block27;
                        }
                    }
                    curArg.append(c);
                    continue block27;
                }
                case 3: {
                    curArg.append(c);
                    state = State.DQUOTE;
                    continue block27;
                }
                case 4: {
                    switch (c) {
                        case '\\': {
                            state = State.SQUOTE_ESCAPE;
                            continue block27;
                        }
                        case '\'': {
                            state = State.NORMAL;
                            continue block27;
                        }
                    }
                    curArg.append(c);
                    continue block27;
                }
                case 5: {
                    curArg.append(c);
                    state = State.SQUOTE;
                    continue block27;
                }
                default: {
                    throw new AssertionError((Object)"Shouldn't be here!");
                }
            }
        }
        switch (state.ordinal()) {
            case 0: {
                if (curArg.length() == 0) break;
                argsList.add(curArg.toString());
                break;
            }
            case 2: 
            case 4: {
                throw new IllegalArgumentException("Unterminated string");
            }
            case 1: 
            case 3: 
            case 5: {
                throw new IllegalArgumentException("Incomplete escaped character");
            }
            default: {
                throw new AssertionError((Object)"Shouldn't be here!");
            }
        }
        return argsList;
    }

    public static String removePath(String exec) {
        return Paths.get(exec, new String[0]).getFileName().toString();
    }

    public static List<String> removePath(List<String> args) {
        if (args.isEmpty()) {
            return List.of();
        }
        ArrayList<String> copy = new ArrayList<String>(args);
        copy.set(0, ShellUtils.removePath(args.get(0)));
        return List.copyOf(copy);
    }

    public static String generateLine(List<String> args) {
        if (args.isEmpty()) {
            return "";
        }
        StringBuilder line = new StringBuilder(ShellUtils.genreateArgument(args.get(0)));
        for (int i = 1; i < args.size(); ++i) {
            String a = args.get(i);
            line.append(" " + ShellUtils.genreateArgument(a));
        }
        return line.toString();
    }

    public static String genreateArgument(String a) {
        if (a.contains(" ")) {
            if (a.contains("\"")) {
                if (a.contains("'")) {
                    return "\"" + a.replace("\"", "\\\"") + "\"";
                }
                return "'" + a + "'";
            }
            return "\"" + a + "\"";
        }
        return a;
    }

    public static String generateEnvBlock(Map<String, String> env) {
        return env.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue() + "\u0000").collect(Collectors.joining());
    }

    static enum State {
        NORMAL,
        NORMAL_ESCAPE,
        DQUOTE,
        DQUOTE_ESCAPE,
        SQUOTE,
        SQUOTE_ESCAPE;

    }
}

