/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.services;

import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.ServiceInfo;
import ghidra.trace.model.Trace;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.TriConsumer;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;

@ServiceInfo(defaultProviderName="ghidra.app.plugin.core.debug.service.tracemgr.DebuggerTraceManagerServicePlugin")
public interface DebuggerTraceManagerService {
    public Collection<Trace> getOpenTraces();

    public DebuggerCoordinates getCurrent();

    public DebuggerCoordinates getCurrentFor(Trace var1);

    public Trace getCurrentTrace();

    public TracePlatform getCurrentPlatform();

    public TraceProgramView getCurrentView();

    public TraceThread getCurrentThread();

    public long getCurrentSnap();

    public int getCurrentFrame();

    public TraceObject getCurrentObject();

    public void openTrace(Trace var1);

    public Trace openTrace(DomainFile var1, int var2);

    public Collection<Trace> openTraces(Collection<DomainFile> var1);

    public CompletableFuture<Void> saveTrace(Trace var1);

    public void closeTrace(Trace var1);

    public void closeTraceNoConfirm(Trace var1);

    public void closeAllTraces();

    public void closeOtherTraces(Trace var1);

    public void closeDeadTraces();

    public CompletableFuture<Void> activateAndNotify(DebuggerCoordinates var1, ActivationCause var2);

    default public void activate(DebuggerCoordinates coordinates) {
        this.activate(coordinates, ActivationCause.USER);
    }

    public void activate(DebuggerCoordinates var1, ActivationCause var2);

    public DebuggerCoordinates resolveTrace(Trace var1);

    default public void activateTrace(Trace trace) {
        this.activate(this.resolveTrace(trace));
    }

    public DebuggerCoordinates resolveTarget(Target var1);

    default public void activateTarget(Target target) {
        this.activate(this.resolveTarget(target));
    }

    public DebuggerCoordinates resolvePlatform(TracePlatform var1);

    default public void activatePlatform(TracePlatform platform) {
        this.activate(this.resolvePlatform(platform));
    }

    public DebuggerCoordinates resolveThread(TraceThread var1);

    default public void activateThread(TraceThread thread) {
        this.activate(this.resolveThread(thread));
    }

    public DebuggerCoordinates resolveSnap(long var1);

    default public void activateSnap(long snap) {
        this.activate(this.resolveSnap(snap));
    }

    public DebuggerCoordinates resolveTime(TraceSchedule var1);

    default public void activateTime(TraceSchedule time) {
        this.activate(this.resolveTime(time));
    }

    public DebuggerCoordinates resolveView(TraceProgramView var1);

    public DebuggerCoordinates resolveFrame(int var1);

    default public void activateFrame(int frameLevel) {
        this.activate(this.resolveFrame(frameLevel));
    }

    public DebuggerCoordinates resolvePath(TraceObjectKeyPath var1);

    default public void activatePath(TraceObjectKeyPath path) {
        this.activate(this.resolvePath(path));
    }

    public DebuggerCoordinates resolveObject(TraceObject var1);

    default public void activateObject(TraceObject object) {
        this.activate(this.resolveObject(object));
    }

    public void setSaveTracesByDefault(boolean var1);

    public boolean isSaveTracesByDefault();

    public void addSaveTracesByDefaultChangeListener(BooleanChangeAdapter var1);

    public void removeSaveTracesByDefaultChangeListener(BooleanChangeAdapter var1);

    public void setAutoCloseOnTerminate(boolean var1);

    public boolean isAutoCloseOnTerminate();

    public void addAutoCloseOnTerminateChangeListener(BooleanChangeAdapter var1);

    public void removeAutoCloseOnTerminateChangeListener(BooleanChangeAdapter var1);

    public Long findSnapshot(DebuggerCoordinates var1);

    public CompletableFuture<Long> materialize(DebuggerCoordinates var1);

    public static enum ActivationCause {
        USER,
        START_RECORDING,
        SYNC_MODEL,
        FOLLOW_PRESENT,
        EMU_STATE_EDIT,
        MAPPER_CHANGED,
        ACTIVATE_DEFAULT,
        RESTORE_STATE;

    }

    public static interface BooleanChangeAdapter
    extends TriConsumer<Boolean, Boolean, Void> {
        default public void accept(Boolean oldVal, Boolean newVal, Void cause) {
            this.changed(newVal);
        }

        public void changed(Boolean var1);
    }
}

