/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.api.tracermi;

import ghidra.debug.api.ValStr;
import ghidra.debug.api.tracermi.LaunchParameter;
import ghidra.debug.api.tracermi.TerminalSession;
import ghidra.debug.api.tracermi.TraceRmiAcceptor;
import ghidra.debug.api.tracermi.TraceRmiConnection;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;

public interface TraceRmiLaunchOffer {
    public LaunchResult launchProgram(TaskMonitor var1, LaunchConfigurator var2);

    default public LaunchResult launchProgram(TaskMonitor monitor) {
        return this.launchProgram(monitor, LaunchConfigurator.NOP);
    }

    public String getConfigName();

    public Icon getIcon();

    default public List<String> getMenuPath() {
        return List.of(this.getTitle());
    }

    public String getTitle();

    public String getDescription();

    default public String getMenuGroup() {
        return "";
    }

    default public String getMenuOrder() {
        return "";
    }

    default public HelpLocation getHelpLocation() {
        return new HelpLocation("TraceRmiPlugin", "launch");
    }

    public Map<String, LaunchParameter<?>> getParameters();

    public boolean requiresImage();

    public static interface LaunchConfigurator {
        public static final LaunchConfigurator NOP = new LaunchConfigurator(){};

        default public PromptMode getPromptMode() {
            return PromptMode.NEVER;
        }

        default public Map<String, ValStr<?>> configureLauncher(TraceRmiLaunchOffer offer, Map<String, ValStr<?>> arguments, RelPrompt relPrompt) {
            return arguments;
        }
    }

    public record LaunchResult(Program program, Map<String, TerminalSession> sessions, TraceRmiAcceptor acceptor, TraceRmiConnection connection, Trace trace, Throwable exception) implements AutoCloseable
    {
        public LaunchResult(Program program, Map<String, TerminalSession> sessions, TraceRmiAcceptor acceptor, TraceRmiConnection connection, Trace trace, Throwable exception) {
            this.program = program;
            this.sessions = sessions;
            this.acceptor = acceptor == null || acceptor.isClosed() ? null : acceptor;
            this.connection = connection;
            this.trace = trace;
            this.exception = exception;
        }

        public void showTerminals() {
            for (TerminalSession session : this.sessions.values()) {
                session.show();
            }
        }

        @Override
        public void close() throws Exception {
            if (this.connection != null) {
                this.connection.close();
            }
            if (this.acceptor != null) {
                this.acceptor.cancel();
            }
            for (TerminalSession s : this.sessions.values()) {
                s.close();
            }
        }
    }

    public static enum PromptMode {
        ALWAYS,
        NEVER,
        ON_ERROR;

    }

    public static enum RelPrompt {
        NONE,
        BEFORE,
        AFTER;

    }
}

