/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.flatapi;

import docking.ActionContext;
import ghidra.app.script.GhidraState;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.DebuggerTargetService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.debug.api.breakpoint.LogicalBreakpoint;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.model.DebuggerObjectActionContext;
import ghidra.debug.api.model.DebuggerSingleObjectPathActionContext;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectChangedEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.pcode.exec.trace.TraceSleighUtils;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.CompilerSpec;
import ghidra.program.model.lang.Language;
import ghidra.program.model.lang.Register;
import ghidra.program.model.lang.RegisterValue;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.guest.TracePlatform;
import ghidra.trace.model.memory.TraceMemorySpace;
import ghidra.trace.model.program.TraceProgramView;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.util.MathUtilities;
import ghidra.util.Swing;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

public interface FlatDebuggerAPI {
    default public <T> T waitOn(CompletableFuture<T> cf) throws InterruptedException, ExecutionException, TimeoutException {
        return cf.get(1L, TimeUnit.MINUTES);
    }

    public GhidraState getState();

    default public <T> T requireService(Class<T> cls) {
        Object service = this.getState().getTool().getService(cls);
        if (service == null) {
            throw new IllegalStateException("Tool does not have service " + String.valueOf(cls) + "! This script should be run from the Debugger tool");
        }
        return (T)service;
    }

    default public DebuggerTraceManagerService getTraceManager() {
        return this.requireService(DebuggerTraceManagerService.class);
    }

    default public void openTrace(Trace trace) {
        this.getTraceManager().openTrace(trace);
    }

    default public void closeTrace(Trace trace) {
        this.getTraceManager().closeTrace(trace);
    }

    default public DebuggerCoordinates getCurrentDebuggerCoordinates() {
        return this.getTraceManager().getCurrent();
    }

    default public Trace getCurrentTrace() {
        return this.getTraceManager().getCurrentTrace();
    }

    default public Trace requireCurrentTrace() {
        Trace trace = this.getCurrentTrace();
        if (trace == null) {
            throw new IllegalStateException("There is no current trace");
        }
        return trace;
    }

    default public Trace requireTrace(Trace trace) {
        if (trace == null) {
            throw new IllegalStateException("There is no trace");
        }
        return trace;
    }

    default public TracePlatform getCurrentPlatform() {
        return this.getTraceManager().getCurrentPlatform();
    }

    default public TracePlatform requireCurrentPlatform() {
        TracePlatform platform = this.getCurrentPlatform();
        if (platform == null) {
            throw new IllegalStateException("There is no current trace");
        }
        return platform;
    }

    default public TracePlatform requirePlatform(TracePlatform platform) {
        if (platform == null) {
            throw new IllegalStateException("There is no platform");
        }
        return platform;
    }

    default public TraceThread getCurrentThread() {
        return this.getTraceManager().getCurrentThread();
    }

    default public TraceThread requireCurrentThread() {
        TraceThread thread = this.getCurrentThread();
        if (thread == null) {
            throw new IllegalStateException("There is no current thread");
        }
        return thread;
    }

    default public TraceThread requireThread(TraceThread thread) {
        if (thread == null) {
            throw new IllegalStateException("There is no thread");
        }
        return thread;
    }

    default public TraceProgramView getCurrentView() {
        return this.getTraceManager().getCurrentView();
    }

    default public TraceProgramView requireCurrentView() {
        TraceProgramView view = this.getCurrentView();
        if (view == null) {
            throw new IllegalStateException("There is no current trace view");
        }
        return view;
    }

    default public int getCurrentFrame() {
        return this.getTraceManager().getCurrentFrame();
    }

    default public long getCurrentSnap() {
        return this.getTraceManager().getCurrentSnap();
    }

    default public TraceSchedule getCurrentEmulationSchedule() {
        return this.getTraceManager().getCurrent().getTime();
    }

    default public void activateTrace(Trace trace) {
        DebuggerTraceManagerService manager = this.getTraceManager();
        if (trace == null) {
            manager.activateTrace(null);
            return;
        }
        if (!manager.getOpenTraces().contains(trace)) {
            manager.openTrace(trace);
        }
        manager.activateTrace(trace);
    }

    default public void activateThread(TraceThread thread) {
        DebuggerTraceManagerService manager = this.getTraceManager();
        if (thread == null) {
            manager.activateThread(null);
            return;
        }
        Trace trace = thread.getTrace();
        if (!manager.getOpenTraces().contains(trace)) {
            manager.openTrace(trace);
        }
        manager.activateThread(thread);
    }

    default public void activateFrame(int frame) {
        this.getTraceManager().activateFrame(frame);
    }

    default public void activateSnap(long snap) {
        this.getTraceManager().activateSnap(snap);
    }

    default public DebuggerListingService getDebuggerListing() {
        return this.requireService(DebuggerListingService.class);
    }

    default public ProgramLocation getCurrentDebuggerProgramLocation() {
        return this.getDebuggerListing().getCurrentLocation();
    }

    default public Address getCurrentDebuggerAddress() {
        ProgramLocation loc = this.getCurrentDebuggerProgramLocation();
        return loc == null ? null : loc.getAddress();
    }

    default public boolean goToDynamic(ProgramLocation location) {
        return this.getDebuggerListing().goTo(location, true);
    }

    default public boolean goToDynamic(Address address) {
        return this.goToDynamic(this.dynamicLocation(address));
    }

    default public boolean goToDynamic(String addrString) {
        return this.goToDynamic(this.dynamicLocation(addrString));
    }

    default public DebuggerStaticMappingService getMappingService() {
        return this.requireService(DebuggerStaticMappingService.class);
    }

    default public Program getCurrentProgram() {
        return this.getState().getCurrentProgram();
    }

    default public Program requireCurrentProgram() {
        Program program = this.getCurrentProgram();
        if (program == null) {
            throw new IllegalStateException("There is no current program");
        }
        return program;
    }

    default public ProgramLocation translateStaticToDynamic(ProgramLocation location) {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        Trace trace = this.requireCurrentTrace();
        TraceLocation tloc = this.getMappingService().getOpenMappedLocation(trace, location, current.getSnap());
        return tloc == null ? null : new ProgramLocation((Program)current.getView(), tloc.getAddress());
    }

    default public Address translateStaticToDynamic(Address address) {
        Program program = this.requireCurrentProgram();
        ProgramLocation dloc = this.translateStaticToDynamic(new ProgramLocation(program, address));
        return dloc == null ? null : dloc.getByteAddress();
    }

    default public ProgramLocation translateDynamicToStatic(ProgramLocation location) {
        return this.getMappingService().getStaticLocationFromDynamic(location);
    }

    default public Address translateDynamicToStatic(Address address) {
        Program program = this.requireCurrentProgram();
        TraceProgramView view = this.requireCurrentView();
        ProgramLocation sloc = this.translateDynamicToStatic(new ProgramLocation((Program)view, address));
        return sloc == null ? null : (sloc.getProgram() != program ? null : sloc.getByteAddress());
    }

    default public DebuggerEmulationService getEmulationService() {
        return this.requireService(DebuggerEmulationService.class);
    }

    default public Trace emulateLaunch(Program program, Address address) throws IOException {
        return this.getEmulationService().launchProgram(program, address);
    }

    default public Trace emulateLaunch(Address address) throws IOException {
        return this.emulateLaunch(this.requireCurrentProgram(), address);
    }

    default public boolean emulate(TracePlatform platform, TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        this.getEmulationService().emulate(platform, time, monitor);
        this.getTraceManager().activateTime(time);
        return true;
    }

    default public boolean emulate(Trace trace, TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        return this.emulate(trace.getPlatformManager().getHostPlatform(), time, monitor);
    }

    default public boolean emulate(TraceSchedule time, TaskMonitor monitor) throws CancelledException {
        return this.emulate(this.requireCurrentPlatform(), time, monitor);
    }

    default public boolean stepEmuInstruction(long count, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule stepped = count <= 0L ? time.steppedBackward(platform.getTrace(), -count) : time.steppedForward(this.requireThread(thread), count);
        return this.emulate(platform, stepped, monitor);
    }

    default public boolean stepEmuPcodeOp(int count, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule stepped = count <= 0 ? time.steppedPcodeBackward(-count) : time.steppedPcodeForward(this.requireThread(thread), count);
        return this.emulate(platform, stepped, monitor);
    }

    default public boolean skipEmuInstruction(long count, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule stepped = count <= 0L ? time.steppedBackward(platform.getTrace(), -count) : time.skippedForward(this.requireThread(thread), count);
        return this.emulate(platform, stepped, monitor);
    }

    default public boolean skipEmuPcodeOp(int count, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule stepped = count <= 0 ? time.steppedPcodeBackward(-count) : time.skippedPcodeForward(this.requireThread(thread), count);
        return this.emulate(platform, stepped, monitor);
    }

    default public boolean patchEmu(String sleigh, TaskMonitor monitor) throws CancelledException {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        TracePlatform platform = this.requireCurrentPlatform();
        TraceThread thread = current.getThread();
        TraceSchedule time = current.getTime();
        TraceSchedule patched = time.patched(this.requireThread(thread), platform.getLanguage(), sleigh);
        return this.emulate(platform, patched, monitor);
    }

    default public AddressRange safeRange(Address start, int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length < 0");
        }
        long maxLength = start.getAddressSpace().getMaxAddress().subtract(start);
        try {
            return new AddressRangeImpl(start, (long)MathUtilities.unsignedMin((int)length, (long)maxLength));
        }
        catch (AddressOverflowException e) {
            throw new AssertionError((Object)e);
        }
    }

    default public DebuggerTargetService getTargetService() {
        return this.requireService(DebuggerTargetService.class);
    }

    default public void refreshMemoryIfLive(Trace trace, long snap, Address start, int length, TaskMonitor monitor) throws CancelledException {
        Target target = this.getTargetService().getTarget(trace);
        if (target == null || target.getSnap() != snap) {
            return;
        }
        target.readMemory((AddressSetView)new AddressSet(this.safeRange(start, length)), monitor);
    }

    default public int readMemory(Trace trace, long snap, Address start, byte[] buffer, TaskMonitor monitor) throws CancelledException {
        this.refreshMemoryIfLive(trace, snap, start, buffer.length, monitor);
        return trace.getMemoryManager().getViewBytes(snap, start, ByteBuffer.wrap(buffer));
    }

    default public byte[] readMemory(Trace trace, long snap, Address start, int length, TaskMonitor monitor) throws CancelledException {
        byte[] arr = new byte[length];
        int actual = this.readMemory(trace, snap, start, arr, monitor);
        if (actual == length) {
            return arr;
        }
        return Arrays.copyOf(arr, actual);
    }

    default public int readMemory(Address start, byte[] buffer, TaskMonitor monitor) throws CancelledException {
        TraceProgramView view = this.requireCurrentView();
        return this.readMemory(view.getTrace(), view.getSnap(), start, buffer, monitor);
    }

    default public byte[] readMemory(Address start, int length, TaskMonitor monitor) throws CancelledException {
        TraceProgramView view = this.requireCurrentView();
        return this.readMemory(view.getTrace(), view.getSnap(), start, length, monitor);
    }

    default public Address searchMemory(Trace trace, long snap, AddressRange range, ByteBuffer data, ByteBuffer mask, boolean forward, TaskMonitor monitor) {
        return trace.getMemoryManager().findBytes(snap, range, data, mask, forward, monitor);
    }

    default public Address searchMemory(Trace trace, long snap, AddressRange range, byte[] data, byte[] mask, boolean forward, TaskMonitor monitor) {
        return this.searchMemory(trace, snap, range, ByteBuffer.wrap(data), mask == null ? null : ByteBuffer.wrap(mask), forward, monitor);
    }

    default public void refreshRegistersIfLive(TracePlatform platform, TraceThread thread, int frame, long snap, Collection<Register> registers) {
        Set s;
        Trace trace = thread.getTrace();
        Target target = this.getTargetService().getTarget(trace);
        if (target == null || target.getSnap() != snap) {
            return;
        }
        Set asSet = registers instanceof Set ? (s = (Set)registers) : Set.copyOf(registers);
        target.readRegisters(platform, thread, frame, asSet);
    }

    default public List<RegisterValue> readRegisters(TracePlatform platform, TraceThread thread, int frame, long snap, Collection<Register> registers) {
        this.refreshRegistersIfLive(platform, thread, frame, snap, registers);
        TraceMemorySpace regs = thread.getTrace().getMemoryManager().getMemoryRegisterSpace(thread, frame, false);
        if (regs == null) {
            return registers.stream().map(RegisterValue::new).collect(Collectors.toList());
        }
        return registers.stream().map(r -> regs.getValue(snap, r)).collect(Collectors.toList());
    }

    default public RegisterValue readRegister(TracePlatform platform, TraceThread thread, int frame, long snap, Register register) {
        List<RegisterValue> result = this.readRegisters(platform, thread, frame, snap, Set.of(register));
        return result == null ? null : result.get(0);
    }

    default public List<RegisterValue> readRegisters(Collection<Register> registers) {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        return this.readRegisters(this.requireCurrentPlatform(), this.requireThread(current.getThread()), current.getFrame(), current.getSnap(), registers);
    }

    default public List<Register> validateRegisterNames(Language language, Collection<String> names) {
        ArrayList<String> invalid = new ArrayList<String>();
        ArrayList<Register> result = new ArrayList<Register>();
        for (String n : names) {
            Register register = language.getRegister(n);
            if (register != null) {
                result.add(register);
                continue;
            }
            invalid.add(n);
        }
        if (!invalid.isEmpty()) {
            throw new IllegalArgumentException("One or more invalid register names: " + String.valueOf(invalid));
        }
        return result;
    }

    default public Register validateRegisterName(Language language, String name) {
        Register register = language.getRegister(name);
        if (register == null) {
            throw new IllegalArgumentException("Invalid register name: " + name);
        }
        return register;
    }

    default public List<RegisterValue> readRegistersNamed(Collection<String> names) {
        return this.readRegisters(this.validateRegisterNames(this.requireCurrentTrace().getBaseLanguage(), names));
    }

    default public RegisterValue readRegister(TracePlatform platform, Register register) {
        DebuggerCoordinates current = this.getCurrentDebuggerCoordinates();
        if (platform.getTrace() != current.getTrace()) {
            throw new IllegalArgumentException("Given platform is not from the current trace");
        }
        Language language = platform.getLanguage();
        if (!register.equals((Object)language.getRegister(register.getName()))) {
            throw new IllegalArgumentException("Register " + String.valueOf(register) + " is not in language " + String.valueOf(language));
        }
        return this.readRegister(platform, this.requireThread(current.getThread()), current.getFrame(), current.getSnap(), register);
    }

    default public RegisterValue readRegister(Register register) {
        return this.readRegister(this.requireCurrentPlatform(), register);
    }

    default public RegisterValue readRegister(String name) {
        TracePlatform platform = this.requireCurrentPlatform();
        Register register = this.validateRegisterName(platform.getLanguage(), name);
        return this.readRegister(platform, register);
    }

    default public BigInteger evaluate(DebuggerCoordinates coordinates, String expression) {
        return TraceSleighUtils.evaluate((String)expression, (Trace)coordinates.getTrace(), (long)coordinates.getViewSnap(), (TraceThread)coordinates.getThread(), (int)coordinates.getFrame());
    }

    default public BigInteger evaluate(String expression) {
        return this.evaluate(this.getCurrentDebuggerCoordinates(), expression);
    }

    default public Address getProgramCounter(DebuggerCoordinates coordinates) {
        TracePlatform platform = this.requirePlatform(coordinates.getPlatform());
        Language language = platform.getLanguage();
        RegisterValue value = this.readRegister(platform, this.requireThread(coordinates.getThread()), coordinates.getFrame(), coordinates.getSnap(), language.getProgramCounter());
        if (value == null || !value.hasValue()) {
            return null;
        }
        return language.getDefaultSpace().getAddress(value.getUnsignedValue().longValue());
    }

    default public Address getProgramCounter() {
        return this.getProgramCounter(this.getCurrentDebuggerCoordinates());
    }

    default public Address getStackPointer(DebuggerCoordinates coordinates) {
        TracePlatform platform = this.requirePlatform(coordinates.getPlatform());
        CompilerSpec cSpec = platform.getCompilerSpec();
        RegisterValue value = this.readRegister(platform, this.requireThread(coordinates.getThread()), coordinates.getFrame(), coordinates.getSnap(), cSpec.getStackPointer());
        if (!value.hasValue()) {
            return null;
        }
        return cSpec.getStackBaseSpace().getAddress(value.getUnsignedValue().longValue());
    }

    default public Address getStackPointer() {
        return this.getStackPointer(this.getCurrentDebuggerCoordinates());
    }

    default public DebuggerControlService getControlService() {
        return this.requireService(DebuggerControlService.class);
    }

    default public void setControlMode(Trace trace, ControlMode mode) {
        this.requireService(DebuggerControlService.class).setCurrentMode(trace, mode);
    }

    default public void setControlMode(ControlMode mode) {
        this.setControlMode(this.requireCurrentTrace(), mode);
    }

    default public DebuggerControlService.StateEditor createStateEditor(DebuggerCoordinates coordinates) {
        return this.getControlService().createStateEditor(coordinates);
    }

    default public DebuggerControlService.StateEditor createStateEditor(Trace trace, long snap) {
        return this.getControlService().createStateEditor(this.getTraceManager().resolveTrace(trace).snap(snap));
    }

    default public DebuggerControlService.StateEditor createStateEditor(TraceThread thread, int frame, long snap) {
        return this.getControlService().createStateEditor(this.getTraceManager().resolveThread(thread).snap(snap).frame(frame));
    }

    default public DebuggerControlService.StateEditor createStateEditor() {
        return this.createStateEditor(this.getCurrentDebuggerCoordinates());
    }

    default public boolean writeMemory(DebuggerControlService.StateEditor editor, Address start, byte[] data) {
        if (!editor.isVariableEditable(start, data.length)) {
            return false;
        }
        try {
            this.waitOn(editor.setVariable(start, data));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean writeMemory(Trace trace, long snap, Address start, byte[] data) {
        return this.writeMemory(this.createStateEditor(trace, snap), start, data);
    }

    default public boolean writeMemory(Address start, byte[] data) {
        return this.writeMemory(this.createStateEditor(), start, data);
    }

    default public boolean writeRegister(DebuggerControlService.StateEditor editor, RegisterValue rv) {
        if (!editor.isRegisterEditable(rv.getRegister())) {
            return false;
        }
        try {
            this.waitOn(editor.setRegister(rv));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean writeRegister(TraceThread thread, int frame, long snap, RegisterValue rv) {
        return this.writeRegister(this.createStateEditor(thread, frame, snap), rv);
    }

    default public boolean writeRegister(TraceThread thread, int frame, long snap, String name, BigInteger value) {
        return this.writeRegister(thread, frame, snap, new RegisterValue(this.validateRegisterName(thread.getTrace().getBaseLanguage(), name), value));
    }

    default public boolean writeRegister(RegisterValue rv) {
        return this.writeRegister(this.createStateEditor(), rv);
    }

    default public boolean writeRegister(String name, BigInteger value) {
        return this.writeRegister(new RegisterValue(this.validateRegisterName(this.requireCurrentTrace().getBaseLanguage(), name), value));
    }

    default public ActionContext createContext(TraceObject object) {
        TraceObjectValue value = (TraceObjectValue)object.getCanonicalParents((Lifespan)Lifespan.ALL).findAny().orElseThrow();
        return new DebuggerObjectActionContext(List.of(value), null, null);
    }

    default public ActionContext createContext(TraceThread thread) {
        if (thread instanceof TraceObjectThread) {
            TraceObjectThread objThread = (TraceObjectThread)thread;
            return this.createContext(objThread.getObject());
        }
        return new DebuggerSingleObjectPathActionContext(TraceObjectKeyPath.parse((String)thread.getPath()));
    }

    default public ActionContext createContext(Trace trace) {
        DebuggerCoordinates coords = this.getTraceManager().getCurrentFor(trace);
        if (coords == null) {
            return new DebuggerSingleObjectPathActionContext(TraceObjectKeyPath.of((String[])new String[0]));
        }
        if (coords.getObject() != null) {
            return this.createContext(coords.getObject());
        }
        if (coords.getPath() != null) {
            return new DebuggerSingleObjectPathActionContext(coords.getPath());
        }
        return new DebuggerSingleObjectPathActionContext(TraceObjectKeyPath.of((String[])new String[0]));
    }

    default public Target.ActionEntry findAction(Target target, ActionName action, ActionContext context) {
        return target.collectActions(action, context).values().stream().filter(e -> !e.requiresPrompt()).sorted(Comparator.comparing(e -> -e.specificity())).findFirst().orElseThrow();
    }

    default public Object doAction(Target target, ActionName name, ActionContext context) {
        Target.ActionEntry action = this.findAction(target, name, context);
        return action.get(false);
    }

    default public boolean doThreadAction(TraceThread thread, ActionName name) {
        if (thread == null) {
            return false;
        }
        Target target = this.getTargetService().getTarget(thread.getTrace());
        try {
            this.doAction(target, name, this.createContext(thread));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean doTraceAction(Trace trace, ActionName name) {
        if (trace == null) {
            return false;
        }
        Target target = this.getTargetService().getTarget(trace);
        try {
            this.doAction(target, name, this.createContext(trace));
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean stepInto(TraceThread thread) {
        return this.doThreadAction(thread, ActionName.STEP_INTO);
    }

    default public boolean stepInto() {
        return this.stepInto(this.getCurrentThread());
    }

    default public boolean stepOver(TraceThread thread) {
        return this.doThreadAction(thread, ActionName.STEP_OVER);
    }

    default public boolean stepOver() {
        return this.stepOver(this.getCurrentThread());
    }

    default public boolean stepOut(TraceThread thread) {
        return this.doThreadAction(thread, ActionName.STEP_OUT);
    }

    default public boolean stepOut() {
        return this.stepOut(this.getCurrentThread());
    }

    default public boolean resume(TraceThread thread) {
        return this.doThreadAction(thread, ActionName.RESUME);
    }

    default public boolean resume(Trace trace) {
        return this.doTraceAction(trace, ActionName.RESUME);
    }

    default public boolean resume() {
        if (this.resume(this.getCurrentThread())) {
            return true;
        }
        return this.resume(this.getCurrentTrace());
    }

    default public boolean interrupt(TraceThread thread) {
        return this.doThreadAction(thread, ActionName.INTERRUPT);
    }

    default public boolean interrupt(Trace trace) {
        return this.doTraceAction(trace, ActionName.INTERRUPT);
    }

    default public boolean interrupt() {
        if (this.interrupt(this.getCurrentThread())) {
            return true;
        }
        return this.interrupt(this.getCurrentTrace());
    }

    default public boolean kill(TraceThread thread) {
        return this.doThreadAction(thread, ActionName.KILL);
    }

    default public boolean kill(Trace trace) {
        return this.doTraceAction(trace, ActionName.KILL);
    }

    default public boolean kill() {
        if (this.kill(this.getCurrentThread())) {
            return true;
        }
        return this.kill(this.getCurrentTrace());
    }

    default public TargetExecutionStateful.TargetExecutionState getExecutionState(Trace trace) {
        Target target = this.getTargetService().getTarget(trace);
        if (target == null) {
            return TargetExecutionStateful.TargetExecutionState.TERMINATED;
        }
        Target.ActionEntry action = this.findAction(target, ActionName.RESUME, this.createContext(trace));
        if (action == null) {
            return TargetExecutionStateful.TargetExecutionState.ALIVE;
        }
        return action.isEnabled() ? TargetExecutionStateful.TargetExecutionState.STOPPED : TargetExecutionStateful.TargetExecutionState.RUNNING;
    }

    default public TargetExecutionStateful.TargetExecutionState getExecutionState(TraceThread thread) {
        DebuggerCoordinates coords = this.getTraceManager().getCurrentFor(thread.getTrace());
        if (!coords.isAlive()) {
            return TargetExecutionStateful.TargetExecutionState.TERMINATED;
        }
        return coords.getTarget().getThreadExecutionState(thread);
    }

    default public boolean isTargetAlive(Trace trace) {
        return this.getExecutionState(trace).isAlive();
    }

    default public boolean isTargetAlive() {
        return this.isTargetAlive(this.requireCurrentTrace());
    }

    default public boolean isThreadAlive(TraceThread thread) {
        return this.getExecutionState(thread).isAlive();
    }

    default public boolean isThreadAlive() {
        return this.isThreadAlive(this.requireThread(this.getCurrentThread()));
    }

    default public void waitForBreak(final Trace trace, long timeout, TimeUnit unit) throws TimeoutException {
        if (!this.getExecutionState(trace).isRunning()) {
            return;
        }
        var listener = new DomainObjectListener(){
            CompletableFuture<Void> future = new CompletableFuture();

            public void domainObjectChanged(DomainObjectChangedEvent ev) {
                if (!FlatDebuggerAPI.this.getExecutionState(trace).isRunning()) {
                    this.future.complete(null);
                }
            }
        };
        trace.addListener(listener);
        try {
            if (!this.getExecutionState(trace).isRunning()) {
                return;
            }
            listener.future.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            trace.removeListener(listener);
        }
    }

    default public void waitForBreak(long timeout, TimeUnit unit) throws TimeoutException {
        this.waitForBreak(this.requireCurrentTrace(), timeout, unit);
    }

    default public String executeCapture(Trace trace, String command) {
        Target target = this.getTargetService().getTarget(trace);
        return target.execute(command, true);
    }

    default public String executeCapture(String command) {
        return this.executeCapture(this.requireCurrentTrace(), command);
    }

    default public boolean execute(Trace trace, String command) {
        Target target = this.getTargetService().getTarget(trace);
        try {
            target.execute(command, false);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    default public boolean execute(String command) {
        return this.execute(this.requireCurrentTrace(), command);
    }

    default public DebuggerLogicalBreakpointService getBreakpointService() {
        return this.requireService(DebuggerLogicalBreakpointService.class);
    }

    default public ProgramLocation staticLocation(Program program, Address address) {
        if (program instanceof TraceProgramView) {
            throw new IllegalArgumentException("The given program is dynamic, i.e., a trace view");
        }
        return new ProgramLocation(program, address);
    }

    default public ProgramLocation staticLocation(Program program, String addrString) {
        return this.staticLocation(program, program.getAddressFactory().getAddress(addrString));
    }

    default public ProgramLocation staticLocation(Address address) {
        return this.staticLocation(this.requireCurrentProgram(), address);
    }

    default public ProgramLocation staticLocation(String addrString) {
        return this.staticLocation(this.requireCurrentProgram(), addrString);
    }

    default public ProgramLocation dynamicLocation(TraceProgramView view, Address address) {
        return new ProgramLocation((Program)view, address);
    }

    default public ProgramLocation dynamicLocation(TraceProgramView view, String addrString) {
        return new ProgramLocation((Program)view, view.getAddressFactory().getAddress(addrString));
    }

    default public ProgramLocation dynamicLocation(Address address) {
        return this.dynamicLocation(this.requireCurrentView(), address);
    }

    default public ProgramLocation dynamicLocation(String addrString) {
        return this.dynamicLocation(this.requireCurrentView(), addrString);
    }

    default public ProgramLocation dynamicLocation(Trace trace, Address address) {
        return this.dynamicLocation((TraceProgramView)trace.getProgramView(), address);
    }

    default public ProgramLocation dynamicLocation(Trace trace, String addrString) {
        return this.dynamicLocation((TraceProgramView)trace.getProgramView(), addrString);
    }

    default public ProgramLocation dynamicLocation(Trace trace, long snap, Address address) {
        return this.dynamicLocation(trace.getFixedProgramView(snap), address);
    }

    default public ProgramLocation dynamicLocation(Trace trace, long snap, String addrString) {
        return this.dynamicLocation(trace.getFixedProgramView(snap), addrString);
    }

    default public Set<LogicalBreakpoint> getAllBreakpoints() {
        return this.getBreakpointService().getAllBreakpoints();
    }

    default public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Program program) {
        return this.getBreakpointService().getBreakpoints(program);
    }

    default public NavigableMap<Address, Set<LogicalBreakpoint>> getBreakpoints(Trace trace) {
        return this.getBreakpointService().getBreakpoints(trace);
    }

    default public Set<LogicalBreakpoint> getBreakpointsAt(ProgramLocation location) {
        return this.getBreakpointService().getBreakpointsAt(location);
    }

    default public Set<LogicalBreakpoint> getBreakpointsNamed(String name) {
        return this.getBreakpointService().getAllBreakpoints().stream().filter(bp -> name.equals(bp.getName())).collect(Collectors.toSet());
    }

    default public ExpectingBreakpointChanges expectBreakpointChanges() {
        return new ExpectingBreakpointChanges(this, this.getBreakpointService());
    }

    default public Set<LogicalBreakpoint> breakpointsToggle(ProgramLocation location) {
        Set<LogicalBreakpoint> set;
        block8: {
            DebuggerLogicalBreakpointService service = this.getBreakpointService();
            ExpectingBreakpointChanges exp = this.expectBreakpointChanges();
            try {
                set = this.waitOn(service.toggleBreakpointsAt(location, () -> CompletableFuture.completedFuture(Set.of())));
                if (exp == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (exp != null) {
                        try {
                            exp.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (InterruptedException | ExecutionException | TimeoutException e) {
                    return null;
                }
            }
            exp.close();
        }
        return set;
    }

    default public Set<LogicalBreakpoint> breakpointSet(ProgramLocation location, long length, TraceBreakpointKind.TraceBreakpointKindSet kinds, String name) {
        DebuggerLogicalBreakpointService service = this.getBreakpointService();
        try (ExpectingBreakpointChanges exp = this.expectBreakpointChanges();){
            this.waitOn(service.placeBreakpointAt(location, length, (Collection<TraceBreakpointKind>)kinds, name));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        return service.getBreakpointsAt(location).stream().filter(b -> Objects.equals(name, b.getName())).collect(Collectors.toSet());
    }

    default public Set<LogicalBreakpoint> breakpointSetSoftwareExecute(ProgramLocation location, String name) {
        return this.breakpointSet(location, 1L, TraceBreakpointKind.TraceBreakpointKindSet.SW_EXECUTE, name);
    }

    default public Set<LogicalBreakpoint> breakpointSetHardwareExecute(ProgramLocation location, String name) {
        return this.breakpointSet(location, 1L, TraceBreakpointKind.TraceBreakpointKindSet.HW_EXECUTE, name);
    }

    default public Set<LogicalBreakpoint> breakpointSetRead(ProgramLocation location, int length, String name) {
        return this.breakpointSet(location, length, TraceBreakpointKind.TraceBreakpointKindSet.READ, name);
    }

    default public Set<LogicalBreakpoint> breakpointSetWrite(ProgramLocation location, int length, String name) {
        return this.breakpointSet(location, length, TraceBreakpointKind.TraceBreakpointKindSet.WRITE, name);
    }

    default public Set<LogicalBreakpoint> breakpointSetAccess(ProgramLocation location, int length, String name) {
        return this.breakpointSet(location, length, TraceBreakpointKind.TraceBreakpointKindSet.ACCESS, name);
    }

    default public Trace getTrace(ProgramLocation location) {
        Program program = location.getProgram();
        if (program instanceof TraceProgramView) {
            TraceProgramView view = (TraceProgramView)program;
            return view.getTrace();
        }
        return null;
    }

    default public Set<LogicalBreakpoint> breakpointsEnable(ProgramLocation location) {
        DebuggerLogicalBreakpointService service = this.getBreakpointService();
        Set<LogicalBreakpoint> col = service.getBreakpointsAt(location);
        try (ExpectingBreakpointChanges exp = this.expectBreakpointChanges();){
            this.waitOn(service.enableAll(col, this.getTrace(location)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        return col;
    }

    default public Set<LogicalBreakpoint> breakpointsDisable(ProgramLocation location) {
        DebuggerLogicalBreakpointService service = this.getBreakpointService();
        Set<LogicalBreakpoint> col = service.getBreakpointsAt(location);
        try (ExpectingBreakpointChanges exp = this.expectBreakpointChanges();){
            this.waitOn(service.disableAll(col, this.getTrace(location)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        return col;
    }

    default public boolean breakpointsClear(ProgramLocation location) {
        DebuggerLogicalBreakpointService service = this.getBreakpointService();
        Set<LogicalBreakpoint> col = service.getBreakpointsAt(location);
        try (ExpectingBreakpointChanges exp = this.expectBreakpointChanges();){
            this.waitOn(service.deleteAll(col, this.getTrace(location)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean flushAsyncPipelines(Trace trace) {
        try {
            trace.flushEvents();
            this.waitOn(this.getMappingService().changesSettled());
            this.waitOn(this.getBreakpointService().changesSettled());
            Swing.allowSwingToProcessEvents();
            return true;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
    }

    public static class ExpectingBreakpointChanges
    implements AutoCloseable {
        private final FlatDebuggerAPI flat;
        private final CompletableFuture<Void> changesSettled;

        public ExpectingBreakpointChanges(FlatDebuggerAPI flat, DebuggerLogicalBreakpointService service) {
            this.flat = flat;
            this.changesSettled = service.changesSettled();
        }

        @Override
        public void close() throws InterruptedException, ExecutionException, TimeoutException {
            Swing.allowSwingToProcessEvents();
            this.flat.waitOn(this.changesSettled);
        }
    }
}

