/*
 * Decompiled with CFR 0.152.
 */
package ghidra.debug.flatapi;

import ghidra.app.services.DebuggerModelService;
import ghidra.dbg.AnnotatedDebuggerAttributeListener;
import ghidra.dbg.DebuggerModelListener;
import ghidra.dbg.DebuggerObjectModel;
import ghidra.dbg.target.TargetExecutionStateful;
import ghidra.dbg.target.TargetInterpreter;
import ghidra.dbg.target.TargetInterruptible;
import ghidra.dbg.target.TargetKillable;
import ghidra.dbg.target.TargetLauncher;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.TargetResumable;
import ghidra.dbg.target.TargetSteppable;
import ghidra.dbg.target.TargetThread;
import ghidra.dbg.util.PathUtils;
import ghidra.debug.api.ValStr;
import ghidra.debug.api.model.DebuggerProgramLaunchOffer;
import ghidra.debug.api.model.TraceRecorder;
import ghidra.debug.flatapi.FlatDebuggerAPI;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.Swing;
import ghidra.util.task.TaskMonitor;
import java.lang.invoke.MethodHandles;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Collectors;

@Deprecated
public interface FlatDebuggerRecorderAPI
extends FlatDebuggerAPI {
    default public DebuggerModelService getModelService() {
        return this.requireService(DebuggerModelService.class);
    }

    default public TargetObject getTarget(Trace trace) {
        TraceRecorder recorder = this.getModelService().getRecorder(trace);
        if (recorder == null) {
            return null;
        }
        return recorder.getTarget();
    }

    default public TargetThread getTargetThread(TraceThread thread) {
        TraceRecorder recorder = this.getModelService().getRecorder(thread.getTrace());
        if (recorder == null) {
            return null;
        }
        return recorder.getTargetThread(thread);
    }

    default public TargetObject getTargetFocus(Trace trace) {
        TraceRecorder recorder = this.getModelService().getRecorder(trace);
        if (recorder == null) {
            return null;
        }
        TargetObject focus = recorder.getFocus();
        return focus != null ? focus : recorder.getTarget();
    }

    default public <T extends TargetObject> T findInterface(TargetObject seed, Class<T> iface) {
        DebuggerObjectModel model = seed.getModel();
        List found = model.getRootSchema().searchForSuitable(iface, seed.getPath());
        if (found == null) {
            return null;
        }
        try {
            Object value = this.waitOn(model.fetchModelValue(found));
            return (T)((TargetObject)value);
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
    }

    default public <T extends TargetObject> T findInterface(TraceThread thread, Class<T> iface) {
        TargetThread targetThread = this.getTargetThread(thread);
        if (targetThread == null) {
            return null;
        }
        return this.findInterface((TargetObject)targetThread, iface);
    }

    default public <T extends TargetObject> T findInterface(Trace trace, Class<T> iface) {
        TargetObject focus = this.getTargetFocus(trace);
        if (focus == null) {
            return null;
        }
        return this.findInterface(focus, iface);
    }

    default public <T extends TargetObject> T findInterface(Class<T> iface) {
        T t;
        TraceThread thread = this.getCurrentThread();
        T t2 = t = thread == null ? null : (T)this.findInterface(thread, iface);
        if (t != null) {
            return t;
        }
        return this.findInterface(this.requireCurrentTrace(), iface);
    }

    default public boolean step(TargetSteppable steppable, TargetSteppable.TargetStepKind kind) {
        if (steppable == null) {
            return false;
        }
        try {
            this.waitOn(steppable.step(kind));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean step(TraceThread thread, TargetSteppable.TargetStepKind kind) {
        if (thread == null) {
            return false;
        }
        return this.step(this.findInterface(thread, TargetSteppable.class), kind);
    }

    default public boolean resume(TargetResumable resumable) {
        if (resumable == null) {
            return false;
        }
        try {
            this.waitOn(resumable.resume());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean interrupt(TargetInterruptible interruptible) {
        if (interruptible == null) {
            return false;
        }
        try {
            this.waitOn(interruptible.interrupt());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public boolean kill(TargetKillable killable) {
        if (killable == null) {
            return false;
        }
        try {
            this.waitOn(killable.kill());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public TargetExecutionStateful.TargetExecutionState getExecutionState(TargetObject target) {
        if (!target.isValid()) {
            return TargetExecutionStateful.TargetExecutionState.TERMINATED;
        }
        TargetExecutionStateful stateful = this.findInterface(target, TargetExecutionStateful.class);
        return stateful == null ? TargetExecutionStateful.TargetExecutionState.ALIVE : stateful.getExecutionState();
    }

    default public void waitForBreak(TargetObject target, long timeout, TimeUnit unit) throws TimeoutException {
        final TargetExecutionStateful stateful = this.findInterface(target, TargetExecutionStateful.class);
        if (stateful == null) {
            throw new IllegalArgumentException("Given target is not stateful");
        }
        var listener = new AnnotatedDebuggerAttributeListener(this, MethodHandles.lookup()){
            CompletableFuture<Void> future;
            {
                super(arg0);
                this.future = new CompletableFuture();
            }

            @AnnotatedDebuggerAttributeListener.AttributeCallback(value="_state")
            private void stateChanged(TargetObject parent, TargetExecutionStateful.TargetExecutionState state) {
                if (parent == stateful && !state.isRunning()) {
                    this.future.complete(null);
                }
            }
        };
        target.getModel().addModelListener((DebuggerModelListener)listener);
        try {
            if (!stateful.getExecutionState().isRunning()) {
                return;
            }
            listener.future.get(timeout, unit);
        }
        catch (InterruptedException | ExecutionException e) {
            throw new RuntimeException(e);
        }
        finally {
            target.getModel().removeModelListener((DebuggerModelListener)listener);
        }
    }

    @Override
    default public void waitForBreak(Trace trace, long timeout, TimeUnit unit) throws TimeoutException {
        TargetObject target = this.getTarget(trace);
        if (target == null || !target.isValid()) {
            return;
        }
        this.waitForBreak(target, timeout, unit);
    }

    default public String executeCapture(TargetInterpreter interpreter, String command) {
        if (interpreter == null) {
            return null;
        }
        try {
            return (String)this.waitOn(interpreter.executeCapture(command));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
    }

    default public boolean execute(TargetInterpreter interpreter, String command) {
        if (interpreter == null) {
            return false;
        }
        try {
            this.waitOn(interpreter.executeCapture(command));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
        return true;
    }

    default public Object getModelValue(DebuggerObjectModel model, String path) {
        try {
            return this.waitOn(model.fetchModelValue(PathUtils.parse((String)path)));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
    }

    default public Object getModelValue(String path) {
        TraceRecorder recorder = this.getModelService().getRecorder(this.getCurrentTrace());
        if (recorder == null) {
            return null;
        }
        return this.getModelValue(recorder.getTarget().getModel(), path);
    }

    default public Set<TargetObject> refreshObjectChildren(TargetObject object) {
        try {
            this.waitOn(object.invalidateCaches());
            this.waitOn(object.resync());
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return null;
        }
        LinkedHashSet<TargetObject> result = new LinkedHashSet<TargetObject>();
        result.addAll(object.getCachedElements().values());
        for (Object v : object.getCachedAttributes().values()) {
            if (!(v instanceof TargetObject)) continue;
            result.add((TargetObject)v);
        }
        return result;
    }

    default public boolean refreshSubtree(TargetObject object) {
        var util = new Object(){
            Set<TargetObject> visited = new HashSet<TargetObject>();

            boolean visit(TargetObject object) {
                if (!this.visited.add(object)) {
                    return true;
                }
                for (TargetObject child : FlatDebuggerRecorderAPI.this.refreshObjectChildren(object)) {
                    if (this.visit(child)) continue;
                    return false;
                }
                return true;
            }
        };
        return util.visit(object);
    }

    @Override
    default public boolean flushAsyncPipelines(Trace trace) {
        try {
            TraceRecorder recorder = this.getModelService().getRecorder(trace);
            if (recorder != null) {
                this.waitOn(recorder.getTarget().getModel().flushEvents());
                this.waitOn(recorder.flushTransactions());
            }
            trace.flushEvents();
            this.waitOn(this.getMappingService().changesSettled());
            this.waitOn(this.getBreakpointService().changesSettled());
            Swing.allowSwingToProcessEvents();
            return true;
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return false;
        }
    }

    default public List<DebuggerProgramLaunchOffer> getLaunchOffers(Program program) {
        return this.getModelService().getProgramLaunchOffers(program).collect(Collectors.toList());
    }

    default public List<DebuggerProgramLaunchOffer> getLaunchOffers() {
        return this.getLaunchOffers(this.requireCurrentProgram());
    }

    default public DebuggerProgramLaunchOffer requireLaunchOffer(Program program) {
        Optional<DebuggerProgramLaunchOffer> offer = this.getModelService().getProgramLaunchOffers(program).findFirst();
        if (offer.isEmpty()) {
            throw new NoSuchElementException("No offers to launch " + String.valueOf(program));
        }
        return offer.get();
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(DebuggerProgramLaunchOffer offer, final String commandLine, TaskMonitor monitor) {
        try {
            return this.waitOn(offer.launchProgram(monitor, DebuggerProgramLaunchOffer.PromptMode.NEVER, new DebuggerProgramLaunchOffer.LaunchConfigurator(){

                @Override
                public Map<String, ValStr<?>> configureLauncher(TargetLauncher launcher, Map<String, ValStr<?>> arguments, DebuggerProgramLaunchOffer.RelPrompt relPrompt) {
                    HashMap adjusted = new HashMap(arguments);
                    adjusted.put("args", ValStr.str(commandLine));
                    return adjusted;
                }
            }));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return DebuggerProgramLaunchOffer.LaunchResult.totalFailure(e);
        }
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(DebuggerProgramLaunchOffer offer, TaskMonitor monitor) {
        try {
            return this.waitOn(offer.launchProgram(monitor, DebuggerProgramLaunchOffer.PromptMode.NEVER));
        }
        catch (InterruptedException | ExecutionException | TimeoutException e) {
            return DebuggerProgramLaunchOffer.LaunchResult.totalFailure(e);
        }
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(Program program, String commandLine, TaskMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        return this.launch(this.requireLaunchOffer(program), commandLine, monitor);
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(Program program, TaskMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        return this.launch(this.requireLaunchOffer(program), monitor);
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(String commandLine, TaskMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        return this.launch(this.requireCurrentProgram(), commandLine, monitor);
    }

    default public DebuggerProgramLaunchOffer.LaunchResult launch(TaskMonitor monitor) throws InterruptedException, ExecutionException, TimeoutException {
        return this.launch(this.requireCurrentProgram(), monitor);
    }
}

