/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.breakpoint.DBTraceObjectBreakpointLocation;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointSpec;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceAddressSpace;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.stream.Collectors;

public class DBTraceObjectBreakpointSpec
implements TraceObjectBreakpointSpec,
DBTraceObjectInterface {
    private static final Map<TargetObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TargetObjectSchema, Set<String>>();
    private final DBTraceObject object;
    private final Set<String> keys;
    private TraceBreakpointKind.TraceBreakpointKindSet kinds = TraceBreakpointKind.TraceBreakpointKindSet.of(new TraceBreakpointKind[0]);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTraceObjectBreakpointSpec(DBTraceObject object) {
        this.object = object;
        TargetObjectSchema schema = object.getTargetSchema();
        Map<TargetObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
        synchronized (map) {
            this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(schema.checkAliasedAttribute("_kinds"), schema.checkAliasedAttribute("_enabled")));
        }
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(this.getLifespan(), "_display", name);
        }
    }

    @Override
    public String getName() {
        return TraceObjectInterfaceUtils.getValue(this.object, this.getPlacedSnap(), "_display", String.class, "");
    }

    @Override
    public AddressRange getRange() {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public Address getMinAddress() {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public Address getMaxAddress() {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public long getLength() {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public Lifespan getLifespan() {
        return this.computeSpan();
    }

    @Override
    public long getPlacedSnap() {
        return this.computeMinSnap();
    }

    @Override
    public void setClearedSnap(long clearedSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(this.getPlacedSnap(), clearedSnap));
        }
    }

    @Override
    public long getClearedSnap() {
        return this.computeMaxSnap();
    }

    @Override
    public void setLifespan(Lifespan lifespan) throws DuplicateNameException {
        TraceObjectInterfaceUtils.setLifespan(TraceObjectThread.class, this.object, lifespan);
    }

    @Override
    public TraceBreakpoint splitAndSet(long snap, boolean enabled, Collection<TraceBreakpointKind> kinds) {
        throw new UnsupportedOperationException("Only used by default trace recorder");
    }

    @Override
    public void setEnabled(boolean enabled) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(this.getLifespan(), "_enabled", enabled ? Boolean.valueOf(true) : null);
        }
    }

    @Override
    public boolean isEnabled(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_enabled", Boolean.class, false);
    }

    @Override
    public void setKinds(Lifespan lifespan, Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_kinds", TraceBreakpointKind.TraceBreakpointKindSet.encode(kinds));
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.copyOf(kinds);
        }
    }

    @Override
    public void setKinds(Collection<TraceBreakpointKind> kinds) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setKinds(this.getLifespan(), kinds);
        }
    }

    @Override
    public Set<TraceBreakpointKind> getKinds() {
        String kindsStr = TraceObjectInterfaceUtils.getValue(this.object, this.getPlacedSnap(), "_kinds", String.class, null);
        if (kindsStr == null) {
            return this.kinds;
        }
        try {
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.decode(kindsStr, true);
            return this.kinds;
        }
        catch (IllegalArgumentException e) {
            Msg.warn((Object)this, (Object)("Unrecognized breakpoint kind(s) in trace database: " + String.valueOf(e)));
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.decode(kindsStr, false);
            return this.kinds;
        }
    }

    @Override
    public String getExpression() {
        return TraceObjectInterfaceUtils.getValue(this.object, this.getPlacedSnap(), "_expression", String.class, null);
    }

    @Override
    public Set<TraceThread> getThreads() {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public void setComment(String comment) {
        throw new UnsupportedOperationException("Set on a location instead");
    }

    @Override
    public String getComment() {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public void setEmuEnabled(boolean enabled) {
        throw new UnsupportedOperationException("Set on a location instead");
    }

    @Override
    public boolean isEmuEnabled(long snap) {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public void setEmuSleigh(String sleigh) {
        throw new UnsupportedOperationException("Set on a location instead");
    }

    @Override
    public String getEmuSleigh() {
        throw new UnsupportedOperationException("Ask a location instead");
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.getCanonicalParent(snap) != null;
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public Collection<? extends TraceObjectBreakpointLocation> getLocations() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Collection collection = this.object.querySuccessorsInterface(this.getLifespan(), TraceObjectBreakpointLocation.class, true).collect(Collectors.toSet());
            return collection;
        }
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        if (rec.getEventType() == TraceEvents.VALUE_CREATED) {
            TraceChangeRecord cast = TraceEvents.VALUE_CREATED.cast(rec);
            TraceObjectValue affected = (TraceObjectValue)cast.getAffectedObject();
            String key = affected.getEntryKey();
            boolean applies = this.keys.contains(key);
            if (!applies) {
                return null;
            }
            assert (affected.getParent() == this.object);
            if (this.object.getCanonicalParent(affected.getMaxSnap()) == null) {
                return null;
            }
            for (TraceObjectBreakpointLocation traceObjectBreakpointLocation : this.getLocations()) {
                DBTraceObjectBreakpointLocation dbLoc = (DBTraceObjectBreakpointLocation)traceObjectBreakpointLocation;
                TraceAddressSpace space = dbLoc.getTraceAddressSpace();
                TraceChangeRecord<TraceObjectBreakpointLocation, Object> evt = new TraceChangeRecord<TraceObjectBreakpointLocation, Object>(TraceEvents.BREAKPOINT_CHANGED, space, traceObjectBreakpointLocation, null, null);
                this.object.getTrace().setChanged(evt);
            }
            return null;
        }
        return null;
    }
}

