/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import generic.NestedIterator;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFactory;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.address.AddressSpace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.listing.AbstractBaseDBTraceCodeUnitsView;
import ghidra.trace.database.listing.DBTraceCodeManager;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceCodeUnitAdapter;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.locks.Lock;

public abstract class AbstractBaseDBTraceCodeUnitsMemoryView<T extends DBTraceCodeUnitAdapter, M extends AbstractBaseDBTraceCodeUnitsView<T>>
implements DBTraceDelegatingManager<M> {
    protected final DBTraceCodeManager manager;

    public AbstractBaseDBTraceCodeUnitsMemoryView(DBTraceCodeManager manager) {
        this.manager = manager;
    }

    public AddressSpace getSpace() {
        return null;
    }

    public Trace getTrace() {
        return this.manager.getTrace();
    }

    public TraceThread getThread() {
        return null;
    }

    public int getFrameLevel() {
        return 0;
    }

    protected abstract M getView(DBTraceCodeSpace var1);

    protected T nullOrUndefined(long snap, Address address) {
        return null;
    }

    protected AddressSetView emptyOrFullAddressSetUndefined(AddressRange within) {
        return new AddressSet();
    }

    protected boolean falseOrTrueUndefined() {
        return false;
    }

    public Iterable<? extends T> emptyOrFullIterableUndefined(long snap, AddressRange range, boolean forward) {
        return Collections.emptyList();
    }

    public Iterable<? extends T> emptyOrFullIterableUndefined(TraceAddressSnapRange tasr) {
        return Collections.emptyList();
    }

    @Override
    public Lock readLock() {
        return this.manager.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.manager.writeLock();
    }

    @Override
    public M getForSpace(AddressSpace space, boolean createIfAbsent) {
        DBTraceCodeSpace codeSpace = this.manager.getForSpace(space, createIfAbsent);
        return codeSpace == null ? null : (M)this.getView(codeSpace);
    }

    protected Address prevAddress(Address address) {
        Address prev = address.previous();
        if (prev != null) {
            return prev;
        }
        AddressRangeIterator ranges = this.manager.getBaseLanguage().getAddressFactory().getAddressSet().getAddressRanges(address, false);
        if (!ranges.hasNext()) {
            return null;
        }
        AddressRange prevRange = (AddressRange)ranges.next();
        if (prevRange.contains(address)) {
            if (!ranges.hasNext()) {
                return null;
            }
            prevRange = (AddressRange)ranges.next();
        }
        return prevRange.getMaxAddress();
    }

    protected Address nextAddress(Address address) {
        Address next = address.next();
        if (next != null) {
            return next;
        }
        AddressRangeIterator ranges = this.manager.getBaseLanguage().getAddressFactory().getAddressSet().getAddressRanges(address, true);
        if (!ranges.hasNext()) {
            return null;
        }
        AddressRange nextRange = (AddressRange)ranges.next();
        if (nextRange.contains(address)) {
            if (!ranges.hasNext()) {
                return null;
            }
            nextRange = (AddressRange)ranges.next();
        }
        return nextRange.getMinAddress();
    }

    public int size() {
        int sum = 0;
        for (DBTraceCodeSpace space : this.manager.getActiveMemorySpaces()) {
            sum += ((AbstractBaseDBTraceCodeUnitsView)this.getView(space)).size();
        }
        return sum;
    }

    public T getBefore(long snap, Address address) {
        Address prev = this.prevAddress(address);
        if (prev == null) {
            return null;
        }
        return this.getFloor(snap, prev);
    }

    public T getFloor(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            Iterator it = DBTraceUtils.getAddressSet(this.manager.getTrace().getBaseAddressFactory(), address, false).iterator(false);
            while (it.hasNext()) {
                T candidate;
                AddressRange range = (AddressRange)it.next();
                Object m = this.getForSpace(range.getAddressSpace(), false);
                T t = candidate = m == null ? this.nullOrUndefined(snap, range.getMaxAddress()) : ((AbstractBaseDBTraceCodeUnitsView)m).getFloor(snap, range.getMaxAddress());
                if (candidate == null) continue;
                T t2 = candidate;
                return t2;
            }
            T t = null;
            return t;
        }
    }

    public T getContaining(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            Object m = this.getForSpace(address.getAddressSpace(), false);
            if (m == null) {
                T t = this.nullOrUndefined(snap, address);
                return t;
            }
            Object t = ((AbstractBaseDBTraceCodeUnitsView)m).getContaining(snap, address);
            return t;
        }
    }

    public T getAt(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            Object m = this.getForSpace(address.getAddressSpace(), false);
            if (m == null) {
                T t = this.nullOrUndefined(snap, address);
                return t;
            }
            Object t = ((AbstractBaseDBTraceCodeUnitsView)m).getAt(snap, address);
            return t;
        }
    }

    public T getCeiling(long snap, Address address) {
        try (LockHold hold = LockHold.lock((Lock)this.readLock());){
            for (AddressRange range : DBTraceUtils.getAddressSet(this.manager.getTrace().getBaseAddressFactory(), address, true)) {
                T candidate;
                Object m = this.getForSpace(range.getAddressSpace(), false);
                T t = candidate = m == null ? this.nullOrUndefined(snap, range.getMinAddress()) : ((AbstractBaseDBTraceCodeUnitsView)m).getCeiling(snap, range.getMinAddress());
                if (candidate == null) continue;
                T t2 = candidate;
                return t2;
            }
            Iterator iterator = null;
            return (T)iterator;
        }
    }

    public T getAfter(long snap, Address address) {
        Address next = this.nextAddress(address);
        if (next == null) {
            return null;
        }
        return this.getCeiling(snap, next);
    }

    public Iterable<? extends T> get(long snap, Address min, Address max, boolean forward) {
        if (min.hasSameAddressSpace(max)) {
            return this.get(snap, (AddressRange)new AddressRangeImpl(min, max), forward);
        }
        return this.get(snap, (AddressSetView)this.manager.getTrace().getBaseAddressFactory().getAddressSet(min, max), forward);
    }

    public Iterable<? extends T> get(long snap, AddressSetView set, boolean forward) {
        return () -> NestedIterator.start((Iterator)set.iterator(forward), r -> this.get(snap, (AddressRange)r, forward).iterator());
    }

    public Iterable<? extends T> get(long snap, AddressRange range, boolean forward) {
        Object m = this.getForSpace(range.getAddressSpace(), false);
        if (m == null) {
            return this.emptyOrFullIterableUndefined(snap, range, forward);
        }
        return ((AbstractBaseDBTraceCodeUnitsView)m).get(snap, range, forward);
    }

    public Iterable<? extends T> get(long snap, Address start, boolean forward) {
        AddressFactory factory = this.manager.getTrace().getBaseAddressFactory();
        return this.get(snap, DBTraceUtils.getAddressSet(factory, start, forward), forward);
    }

    public Iterable<? extends T> get(long snap, boolean forward) {
        return this.get(snap, (AddressSetView)this.manager.getTrace().getBaseAddressFactory().getAddressSet(), forward);
    }

    public Iterable<? extends T> getIntersecting(TraceAddressSnapRange tasr) {
        Object m = this.getForSpace(tasr.getX1().getAddressSpace(), false);
        if (m == null) {
            return this.emptyOrFullIterableUndefined(tasr);
        }
        return ((AbstractBaseDBTraceCodeUnitsView)m).getIntersecting(tasr);
    }

    public AddressSetView getAddressSetView(long snap, AddressRange within) {
        Object m = this.getForSpace(within.getAddressSpace(), false);
        if (m == null) {
            return this.emptyOrFullAddressSetUndefined(within);
        }
        return ((AbstractBaseDBTraceCodeUnitsView)m).getAddressSetView(snap, within);
    }

    public AddressSetView getAddressSetView(long snap) {
        AddressSet result = new AddressSet();
        for (AddressRange range : this.manager.getTrace().getBaseAddressFactory().getAddressSet()) {
            Object m = this.getForSpace(range.getAddressSpace(), false);
            if (m == null) {
                result.add(this.emptyOrFullAddressSetUndefined(range));
                continue;
            }
            result.add(((AbstractBaseDBTraceCodeUnitsView)m).getAddressSetView(snap));
        }
        return result;
    }

    public boolean containsAddress(long snap, Address address) {
        return this.delegateRead(address.getAddressSpace(), m -> m.containsAddress(snap, address), this.falseOrTrueUndefined());
    }

    public boolean coversRange(Lifespan span, AddressRange range) {
        return this.delegateRead(range.getAddressSpace(), m -> m.coversRange(span, range), this.falseOrTrueUndefined());
    }

    public boolean coversRange(TraceAddressSnapRange range) {
        return this.delegateRead(range.getRange().getAddressSpace(), m -> m.coversRange(range), this.falseOrTrueUndefined());
    }

    public boolean intersectsRange(Lifespan span, AddressRange range) {
        return this.delegateRead(range.getAddressSpace(), m -> m.intersectsRange(span, range), this.falseOrTrueUndefined());
    }

    public boolean intersectsRange(TraceAddressSnapRange range) {
        return this.delegateRead(range.getRange().getAddressSpace(), m -> m.intersectsRange(range), this.falseOrTrueUndefined());
    }
}

