/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.listing;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.Composite;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.Dynamic;
import ghidra.program.model.data.FactoryDataType;
import ghidra.program.model.data.FunctionDefinition;
import ghidra.program.model.data.PointerDataType;
import ghidra.program.model.data.TypeDef;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.util.CodeUnitInsertionException;
import ghidra.trace.database.listing.AbstractBaseDBTraceDefinedUnitsView;
import ghidra.trace.database.listing.DBTraceCodeSpace;
import ghidra.trace.database.listing.DBTraceData;
import ghidra.trace.database.listing.DBTraceDataAdapter;
import ghidra.trace.database.listing.InternalTraceDefinedDataView;
import ghidra.trace.database.listing.UndefinedDBTraceData;
import ghidra.trace.database.memory.DBTraceMemorySpace;
import ghidra.trace.model.ImmutableTraceAddressSnapRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.concurrent.locks.Lock;

public class DBTraceDefinedDataView
extends AbstractBaseDBTraceDefinedUnitsView<DBTraceData>
implements InternalTraceDefinedDataView {
    public DBTraceDefinedDataView(DBTraceCodeSpace space) {
        super(space, space.dataMapSpace);
    }

    @Override
    public DBTraceDataAdapter create(Lifespan lifespan, Address address, DataType dataType) throws CodeUnitInsertionException {
        return this.create(lifespan, address, dataType, dataType.getLength());
    }

    protected boolean isFunctionDefinition(DataType dt) {
        if (dt instanceof FunctionDefinition) {
            return true;
        }
        if (dt instanceof TypeDef) {
            TypeDef typeDef = (TypeDef)dt;
            return this.isFunctionDefinition(typeDef.getBaseDataType());
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public DBTraceDataAdapter create(Lifespan lifespan, Address address, DataType origType, int origLength) throws CodeUnitInsertionException {
        try (LockHold hold = LockHold.lock((Lock)this.space.lock.writeLock());){
            long endSnap;
            int length;
            DataType dataType;
            DBTraceMemorySpace memSpace = (DBTraceMemorySpace)this.space.trace.getMemoryManager().get(this.space, true);
            long startSnap = lifespan.lmin();
            if (!this.space.undefinedData.coversRange(Lifespan.at(startSnap), (AddressRange)new AddressRangeImpl(address, address))) {
                throw new CodeUnitInsertionException("Code units cannot overlap");
            }
            if (origType instanceof FactoryDataType) {
                MemBuffer buffer = memSpace.getBufferAt(startSnap, address);
                FactoryDataType fdt = (FactoryDataType)origType;
                dataType = fdt.getDataType(buffer);
                length = -1;
            } else {
                dataType = origType;
                length = origLength;
            }
            if (dataType == null) {
                throw new CodeUnitInsertionException("Failed to resolve data type");
            }
            if (this.isFunctionDefinition(dataType = dataType.clone((DataTypeManager)this.space.dataTypeManager))) {
                dataType = new PointerDataType(dataType, dataType.getDataTypeManager());
                length = dataType.getLength();
            } else if (dataType instanceof Dynamic) {
                Dynamic dyn = (Dynamic)dataType;
                MemBuffer buffer = memSpace.getBufferAt(startSnap, address);
                length = dyn.getLength(buffer, length);
            } else {
                length = dataType.getLength();
            }
            if (length < 0) {
                throw new CodeUnitInsertionException("Failed to resolve data length for " + origType.getName());
            }
            if (length == 0) {
                throw new CodeUnitInsertionException("Zero-length data not allowed " + origType.getName());
            }
            Address endAddress = address.addNoWrap((long)(length - 1));
            AddressRangeImpl createdRange = new AddressRangeImpl(address, endAddress);
            ImmutableTraceAddressSnapRange tasr = new ImmutableTraceAddressSnapRange((AddressRange)createdRange, Lifespan.span(startSnap, endSnap = this.computeTruncatedMax(lifespan, null, (AddressRange)createdRange)));
            if (!this.space.undefinedData.coversRange(tasr)) {
                throw new CodeUnitInsertionException("Code units cannot overlap");
            }
            if (dataType == DataType.DEFAULT) {
                UndefinedDBTraceData undefinedDBTraceData = this.space.undefinedData.getAt(startSnap, address);
                return undefinedDBTraceData;
            }
            long dataTypeID = this.space.dataTypeManager.getResolvedID(dataType);
            DBTraceData created = this.mapSpace.put(tasr, null);
            created.set(this.space.trace.getPlatformManager().getHostPlatform(), dataTypeID);
            this.cacheForContaining.notifyNewEntry(tasr.getLifespan(), (AddressRange)createdRange, created);
            this.cacheForSequence.notifyNewEntry(tasr.getLifespan(), createdRange, created);
            this.space.undefinedData.invalidateCache();
            if (dataType instanceof Composite || dataType instanceof Array || dataType instanceof Dynamic) {
                this.space.trace.setChanged(new TraceChangeRecord<ImmutableTraceAddressSnapRange, DBTraceData>(TraceEvents.COMPOSITE_DATA_ADDED, this.space, tasr, created));
            }
            this.space.trace.setChanged(new TraceChangeRecord<ImmutableTraceAddressSnapRange, DBTraceData>(TraceEvents.CODE_ADDED, this.space, tasr, created));
            DBTraceData dBTraceData = created;
            return dBTraceData;
        }
        catch (AddressOverflowException e) {
            throw new CodeUnitInsertionException("Could unit would extend beyond address space");
        }
    }

    @Override
    protected void unitRemoved(DBTraceData unit) {
        super.unitRemoved(unit);
        DataType dataType = unit.getBaseDataType();
        if (dataType instanceof Composite || dataType instanceof Array || dataType instanceof Dynamic) {
            this.space.trace.setChanged(new TraceChangeRecord<TraceAddressSnapRange, Object>(TraceEvents.COMPOSITE_DATA_REMOVED, this.space, unit.getBounds(), unit, null));
        }
    }

    @Override
    protected void unitSpanChanged(Lifespan oldSpan, DBTraceData unit) {
        super.unitSpanChanged(oldSpan, unit);
        DataType dataType = unit.getBaseDataType();
        if (dataType instanceof Composite || dataType instanceof Array || dataType instanceof Dynamic) {
            this.space.trace.setChanged(new TraceChangeRecord<DBTraceData, Lifespan>(TraceEvents.COMPOSITE_DATA_LIFESPAN_CHANGED, this.space, unit, oldSpan, unit.getLifespan()));
        }
    }
}

