/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.memory;

import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DBTraceObjectMemoryRegion
implements TraceObjectMemoryRegion,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final RegionChangeTranslator translator;
    private AddressRange range;
    private Lifespan lifespan;

    public DBTraceObjectMemoryRegion(DBTraceObject object) {
        this.object = object;
        this.translator = new RegionChangeTranslator(object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(this.computeSpan(), name);
        }
    }

    @Override
    public String getName() {
        DBTraceObjectValue value = this.object.getValue(this.getCreationSnap(), "_display");
        return value == null ? "" : (String)value.getValue();
    }

    @Override
    public void setLifespan(Lifespan newLifespan) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            TraceObjectInterfaceUtils.setLifespan(TraceObjectMemoryRegion.class, this.object, newLifespan);
            this.lifespan = newLifespan;
        }
    }

    @Override
    public Lifespan getLifespan() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Lifespan computed = this.computeSpan();
            if (computed != null) {
                this.lifespan = computed;
            }
            Lifespan lifespan = this.lifespan;
            return lifespan;
        }
    }

    @Override
    public void setCreationSnap(long creationSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(creationSnap, this.getDestructionSnap()));
        }
    }

    @Override
    public long getCreationSnap() {
        return this.computeMinSnap();
    }

    @Override
    public void setDestructionSnap(long destructionSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(this.getCreationSnap(), destructionSnap));
        }
    }

    @Override
    public long getDestructionSnap() {
        return this.computeMaxSnap();
    }

    @Override
    public void setRange(Lifespan lifespan, AddressRange newRange) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", newRange);
            this.range = newRange;
        }
    }

    @Override
    public void setRange(AddressRange newRange) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(this.computeSpan(), newRange);
        }
    }

    @Override
    public AddressRange getRange(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            AddressRange addressRange = this.range = TraceObjectInterfaceUtils.getValue(this.object, snap, "_range", AddressRange.class, this.range);
            return addressRange;
        }
    }

    @Override
    public AddressRange getRange() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            if (this.object.getLife().isEmpty()) {
                AddressRange addressRange = this.range;
                return addressRange;
            }
            AddressRange addressRange = this.getRange(this.getCreationSnap());
            return addressRange;
        }
    }

    @Override
    public void setMinAddress(Address min) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(DBTraceUtils.toRange(min, this.getMaxAddress()));
        }
    }

    @Override
    public Address getMinAddress(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMinAddress();
    }

    @Override
    public Address getMinAddress() {
        AddressRange range = this.getRange();
        return range == null ? null : range.getMinAddress();
    }

    @Override
    public void setMaxAddress(Address max) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange(DBTraceUtils.toRange(this.getMinAddress(), max));
        }
    }

    @Override
    public Address getMaxAddress(long snap) {
        AddressRange range = this.getRange(snap);
        return range == null ? null : range.getMaxAddress();
    }

    @Override
    public Address getMaxAddress() {
        AddressRange range = this.getRange();
        return range == null ? null : range.getMaxAddress();
    }

    @Override
    public void setLength(long length) throws AddressOverflowException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setRange((AddressRange)new AddressRangeImpl(this.getMinAddress(), length));
        }
    }

    @Override
    public long getLength() {
        return this.getRange().getLength();
    }

    protected static String keyForFlag(TraceMemoryFlag flag) {
        return switch (flag) {
            case TraceMemoryFlag.READ -> "_readable";
            case TraceMemoryFlag.WRITE -> "_writable";
            case TraceMemoryFlag.EXECUTE -> "_executable";
            case TraceMemoryFlag.VOLATILE -> "_volatile";
            default -> throw new AssertionError();
        };
    }

    @Override
    public void setFlags(Lifespan lifespan, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            for (TraceMemoryFlag flag : TraceMemoryFlag.values()) {
                Boolean val = flags.contains((Object)flag) ? Boolean.valueOf(true) : null;
                this.object.setValue(lifespan, DBTraceObjectMemoryRegion.keyForFlag(flag), val);
            }
        }
    }

    @Override
    public void addFlags(Lifespan lifespan, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            for (TraceMemoryFlag flag : flags) {
                this.object.setValue(lifespan, DBTraceObjectMemoryRegion.keyForFlag(flag), true);
            }
        }
    }

    @Override
    public void clearFlags(Lifespan lifespan, Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            for (TraceMemoryFlag flag : flags) {
                this.object.setValue(lifespan, DBTraceObjectMemoryRegion.keyForFlag(flag), null);
            }
        }
    }

    @Override
    public void setFlags(Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setFlags(this.getLifespan(), flags);
        }
    }

    @Override
    public void addFlags(Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.addFlags(this.getLifespan(), flags);
        }
    }

    @Override
    public void clearFlags(Collection<TraceMemoryFlag> flags) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.clearFlags(this.getLifespan(), flags);
        }
    }

    @Override
    public Set<TraceMemoryFlag> getFlags(long snap) {
        EnumSet<TraceMemoryFlag> result = EnumSet.noneOf(TraceMemoryFlag.class);
        for (TraceMemoryFlag flag : TraceMemoryFlag.values()) {
            DBTraceObjectValue value = this.object.getValue(snap, DBTraceObjectMemoryRegion.keyForFlag(flag));
            if (value == null || value.getValue() != Boolean.TRUE) continue;
            result.add(flag);
        }
        return result;
    }

    @Override
    public Set<TraceMemoryFlag> getFlags() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Set<TraceMemoryFlag> set = this.getFlags(this.getCreationSnap());
            return set;
        }
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.getCanonicalParent(snap) != null;
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected void updateViewsAdded() {
        this.object.getTrace().updateViewsAddRegionBlock(this);
    }

    protected void updateViewsLifespanChanged(Lifespan oldLifespan, Lifespan newLifespan) {
        this.object.getTrace().updateViewsChangeRegionBlockLifespan(this, oldLifespan, newLifespan);
    }

    protected void updateViewsValueChanged(Lifespan lifespan, String key, Object oldValue, Object newValue) {
        DBTrace trace = this.object.getTrace();
        if (this.translator.keys.isRange(key)) {
            trace.updateViewsRefreshBlocks();
        } else if (this.translator.keys.isDisplay(key)) {
            trace.updateViewsChangeRegionBlockName(this);
        } else if (this.translator.keys.isFlag(key)) {
            trace.updateViewsChangeRegionBlockFlags(this, lifespan);
        }
    }

    protected void updateViewsDeleted() {
        this.object.getTrace().updateViewsDeleteRegionBlock(this);
    }

    protected class RegionChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceMemoryRegion> {
        private static final Map<TargetObjectSchema, Keys> KEYS_BY_SCHEMA = new WeakHashMap<TargetObjectSchema, Keys>();
        private final Keys keys;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected RegionChangeTranslator(DBTraceObject object, TraceMemoryRegion iface) {
            super("_range", object, iface);
            TargetObjectSchema schema = object.getTargetSchema();
            Map<TargetObjectSchema, Keys> map = KEYS_BY_SCHEMA;
            synchronized (map) {
                this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, Keys::fromSchema);
            }
        }

        @Override
        protected TraceEvent<TraceMemoryRegion, Void> getAddedType() {
            return TraceEvents.REGION_ADDED;
        }

        @Override
        protected TraceEvent<TraceMemoryRegion, Lifespan> getLifespanChangedType() {
            return TraceEvents.REGION_LIFESPAN_CHANGED;
        }

        @Override
        protected TraceEvent<TraceMemoryRegion, Void> getChangedType() {
            return TraceEvents.REGION_CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return this.keys.all.contains(key);
        }

        @Override
        protected TraceEvent<TraceMemoryRegion, Void> getDeletedType() {
            return TraceEvents.REGION_DELETED;
        }

        @Override
        protected void emitExtraAdded() {
            DBTraceObjectMemoryRegion.this.updateViewsAdded();
        }

        @Override
        protected void emitExtraLifespanChanged(Lifespan oldLifespan, Lifespan newLifespan) {
            DBTraceObjectMemoryRegion.this.updateViewsLifespanChanged(oldLifespan, newLifespan);
        }

        @Override
        protected void emitExtraValueChanged(Lifespan lifespan, String key, Object oldValue, Object newValue) {
            DBTraceObjectMemoryRegion.this.updateViewsValueChanged(lifespan, key, oldValue, newValue);
        }

        @Override
        protected void emitExtraDeleted() {
            DBTraceObjectMemoryRegion.this.updateViewsDeleted();
        }
    }

    protected record Keys(Set<String> all, String range, String display, Set<String> flags) {
        static Keys fromSchema(TargetObjectSchema schema) {
            String keyRange = schema.checkAliasedAttribute("_range");
            String keyDisplay = schema.checkAliasedAttribute("_display");
            String keyReadable = schema.checkAliasedAttribute("_readable");
            String keyWritable = schema.checkAliasedAttribute("_writable");
            String keyExecutable = schema.checkAliasedAttribute("_executable");
            return new Keys(Set.of(keyRange, keyDisplay, keyReadable, keyWritable, keyExecutable), keyRange, keyDisplay, Set.of(keyReadable, keyWritable, keyExecutable));
        }

        public boolean isRange(String key) {
            return this.range.equals(key);
        }

        public boolean isDisplay(String key) {
            return this.display.equals(key);
        }

        public boolean isFlag(String key) {
            return this.flags.contains(key);
        }
    }
}

