/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.module;

import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathUtils;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DBTraceObjectSection
implements TraceObjectSection,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final SectionTranslator translator;
    private AddressRange range;

    public DBTraceObjectSection(DBTraceObject object) {
        this.object = object;
        this.translator = new SectionTranslator(this, object, this);
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public TraceObjectModule getModule() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceObjectModule traceObjectModule = this.object.queryCanonicalAncestorsInterface(TraceObjectModule.class).findAny().orElseThrow();
            return traceObjectModule;
        }
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(this.computeSpan(), name);
        }
    }

    @Override
    public String getName() {
        String key = this.object.getCanonicalPath().key();
        String index = PathUtils.isIndex((String)key) ? PathUtils.parseIndex((String)key) : key;
        return TraceObjectInterfaceUtils.getValue(this.object, this.computeMinSnap(), "_display", String.class, index);
    }

    @Override
    public void setRange(Lifespan lifespan, AddressRange range) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(lifespan, "_range", range);
            this.range = range;
        }
    }

    @Override
    public AddressRange getRange() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            if (this.object.getLife().isEmpty()) {
                AddressRange addressRange = this.range;
                return addressRange;
            }
            AddressRange addressRange = this.range = TraceObjectInterfaceUtils.getValue(this.object, this.computeMinSnap(), "_range", AddressRange.class, this.range);
            return addressRange;
        }
    }

    @Override
    public Lifespan computeSpan() {
        Lifespan span = DBTraceObjectInterface.super.computeSpan();
        if (span != null) {
            return span;
        }
        return this.getModule().computeSpan();
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected class SectionTranslator
    extends DBTraceObjectInterface.Translator<TraceSection> {
        private static final Map<TargetObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TargetObjectSchema, Set<String>>();
        private final Set<String> keys;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected SectionTranslator(DBTraceObjectSection this$0, DBTraceObject object, TraceSection iface) {
            super("_range", object, iface);
            TargetObjectSchema schema = object.getTargetSchema();
            Map<TargetObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
            synchronized (map) {
                this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(s.checkAliasedAttribute("_range"), s.checkAliasedAttribute("_display")));
            }
        }

        @Override
        protected TraceEvent<TraceSection, Void> getAddedType() {
            return TraceEvents.SECTION_ADDED;
        }

        @Override
        protected TraceEvent<TraceSection, Lifespan> getLifespanChangedType() {
            return null;
        }

        @Override
        protected TraceEvent<TraceSection, Void> getChangedType() {
            return TraceEvents.SECTION_CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return this.keys.contains(key);
        }

        @Override
        protected TraceEvent<TraceSection, Void> getDeletedType() {
            return TraceEvents.SECTION_DELETED;
        }
    }
}

