/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.stack;

import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.model.EventType;
import ghidra.program.model.address.Address;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DBTraceObjectStackFrame
implements TraceObjectStackFrame,
DBTraceObjectInterface {
    private static final Map<TargetObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TargetObjectSchema, Set<String>>();
    private final DBTraceObject object;
    private final Set<String> keys;
    private Lifespan.LifeSet life = new Lifespan.DefaultLifeSet();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTraceObjectStackFrame(DBTraceObject object) {
        this.object = object;
        TargetObjectSchema schema = object.getTargetSchema();
        Map<TargetObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
        synchronized (map) {
            this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(schema.checkAliasedAttribute("_pc")));
        }
    }

    @Override
    public TraceObjectStack getStack() {
        try (LockHold hold = this.object.getTrace().lockRead();){
            TraceObjectStack traceObjectStack = this.object.queryCanonicalAncestorsInterface(TraceObjectStack.class).findAny().orElseThrow();
            return traceObjectStack;
        }
    }

    @Override
    public int getLevel() {
        List<String> keys = this.object.getCanonicalPath().getKeyList();
        for (int i = keys.size() - 1; i >= 0; --i) {
            String k = keys.get(i);
            if (!PathUtils.isIndex((String)k)) continue;
            String index = PathUtils.parseIndex((String)k);
            try {
                return Integer.decode(index);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        throw new IllegalStateException("Frame has no index!?");
    }

    @Override
    public Address getProgramCounter(long snap) {
        return TraceObjectInterfaceUtils.getValue(this.object, snap, "_pc", Address.class, null);
    }

    @Override
    public void setProgramCounter(Lifespan span, Address pc) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            if (pc == Address.NO_ADDRESS) {
                pc = null;
            }
            this.object.setValue(span, "_pc", pc);
        }
    }

    @Override
    public String getComment(long snap) {
        try (LockHold hold = this.object.getTrace().lockRead();){
            Address pc = this.getProgramCounter(snap);
            String string = pc == null ? null : this.object.getTrace().getCommentAdapter().getComment(snap, pc, 0);
            return string;
        }
    }

    @Override
    public void setComment(long snap, String comment) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            DBTraceObjectValue pcAttr = this.object.getValue(snap, "_pc");
            this.object.getTrace().getCommentAdapter().setComment(pcAttr.getLifespan(), (Address)pcAttr.getValue(), 0, comment);
        }
    }

    @Override
    public TraceObject getObject() {
        return this.object;
    }

    protected boolean changeApplies(TraceChangeRecord<?, ?> rec) {
        TraceChangeRecord cast = TraceEvents.VALUE_CREATED.cast(rec);
        TraceObjectValue affected = (TraceObjectValue)cast.getAffectedObject();
        assert (affected.getParent() == this.object);
        if (!this.keys.contains(affected.getEntryKey())) {
            return false;
        }
        return this.object.getCanonicalParent(affected.getMaxSnap()) != null;
    }

    @Override
    public Lifespan computeSpan() {
        Lifespan span = DBTraceObjectInterface.super.computeSpan();
        if (span != null) {
            return span;
        }
        return this.getStack().computeSpan();
    }

    protected long snapFor(TraceChangeRecord<?, ?> rec) {
        if (rec.getEventType() == TraceEvents.VALUE_CREATED) {
            return ((TraceObjectValue)TraceEvents.VALUE_CREATED.cast(rec).getAffectedObject()).getMinSnap();
        }
        return this.computeMinSnap();
    }

    protected TraceChangeRecord<?, ?> createChangeRecord() {
        return new TraceChangeRecord<TraceObjectStack, Long>(TraceEvents.STACK_CHANGED, null, this.getStack(), 0L, ((Lifespan)this.life.bound()).lmin());
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        EventType type = rec.getEventType();
        if (type == TraceEvents.OBJECT_LIFE_CHANGED) {
            Lifespan.LifeSet newLife = this.object.getLife();
            if (!newLife.isEmpty()) {
                this.life = newLife;
            }
            return this.createChangeRecord();
        }
        if (type == TraceEvents.VALUE_CREATED && this.changeApplies(rec)) {
            return this.createChangeRecord();
        }
        if (type == TraceEvents.OBJECT_DELETED) {
            if (this.life.isEmpty()) {
                return null;
            }
            return this.createChangeRecord();
        }
        return null;
    }
}

