/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.model.Lifespan;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.TreeMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class CachePerDBTraceObject {
    private static final int MAX_CACHE_KEYS = 200;
    private static final int MAX_VALUES_PER_KEY = 20;
    private static final int MAX_VALUES_ANY_KEY = 4000;
    private static final int EXPANSION = 10;
    private final Map<String, CachedLifespanValues<Long>> perKeyCache = new LinkedHashMap<String, CachedLifespanValues<Long>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, CachedLifespanValues<Long>> eldest) {
            return this.size() > 200;
        }
    };
    private CachedLifespanValues<SnapKey> anyKeyCache = null;

    private Stream<DBTraceObjectValue> doStreamAnyKey(NavigableMap<SnapKey, DBTraceObjectValue> map, Lifespan lifespan) {
        return map.values().stream().filter(v -> lifespan.intersects(v.getLifespan()));
    }

    private Stream<DBTraceObjectValue> doStreamPerKey(NavigableMap<Long, DBTraceObjectValue> map, Lifespan lifespan, boolean forward) {
        Long min = (Long)lifespan.min();
        Map.Entry<Long, DBTraceObjectValue> floor = map.floorEntry(min);
        if (floor != null && floor.getValue().getLifespan().contains(min)) {
            min = floor.getKey();
        }
        NavigableMap<Long, DBTraceObjectValue> sub = map.subMap(min, true, (Long)lifespan.max(), true);
        if (forward) {
            return sub.values().stream();
        }
        return sub.descendingMap().values().stream();
    }

    private DBTraceObjectValue doGetValue(NavigableMap<Long, DBTraceObjectValue> map, long snap) {
        Map.Entry<Long, DBTraceObjectValue> floor = map.floorEntry(snap);
        if (floor == null) {
            return null;
        }
        DBTraceObjectValue value = floor.getValue();
        if (!value.getLifespan().contains(snap)) {
            return null;
        }
        return value;
    }

    public Cached<Stream<DBTraceObjectValue>> streamValues(Lifespan lifespan) {
        if (this.anyKeyCache == null) {
            return Cached.miss();
        }
        if (!this.anyKeyCache.span.encloses(lifespan)) {
            return Cached.miss();
        }
        return Cached.hit(this.doStreamAnyKey(this.anyKeyCache.values, lifespan));
    }

    public Cached<Stream<DBTraceObjectValue>> streamValues(Lifespan lifespan, String key, boolean forward) {
        CachedLifespanValues<Long> cached = this.perKeyCache.get(key);
        if (cached == null) {
            return Cached.miss();
        }
        if (!cached.span.encloses(lifespan)) {
            return Cached.miss();
        }
        return Cached.hit(this.doStreamPerKey(cached.values, lifespan, forward));
    }

    public Cached<DBTraceObjectValue> getValue(long snap, String key) {
        CachedLifespanValues<Long> cached = this.perKeyCache.get(key);
        if (cached == null) {
            return Cached.miss();
        }
        if (!cached.span.contains(snap)) {
            return Cached.miss();
        }
        return Cached.hit(this.doGetValue(cached.values, snap));
    }

    public Lifespan expandLifespan(Lifespan lifespan) {
        long max;
        long min = lifespan.lmin() - 10L;
        if (min > lifespan.lmin()) {
            min = Lifespan.ALL.lmin();
        }
        if ((max = lifespan.lmax() + 10L) < lifespan.lmax()) {
            max = Lifespan.ALL.lmax();
        }
        return Lifespan.span(min, max);
    }

    private DBTraceObjectValue mergeValues(DBTraceObjectValue v1, DBTraceObjectValue v2) {
        throw new IllegalStateException("Conflicting values: %s, %s".formatted(v1, v2));
    }

    private NavigableMap<SnapKey, DBTraceObjectValue> collectAnyKey(Stream<DBTraceObjectValue> values) {
        return values.collect(Collectors.toMap(SnapKey::forValue, v -> v, this::mergeValues, TreeMap::new));
    }

    private NavigableMap<Long, DBTraceObjectValue> collectPerKey(Stream<DBTraceObjectValue> values) {
        return values.collect(Collectors.toMap(v -> (Long)v.getLifespan().min(), v -> v, this::mergeValues, TreeMap::new));
    }

    public Stream<DBTraceObjectValue> offerStreamAnyKey(Lifespan expanded, Stream<DBTraceObjectValue> values, Lifespan lifespan) {
        NavigableMap<SnapKey, DBTraceObjectValue> map = this.collectAnyKey(values);
        this.anyKeyCache = new CachedLifespanValues<SnapKey>(expanded, map);
        return this.doStreamAnyKey(map, lifespan);
    }

    public Stream<DBTraceObjectValue> offerStreamPerKey(Lifespan expanded, Stream<DBTraceObjectValue> values, Lifespan lifespan, String key, boolean forward) {
        NavigableMap<Long, DBTraceObjectValue> map = this.collectPerKey(values);
        this.perKeyCache.put(key, new CachedLifespanValues<Long>(expanded, map));
        return this.doStreamPerKey(map, lifespan, forward);
    }

    public DBTraceObjectValue offerGetValue(Lifespan expanded, Stream<DBTraceObjectValue> values, long snap, String key) {
        NavigableMap<Long, DBTraceObjectValue> map = this.collectPerKey(values);
        this.perKeyCache.put(key, new CachedLifespanValues<Long>(expanded, map));
        return this.doGetValue(map, snap);
    }

    public void notifyValueCreated(DBTraceObjectValue value) {
        CachedLifespanValues<Long> cached;
        Objects.requireNonNull(value);
        if (this.anyKeyCache != null && this.anyKeyCache.span.intersects(value.getLifespan())) {
            this.anyKeyCache.values.put(SnapKey.forValue(value), value);
        }
        if ((cached = this.perKeyCache.get(value.getEntryKey())) != null && cached.span.intersects(value.getLifespan())) {
            cached.values.put((Long)value.getLifespan().min(), value);
        }
    }

    public void notifyValueDeleted(DBTraceObjectValue value) {
        CachedLifespanValues<Long> cached;
        Objects.requireNonNull(value);
        if (this.anyKeyCache != null) {
            this.anyKeyCache.values.remove(SnapKey.forValue(value));
        }
        if ((cached = this.perKeyCache.get(value.getEntryKey())) != null) {
            cached.values.remove(value.getLifespan().min());
        }
    }

    private record CachedLifespanValues<K>(Lifespan span, NavigableMap<K, DBTraceObjectValue> values) {
    }

    public record Cached<T>(boolean isMiss, T value) {
        static final Cached<?> MISS = new Cached<Object>(true, null);

        public static <T> Cached<T> miss() {
            return MISS;
        }

        static <T> Cached<T> hit(T value) {
            return new Cached<T>(false, value);
        }
    }

    private record SnapKey(long snap, String key) implements Comparable<SnapKey>
    {
        @Override
        public int compareTo(SnapKey that) {
            int c = Long.compare(this.snap, that.snap);
            if (c != 0) {
                return c;
            }
            if (this.key == that.key) {
                return 0;
            }
            if (this.key == null) {
                return 1;
            }
            if (that.key == null) {
                return -1;
            }
            return this.key.compareTo(that.key);
        }

        public static SnapKey forValue(DBTraceObjectValue value) {
            return new SnapKey(value.getMinSnap(), value.getEntryKey());
        }
    }
}

