/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.DBHandle;
import db.DBRecord;
import db.StringField;
import ghidra.dbg.target.TargetBreakpointSpec;
import ghidra.dbg.target.TargetObject;
import ghidra.dbg.target.schema.SchemaContext;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.target.schema.XmlSchemaContext;
import ghidra.dbg.util.PathMatcher;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.breakpoint.DBTraceObjectBreakpointLocation;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectValue;
import ghidra.trace.database.target.DBTraceObjectValueBehind;
import ghidra.trace.database.target.DBTraceObjectValueData;
import ghidra.trace.database.target.DBTraceObjectValueNode;
import ghidra.trace.database.target.DBTraceObjectValueRStarTree;
import ghidra.trace.database.target.DBTraceObjectValueWriteBehindCache;
import ghidra.trace.database.target.ImmutableValueShape;
import ghidra.trace.database.target.TraceObjectValueQuery;
import ghidra.trace.database.target.TraceObjectValueStorage;
import ghidra.trace.database.target.ValueSpace;
import ghidra.trace.database.target.visitors.SuccessorsRelativeVisitor;
import ghidra.trace.database.thread.DBTraceObjectThread;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointSpec;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceObjectMemoryRegion;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.stack.TraceObjectStack;
import ghidra.trace.model.stack.TraceObjectStackFrame;
import ghidra.trace.model.target.DuplicateKeyException;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.StreamUtils;
import ghidra.util.UnionAddressSetView;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jdom.JDOMException;

public class DBTraceObjectManager
implements TraceObjectManager,
DBTraceManager {
    private static final int OBJECTS_CONTAINING_CACHE_SIZE = 100;
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBCachedObjectStore<DBTraceObjectSchemaEntry> schemaStore;
    protected final DBCachedObjectStore<DBTraceObject> objectStore;
    protected final DBTraceObjectValueRStarTree valueTree;
    protected final DBTraceObjectValueRStarTree.DBTraceObjectValueMap valueMap;
    protected final DBTraceObjectValueWriteBehindCache valueWbCache;
    protected final DBCachedObjectIndex<TraceObjectKeyPath, DBTraceObject> objectsByPath;
    protected final Collection<TraceObject> objectsView;
    protected TargetObjectSchema rootSchema;
    protected final Map<ObjectsContainingKey, Collection<?>> objectsContainingCache = new LinkedHashMap<ObjectsContainingKey, Collection<?>>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<ObjectsContainingKey, Collection<?>> eldest) {
            return this.size() > 100;
        }
    };
    protected final Map<Class<? extends TraceObjectInterface>, Set<TargetObjectSchema>> schemasByInterface = new HashMap<Class<? extends TraceObjectInterface>, Set<TargetObjectSchema>>();

    public DBTraceObjectManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace) throws IOException, VersionException {
        this.lock = lock;
        this.trace = trace;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.schemaStore = factory.getOrCreateCachedStore("ObjectSchema", DBTraceObjectSchemaEntry.class, DBTraceObjectSchemaEntry::new, true);
        this.loadRootSchema();
        this.objectStore = factory.getOrCreateCachedStore("Objects", DBTraceObject.class, (s, r) -> new DBTraceObject(this, s, r), true);
        this.valueTree = new DBTraceObjectValueRStarTree(this, factory, "ObjectValue", ValueSpace.INSTANCE, DBTraceObjectValueData.class, DBTraceObjectValueNode.class, false, 50);
        this.valueMap = this.valueTree.asSpatialMap();
        this.objectsByPath = this.objectStore.getIndex(TraceObjectKeyPath.class, DBTraceObject.PATH_COLUMN);
        this.valueWbCache = new DBTraceObjectValueWriteBehindCache(this);
        this.objectsView = Collections.unmodifiableCollection(this.objectStore.asMap().values());
    }

    protected void loadRootSchema() {
        if (this.schemaStore.asMap().isEmpty()) {
            this.rootSchema = null;
            return;
        }
        assert (this.schemaStore.asMap().size() == 1);
        DBTraceObjectSchemaEntry schemaEntry = (DBTraceObjectSchemaEntry)this.schemaStore.getObjectAt(0L);
        this.rootSchema = schemaEntry.schema;
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.objectStore.invalidateCache();
        this.valueTree.invalidateCache();
        this.schemaStore.invalidateCache();
        this.loadRootSchema();
        this.objectsContainingCache.clear();
        this.schemasByInterface.clear();
    }

    protected boolean checkMyObject(DBTraceObject object) {
        if (object.manager != this) {
            return false;
        }
        return this.objectStore.asMap().values().contains((Object)object);
    }

    protected DBTraceObject assertIsMine(TraceObject object) {
        if (!(object instanceof DBTraceObject)) {
            throw new IllegalArgumentException("Object " + String.valueOf(object) + " is not part of this trace");
        }
        DBTraceObject dbObject = (DBTraceObject)object;
        if (!this.checkMyObject(dbObject)) {
            throw new IllegalArgumentException("Object " + String.valueOf(object) + " is not part of this trace");
        }
        return dbObject;
    }

    protected Object validatePrimitive(Object value) {
        try {
            DBCachedObjectStoreFactory.PrimitiveCodec.getCodec(value.getClass());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Cannot encode " + String.valueOf(value), e);
        }
        return value;
    }

    protected Object validateValue(Object value) {
        if (value instanceof TraceObject | value instanceof Address | value instanceof AddressRange) {
            return value;
        }
        return this.validatePrimitive(value);
    }

    @Override
    public Trace getTrace() {
        return this.trace;
    }

    protected void setSchema(TargetObjectSchema schema) {
        if (this.rootSchema != null) {
            throw new IllegalStateException("There is already a root object");
        }
        DBTraceObjectSchemaEntry schemaEntry = (DBTraceObjectSchemaEntry)this.schemaStore.create(0L);
        schemaEntry.set(schema);
        this.rootSchema = schema;
    }

    protected void emitValueCreated(DBTraceObject parent, DBTraceObjectValue entry) {
        if (parent == null) {
            return;
        }
        parent.emitEvents(new TraceChangeRecord<DBTraceObjectValue, Void>(TraceEvents.VALUE_CREATED, null, entry));
    }

    protected DBTraceObjectValueData doCreateValueData(Lifespan lifespan, DBTraceObject parent, String key, Object value) {
        DBTraceObjectValueData entry = (DBTraceObjectValueData)this.valueMap.put(new ImmutableValueShape(parent, value, key, lifespan), null);
        if (!(value instanceof DBTraceObject)) {
            entry.doSetPrimitive(value);
        }
        return entry;
    }

    protected DBTraceObjectValue doCreateValue(Lifespan lifespan, DBTraceObject parent, String key, Object value) {
        DBTraceObjectValue entry;
        DBTraceObjectValue dBTraceObjectValue = entry = parent == null ? this.doCreateValueData(lifespan, parent, key, value).getWrapper() : this.valueWbCache.doCreateValue(lifespan, parent, key, value).getWrapper();
        if (parent != null) {
            parent.notifyValueCreated(entry);
        }
        if (value instanceof DBTraceObject) {
            DBTraceObject child = (DBTraceObject)value;
            child.notifyParentValueCreated(entry);
        }
        this.invalidateObjectsContainingCache();
        this.emitValueCreated(parent, entry);
        return entry;
    }

    protected DBTraceObject doCreateObject(TraceObjectKeyPath path) {
        DBTraceObject obj = (DBTraceObject)this.objectsByPath.getOne((Object)path);
        if (obj != null) {
            return obj;
        }
        obj = (DBTraceObject)this.objectStore.create();
        obj.set(path);
        obj.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(TraceEvents.OBJECT_CREATED, null, obj));
        return obj;
    }

    protected DBTraceObject doGetObject(TraceObjectKeyPath path) {
        return (DBTraceObject)this.objectsByPath.getOne((Object)path);
    }

    @Override
    public DBTraceObject createObject(TraceObjectKeyPath path) {
        if (path.isRoot()) {
            throw new IllegalArgumentException("Cannot create non-root object with root path");
        }
        try (LockHold hold = this.trace.lockWrite();){
            if (this.rootSchema == null) {
                throw new IllegalStateException("No schema! Create the root object, first.");
            }
            DBTraceObject dBTraceObject = this.doCreateObject(path);
            return dBTraceObject;
        }
    }

    @Override
    public DBTraceObjectValue createRootObject(TargetObjectSchema schema) {
        try (LockHold hold = this.trace.lockWrite();){
            DBTraceObjectValueData data;
            TraceObjectValueStorage traceObjectValueStorage;
            this.setSchema(schema);
            DBTraceObject root = this.doCreateObject(TraceObjectKeyPath.of(new String[0]));
            assert (root.getKey() == 0L);
            DBTraceObjectValue val = this.doCreateValue(Lifespan.ALL, null, "", root);
            assert ((traceObjectValueStorage = val.getWrapped()) instanceof DBTraceObjectValueData && (data = (DBTraceObjectValueData)traceObjectValueStorage).getKey() == 0L);
            DBTraceObjectValue dBTraceObjectValue = val;
            return dBTraceObjectValue;
        }
    }

    @Override
    public TargetObjectSchema getRootSchema() {
        try (LockHold hold = this.trace.lockRead();){
            TargetObjectSchema targetObjectSchema = this.rootSchema;
            return targetObjectSchema;
        }
    }

    public DBTraceObjectValue getRootValue() {
        try (LockHold hold = this.trace.lockRead();){
            DBTraceObjectValueData data = (DBTraceObjectValueData)this.valueTree.getDataStore().getObjectAt(0L);
            DBTraceObjectValue dBTraceObjectValue = data == null ? null : data.getWrapper();
            return dBTraceObjectValue;
        }
    }

    @Override
    public DBTraceObject getRootObject() {
        return this.getObjectById(0L);
    }

    @Override
    public DBTraceObject getObjectById(long key) {
        try (LockHold hold = this.trace.lockRead();){
            DBTraceObject dBTraceObject = (DBTraceObject)this.objectStore.getObjectAt(key);
            return dBTraceObject;
        }
    }

    @Override
    public DBTraceObject getObjectByCanonicalPath(TraceObjectKeyPath path) {
        return (DBTraceObject)this.objectsByPath.getOne((Object)path);
    }

    public Stream<? extends DBTraceObject> getObjectsByPath(Lifespan span, TraceObjectKeyPath path) {
        DBTraceObject root = this.getRootObject();
        return this.getValuePaths(span, (PathPredicates)new PathPattern(path.getKeyList())).map(p -> p.getDestinationValue(root)).filter(DBTraceObject.class::isInstance).map(DBTraceObject.class::cast);
    }

    @Override
    public Stream<? extends TraceObjectValPath> getValuePaths(Lifespan span, PathPredicates predicates) {
        try (LockHold hold = this.trace.lockRead();){
            DBTraceObjectValue rootVal = this.getRootValue();
            if (rootVal == null) {
                Stream<TraceObjectValPath> stream = Stream.of(new TraceObjectValPath[0]);
                return stream;
            }
            Stream<? extends TraceObjectValPath> stream = rootVal.doStreamVisitor(span, new SuccessorsRelativeVisitor(predicates));
            return stream;
        }
    }

    public Stream<DBTraceObject> getAllObjects() {
        return this.objectStore.asMap().values().stream();
    }

    @Override
    public int getObjectCount() {
        return this.objectStore.getRecordCount();
    }

    public Stream<DBTraceObjectValue> getAllValues() {
        return Stream.concat(this.valueMap.values().stream().map(v -> v.getWrapper()), StreamUtils.lock((Lock)this.lock.readLock(), this.valueWbCache.streamAllValues().map(v -> v.getWrapper())));
    }

    protected Stream<DBTraceObjectValueData> streamValuesIntersectingData(Lifespan span, AddressRange range, String entryKey) {
        return this.valueMap.reduce(TraceObjectValueQuery.intersecting(entryKey != null ? entryKey : ValueSpace.EntryKeyDimension.INSTANCE.absoluteMin(), entryKey != null ? entryKey : ValueSpace.EntryKeyDimension.INSTANCE.absoluteMax(), span, range)).values().stream();
    }

    protected Stream<DBTraceObjectValueBehind> streamValuesIntersectingBehind(Lifespan span, AddressRange range, String entryKey) {
        return this.valueWbCache.streamValuesIntersecting(span, range, entryKey);
    }

    @Override
    public Collection<? extends TraceObjectValue> getValuesIntersecting(Lifespan span, AddressRange range, String entryKey) {
        return Stream.concat(this.streamValuesIntersectingData(span, range, entryKey).map(v -> v.getWrapper()), this.streamValuesIntersectingBehind(span, range, entryKey).map(v -> v.getWrapper())).toList();
    }

    protected Stream<DBTraceObjectValueData> streamValuesAtData(long snap, Address address, String entryKey) {
        return this.valueMap.reduce(TraceObjectValueQuery.at(entryKey, snap, address)).values().stream();
    }

    protected Stream<DBTraceObjectValueBehind> streamValuesAtBehind(long snap, Address address, String entryKey) {
        return this.valueWbCache.streamValuesAt(snap, address, entryKey);
    }

    public Collection<? extends TraceObjectValue> getValuesAt(long snap, Address address, String entryKey) {
        return Stream.concat(this.streamValuesAtData(snap, address, entryKey).map(v -> v.getWrapper()), this.streamValuesAtBehind(snap, address, entryKey).map(v -> v.getWrapper())).toList();
    }

    @Override
    public <I extends TraceObjectInterface> Stream<I> queryAllInterface(Lifespan span, Class<I> ifClass) {
        if (this.rootSchema == null) {
            throw new IllegalStateException("There is no schema. Create a root object.");
        }
        Class<? extends TargetObject> targetIf = TraceObjectInterfaceUtils.toTargetIf(ifClass);
        PathMatcher matcher = this.rootSchema.searchFor(targetIf, true);
        return this.getValuePaths(span, (PathPredicates)matcher).filter(p -> {
            TraceObject object = p.getDestination(this.getRootObject());
            if (object == null) {
                Msg.error((Object)this, (Object)("NULL VALUE! " + String.valueOf(p.getLastEntry())));
                return false;
            }
            return true;
        }).map(p -> p.getDestination(this.getRootObject()).queryInterface(ifClass));
    }

    @Override
    public void cullDisconnectedObjects() {
        try (LockHold hold = this.trace.lockWrite();){
            for (DBTraceObject obj : this.objectStore.asMap().values()) {
                if (obj.doIsConnected()) continue;
                obj.delete();
            }
        }
    }

    @Override
    public void clear() {
        try (LockHold hold = this.trace.lockWrite();){
            this.valueMap.clear();
            this.valueWbCache.clear();
            this.objectStore.deleteAll();
            this.schemaStore.deleteAll();
            this.rootSchema = null;
            this.objectsContainingCache.clear();
            this.schemasByInterface.clear();
        }
    }

    protected void doDeleteObject(DBTraceObject object) {
        this.objectStore.delete((DBAnnotatedObject)object);
        object.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(TraceEvents.OBJECT_DELETED, null, object));
    }

    protected void doDeleteValue(DBTraceObjectValueData value) {
        this.valueTree.doDeleteEntry(value);
        this.invalidateObjectsContainingCache();
    }

    protected void doDeleteCachedValue(DBTraceObjectValueBehind value) {
        this.valueWbCache.remove(value);
        this.invalidateObjectsContainingCache();
    }

    public boolean hasSchema() {
        return this.rootSchema != null;
    }

    protected <I extends TraceObjectInterface> I doAddWithInterface(List<String> keyList, Class<I> iface) {
        Class<? extends TargetObject> targetIf = TraceObjectInterfaceUtils.toTargetIf(iface);
        TargetObjectSchema schema = this.rootSchema.getSuccessorSchema(keyList);
        if (!schema.getInterfaces().contains(targetIf)) {
            throw new IllegalStateException("Schema " + String.valueOf(schema) + " at " + PathUtils.toString(keyList) + " does not provide interface " + iface.getSimpleName());
        }
        DBTraceObject obj = this.createObject(TraceObjectKeyPath.of(keyList));
        return obj.queryInterface(iface);
    }

    protected <I extends TraceObjectInterface> I doAddWithInterface(String path, Class<I> iface) {
        return this.doAddWithInterface(PathUtils.parse((String)path), iface);
    }

    public <I extends TraceObjectInterface> Collection<I> getAllObjects(Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.queryAllInterface(Lifespan.ALL, iface).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> Collection<I> getObjectsByPath(String path, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.getObjectsByPath(Lifespan.ALL, TraceObjectKeyPath.parse(path)).map(o -> o.queryInterface(iface)).filter(i -> i != null).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> I getObjectByPath(long snap, String path, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectKeyPath parsed = TraceObjectKeyPath.parse(path);
            DBTraceObject object = this.getObjectByCanonicalPath(parsed);
            if (object != null) {
                I i = object.queryInterface(iface);
                return i;
            }
            TraceObjectInterface traceObjectInterface = this.getObjectsByPath(Lifespan.at(snap), parsed).findAny().map(o -> o.queryInterface(iface)).orElse(null);
            return (I)traceObjectInterface;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void invalidateObjectsContainingCache() {
        Map<ObjectsContainingKey, Collection<?>> map = this.objectsContainingCache;
        synchronized (map) {
            this.objectsContainingCache.clear();
        }
    }

    protected Collection<? extends TraceObjectInterface> doGetObjectsContaining(ObjectsContainingKey key) {
        return this.getObjectsIntersecting(Lifespan.at(key.snap), (AddressRange)new AddressRangeImpl(key.address, key.address), key.key, key.iface);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I extends TraceObjectInterface> Collection<I> getObjectsContaining(long snap, Address address, String key, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Map<ObjectsContainingKey, Collection<?>> map = this.objectsContainingCache;
            synchronized (map) {
                Collection collection = this.objectsContainingCache.computeIfAbsent(new ObjectsContainingKey(snap, address, key, iface), this::doGetObjectsContaining);
                return collection;
            }
        }
    }

    public <I extends TraceObjectInterface> I getObjectContaining(long snap, Address address, String key, Class<I> iface) {
        Collection<I> col = this.getObjectsContaining(snap, address, key, iface);
        if (col.isEmpty()) {
            return null;
        }
        return (I)((TraceObjectInterface)col.iterator().next());
    }

    protected Set<TargetObjectSchema> collectSchemasForInterface(Class<? extends TraceObjectInterface> iface) {
        if (this.rootSchema == null) {
            return Set.of();
        }
        Class<? extends TargetObject> targetIf = TraceObjectInterfaceUtils.toTargetIf(iface);
        HashSet<TargetObjectSchema> result = new HashSet<TargetObjectSchema>();
        for (TargetObjectSchema schema : this.rootSchema.getContext().getAllSchemas()) {
            if (!schema.getInterfaces().contains(targetIf)) continue;
            result.add(schema);
        }
        return Set.copyOf(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <I extends TraceObjectInterface> Collection<I> getObjectsIntersecting(Lifespan lifespan, AddressRange range, String key, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Set schemas;
            Map<Class<? extends TraceObjectInterface>, Set<TargetObjectSchema>> map = this.schemasByInterface;
            synchronized (map) {
                schemas = this.schemasByInterface.computeIfAbsent(iface, this::collectSchemasForInterface);
            }
            Map<String, List<TargetObjectSchema>> schemasByAliasTo = schemas.stream().collect(Collectors.groupingBy(s -> s.checkAliasedAttribute(key)));
            Collection collection = schemasByAliasTo.entrySet().stream().flatMap(ent -> this.getValuesIntersecting(lifespan, range, (String)ent.getKey()).stream().map(v -> v.getParent()).filter(o -> ((List)ent.getValue()).contains(o.getTargetSchema()))).map(o -> o.queryInterface(iface)).collect(Collectors.toSet());
            return collection;
        }
    }

    public <I extends TraceObjectInterface> Collection<I> getObjectsAtSnap(long snap, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            Collection collection = this.queryAllInterface(Lifespan.at(snap), iface).collect(Collectors.toSet());
            return collection;
        }
    }

    static <I extends TraceObjectInterface> boolean acceptValue(DBTraceObjectValue value, String key, Class<I> ifaceCls, Predicate<? super I> predicate) {
        if (!value.hasEntryKey(key)) {
            return false;
        }
        DBTraceObject parent = value.getParent();
        I iface = parent.queryInterface(ifaceCls);
        if (iface == null) {
            return false;
        }
        return predicate.test(iface);
    }

    public <I extends TraceObjectInterface> AddressSetView getObjectsAddressSet(long snap, String key, Class<I> ifaceCls, Predicate<? super I> predicate) {
        return new UnionAddressSetView(new AddressSetView[]{this.valueMap.getAddressSetView(Lifespan.at(snap), v -> DBTraceObjectManager.acceptValue(v.getWrapper(), key, ifaceCls, predicate)), this.valueWbCache.getObjectsAddressSet(snap, key, ifaceCls, predicate)});
    }

    public <I extends TraceObjectInterface> I getSuccessor(TraceObject seed, PathPredicates predicates, long snap, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectInterface traceObjectInterface = seed.getSuccessors(Lifespan.at(snap), predicates).map(p -> p.getDestination(seed).queryInterface(iface)).filter(i -> i != null).findAny().orElse(null);
            return (I)traceObjectInterface;
        }
    }

    public <I extends TraceObjectInterface> I getLatestSuccessor(TraceObject seed, TraceObjectKeyPath path, long snap, Class<I> iface) {
        try (LockHold hold = this.trace.lockRead();){
            TraceObjectInterface traceObjectInterface = seed.getOrderedSuccessors(Lifespan.toNow(snap), path, false).map(p -> p.getDestination(seed).queryInterface(iface)).filter(i -> i != null).findAny().orElse(null);
            return (I)traceObjectInterface;
        }
    }

    public TraceObjectBreakpointLocation addBreakpoint(String path, Lifespan lifespan, AddressRange range, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        DBTraceObjectBreakpointLocation dBTraceObjectBreakpointLocation;
        block9: {
            List specPath = this.getRootSchema().searchForAncestor(TargetBreakpointSpec.class, PathUtils.parse((String)path));
            if (specPath == null) {
                throw new IllegalStateException("The schema does not provide an implicit breakpoint specification on the given path.");
            }
            LockHold hold = this.trace.lockWrite();
            try {
                DBTraceObjectBreakpointLocation loc = (DBTraceObjectBreakpointLocation)this.doAddWithInterface(path, TraceObjectBreakpointLocation.class);
                loc.setName(lifespan, path);
                loc.setRange(lifespan, range);
                loc.setEnabled(lifespan, enabled);
                loc.setComment(lifespan, comment);
                TraceObjectBreakpointSpec spec = loc.getOrCreateSpecification();
                spec.setKinds(lifespan, kinds);
                loc.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                dBTraceObjectBreakpointLocation = loc;
                if (hold == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return dBTraceObjectBreakpointLocation;
    }

    public TraceObjectMemoryRegion addMemoryRegion(String path, Lifespan lifespan, AddressRange range, Collection<TraceMemoryFlag> flags) throws TraceOverlappedRegionException {
        try (LockHold hold = this.trace.lockWrite();){
            TraceObjectMemoryRegion region = this.doAddWithInterface(path, TraceObjectMemoryRegion.class);
            region.setName(lifespan, path);
            region.setRange(lifespan, range);
            region.setFlags(lifespan, flags);
            region.getObject().insert(lifespan, TraceObject.ConflictResolution.TRUNCATE);
            TraceObjectMemoryRegion traceObjectMemoryRegion = region;
            return traceObjectMemoryRegion;
        }
    }

    public TraceObjectModule addModule(String path, String name, Lifespan lifespan, AddressRange range) throws DuplicateNameException {
        TraceObjectModule traceObjectModule;
        block8: {
            LockHold hold = this.trace.lockWrite();
            try {
                TraceObjectModule module = this.doAddWithInterface(path, TraceObjectModule.class);
                module.setName(lifespan, name);
                module.setRange(lifespan, range);
                module.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectModule = module;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectModule;
    }

    public TraceObjectSection addSection(String path, String name, Lifespan lifespan, AddressRange range) throws DuplicateNameException {
        TraceObjectSection traceObjectSection;
        block8: {
            LockHold hold = this.trace.lockWrite();
            try {
                TraceObjectSection section = this.doAddWithInterface(path, TraceObjectSection.class);
                section.setName(lifespan, name);
                section.setRange(lifespan, range);
                section.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectSection = section;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectSection;
    }

    public TraceObjectStack addStack(List<String> keyList, long snap) {
        try (LockHold hold = this.trace.lockWrite();){
            TraceObjectStack stack = this.doAddWithInterface(keyList, TraceObjectStack.class);
            stack.getObject().insert(Lifespan.at(snap), TraceObject.ConflictResolution.DENY);
            TraceObjectStack traceObjectStack = stack;
            return traceObjectStack;
        }
    }

    public TraceObjectStackFrame addStackFrame(List<String> keyList, long snap) {
        try (LockHold hold = this.trace.lockWrite();){
            TraceObjectStackFrame frame = this.doAddWithInterface(keyList, TraceObjectStackFrame.class);
            frame.getObject().insert(Lifespan.at(snap), TraceObject.ConflictResolution.DENY);
            TraceObjectStackFrame traceObjectStackFrame = frame;
            return traceObjectStackFrame;
        }
    }

    protected void checkDuplicateThread(String path, Lifespan lifespan) throws DuplicateNameException {
        DBTraceObject exists = this.getObjectByCanonicalPath(TraceObjectKeyPath.parse(path));
        if (exists == null) {
            return;
        }
        if (!exists.getLife().intersects(lifespan)) {
            return;
        }
        throw new DuplicateNameException("A thread having path '" + path + "' already exists within an overlapping snap");
    }

    public TraceObjectThread addThread(String path, String display, Lifespan lifespan) throws DuplicateNameException {
        TraceObjectThread traceObjectThread;
        block8: {
            LockHold hold = this.trace.lockWrite();
            try {
                this.checkDuplicateThread(path, lifespan);
                TraceObjectThread thread = this.doAddWithInterface(path, TraceObjectThread.class);
                thread.setName(lifespan.withMax(Lifespan.DOMAIN.lmax()), display);
                thread.getObject().insert(lifespan, TraceObject.ConflictResolution.DENY);
                traceObjectThread = thread;
                if (hold == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (hold != null) {
                        try {
                            hold.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (DuplicateKeyException e) {
                    throw new DuplicateNameException(e.getMessage());
                }
            }
            hold.close();
        }
        return traceObjectThread;
    }

    public TraceThread assertMyThread(TraceThread thread) {
        if (!(thread instanceof DBTraceObjectThread)) {
            throw new AssertionError((Object)("Thread " + String.valueOf(thread) + " is not an object in this trace"));
        }
        DBTraceObjectThread dbThread = (DBTraceObjectThread)thread;
        if (!this.checkMyObject(dbThread.getObject())) {
            throw new AssertionError((Object)("Thread " + String.valueOf(thread) + " is not an object in this trace"));
        }
        return dbThread;
    }

    public void flushWbCaches() {
        this.valueWbCache.flush();
    }

    public void waitWbWorkers() {
        this.valueWbCache.waitWorkers();
    }

    @DBAnnotatedObjectInfo(version=0)
    protected static final class DBTraceObjectSchemaEntry
    extends DBAnnotatedObject {
        public static final String TABLE_NAME = "ObjectSchema";
        static final String CONTEXT_COLUMN_NAME = "Context";
        static final String SCHEMA_COLUMN_NAME = "Schema";
        @DBAnnotatedColumn(value="Context")
        static DBObjectColumn CONTEXT_COLUMN;
        @DBAnnotatedColumn(value="Schema")
        static DBObjectColumn SCHEMA_COLUMN;
        @DBAnnotatedField(column="Context", codec=DBTraceObjectSchemaDBFieldCodec.class)
        private SchemaContext context;
        @DBAnnotatedField(column="Schema")
        private String schemaName;
        private TargetObjectSchema schema;

        public DBTraceObjectSchemaEntry(DBCachedObjectStore<?> store, DBRecord record) {
            super(store, record);
        }

        protected void fresh(boolean created) throws IOException {
            if (created) {
                return;
            }
            this.schema = this.context.getSchema(new TargetObjectSchema.SchemaName(this.schemaName));
        }

        protected void set(TargetObjectSchema schema) {
            this.context = schema.getContext();
            this.schemaName = schema.getName().toString();
            this.update(CONTEXT_COLUMN, SCHEMA_COLUMN);
        }
    }

    record ObjectsContainingKey(long snap, Address address, String key, Class<? extends TraceObjectInterface> iface) {
    }

    public static class DBTraceObjectSchemaDBFieldCodec
    extends DBCachedObjectStoreFactory.AbstractDBFieldCodec<SchemaContext, DBTraceObjectSchemaEntry, StringField> {
        public DBTraceObjectSchemaDBFieldCodec(Class<DBTraceObjectSchemaEntry> objectType, Field field, int column) {
            super(SchemaContext.class, objectType, StringField.class, field, column);
        }

        protected String encode(SchemaContext value) {
            return value == null ? null : XmlSchemaContext.serialize((SchemaContext)value);
        }

        protected SchemaContext decode(String xml) {
            try {
                return xml == null ? null : XmlSchemaContext.deserialize((String)xml);
            }
            catch (JDOMException e) {
                throw new IllegalArgumentException("Invalid XML-encoded schema context");
            }
        }

        public void store(SchemaContext value, StringField f) {
            f.setString(this.encode(value));
        }

        protected void doStore(DBTraceObjectSchemaEntry obj, DBRecord record) throws IllegalAccessException {
            record.setString(this.column, this.encode((SchemaContext)this.getValue(obj)));
        }

        protected void doLoad(DBTraceObjectSchemaEntry obj, DBRecord record) throws IllegalAccessException {
            this.setValue(obj, this.decode(record.getString(this.column)));
        }
    }
}

