/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import ghidra.trace.database.DBTraceUtils;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.DBTraceObjectValueData;
import ghidra.trace.database.target.TraceObjectValueStorage;
import ghidra.trace.database.target.visitors.TreeTraversal;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.StreamUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.locks.Lock;
import java.util.stream.Stream;

public class DBTraceObjectValue
implements TraceObjectValue {
    private final DBTraceObjectManager manager;
    private volatile TraceObjectValueStorage wrapped;

    public DBTraceObjectValue(DBTraceObjectManager manager, TraceObjectValueStorage wrapped) {
        this.manager = manager;
        this.wrapped = wrapped;
    }

    public String toString() {
        return this.wrapped.toString();
    }

    void setWrapped(TraceObjectValueStorage wrapped) {
        this.wrapped = wrapped;
        if (wrapped instanceof DBTraceObjectValueData) {
            DBTraceObjectValueData data = (DBTraceObjectValueData)wrapped;
            data.setWrapper(this);
        }
    }

    void doSetLifespanAndEmit(Lifespan lifespan) {
        Lifespan oldLifespan = this.getLifespan();
        this.doSetLifespan(lifespan);
        this.getParent().emitEvents(new TraceChangeRecord<DBTraceObjectValue, Lifespan>(TraceEvents.VALUE_LIFESPAN_CHANGED, null, this, oldLifespan, lifespan));
    }

    @Override
    public Trace getTrace() {
        return this.manager.trace;
    }

    @Override
    public String getEntryKey() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            String string = this.wrapped.getEntryKey();
            return string;
        }
    }

    protected TraceObjectKeyPath doGetCanonicalPath() {
        DBTraceObject parent = this.wrapped.getParent();
        if (parent == null) {
            return TraceObjectKeyPath.of(new String[0]);
        }
        return parent.getCanonicalPath().extend(this.wrapped.getEntryKey());
    }

    @Override
    public TraceObjectKeyPath getCanonicalPath() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            TraceObjectKeyPath traceObjectKeyPath = this.doGetCanonicalPath();
            return traceObjectKeyPath;
        }
    }

    @Override
    public Object getValue() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Object object = this.wrapped.getValue();
            return object;
        }
    }

    @Override
    public boolean isObject() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            boolean bl = this.wrapped.getChildOrNull() != null;
            return bl;
        }
    }

    protected boolean doIsCanonical() {
        DBTraceObject child = this.wrapped.getChildOrNull();
        if (child == null) {
            return false;
        }
        if (this.wrapped.getParent() == null) {
            return true;
        }
        return this.doGetCanonicalPath().equals(child.getCanonicalPath());
    }

    @Override
    public boolean isCanonical() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            boolean bl = this.doIsCanonical();
            return bl;
        }
    }

    @Override
    public Lifespan getLifespan() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            Lifespan lifespan = this.wrapped.getLifespan();
            return lifespan;
        }
    }

    @Override
    public void setMinSnap(long minSnap) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.setLifespan(Lifespan.span(minSnap, this.getLifespan().lmax()));
        }
    }

    @Override
    public long getMinSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            long l = this.wrapped.getLifespan().lmin();
            return l;
        }
    }

    @Override
    public void setMaxSnap(long maxSnap) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.setLifespan(Lifespan.span(this.getLifespan().lmin(), maxSnap));
        }
    }

    @Override
    public long getMaxSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            long l = this.wrapped.getLifespan().lmax();
            return l;
        }
    }

    void doDelete() {
        this.getParent().notifyValueDeleted(this);
        DBTraceObject child = this.wrapped.getChildOrNull();
        if (child != null) {
            child.notifyParentValueDeleted(this);
        }
        this.wrapped.doDelete();
    }

    void doDeleteAndEmit() {
        DBTraceObject parent = this.getParent();
        this.doDelete();
        parent.emitEvents(new TraceChangeRecord<DBTraceObjectValue, Void>(TraceEvents.VALUE_DELETED, null, this));
    }

    @Override
    public void delete() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.getParent() == null) {
                throw new IllegalArgumentException("Cannot delete root value");
            }
            this.doDeleteAndEmit();
        }
    }

    @Override
    public boolean isDeleted() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            boolean bl = this.wrapped.isDeleted();
            return bl;
        }
    }

    @Override
    public DBTraceObjectValue truncateOrDelete(Lifespan span) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            if (this.wrapped.getParent() == null) {
                throw new IllegalArgumentException("Cannot truncate or delete root value");
            }
            DBTraceObjectValue dBTraceObjectValue = this.doTruncateOrDeleteAndEmitLifeChange(span);
            return dBTraceObjectValue;
        }
    }

    @Override
    public DBTraceObject getChild() {
        try (LockHold hold = this.manager.trace.lockRead();){
            DBTraceObject dBTraceObject = (DBTraceObject)this.wrapped.getValue();
            return dBTraceObject;
        }
    }

    @Override
    public void setLifespan(Lifespan lifespan) {
        this.setLifespan(lifespan, TraceObject.ConflictResolution.TRUNCATE);
    }

    @Override
    public void setLifespan(Lifespan lifespan, TraceObject.ConflictResolution resolution) {
        try (LockHold hold = this.getTrace().lockWrite();){
            if (this.getParent() == null) {
                throw new IllegalArgumentException("Cannot set lifespan of root value");
            }
            if (resolution == TraceObject.ConflictResolution.DENY) {
                this.getParent().doCheckConflicts(lifespan, this.getEntryKey(), this.getValue());
            } else if (resolution == TraceObject.ConflictResolution.ADJUST) {
                lifespan = this.getParent().doAdjust(lifespan, this.getEntryKey(), this.getValue());
            }
            new ValueLifespanSetter(lifespan, this.getValue(), this){

                protected Iterable<DBTraceObjectValue> getIntersecting(Long lower, Long upper) {
                    return StreamUtils.iter(DBTraceObjectValue.this.getParent().streamValuesR(Lifespan.span(lower, upper), DBTraceObjectValue.this.getEntryKey(), true).filter(v -> v != this.keep));
                }

                @Override
                protected DBTraceObjectValue create(Lifespan range, Object value) {
                    return DBTraceObjectValue.this.getParent().doCreateValue(range, DBTraceObjectValue.this.getEntryKey(), value);
                }
            }.set(lifespan, this.getValue());
            if (this.isObject()) {
                DBTraceObject child = this.getChild();
                child.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(TraceEvents.OBJECT_LIFE_CHANGED, null, child));
            }
        }
    }

    void doSetLifespan(Lifespan lifespan) {
        if (this.wrapped.getLifespan().equals(lifespan)) {
            return;
        }
        DBTraceObject parent = this.wrapped.getParent();
        DBTraceObject child = this.wrapped.getChildOrNull();
        parent.notifyValueDeleted(this);
        if (child != null) {
            child.notifyParentValueDeleted(this);
        }
        this.wrapped.doSetLifespan(lifespan);
        parent.notifyValueCreated(this);
        if (child != null) {
            child.notifyParentValueCreated(this);
        }
    }

    DBTraceObjectValue doTruncateOrDeleteAndEmitLifeChange(Lifespan span) {
        if (!this.isCanonical()) {
            return this.doTruncateOrDelete(span);
        }
        DBTraceObject child = this.wrapped.getChildOrNull();
        DBTraceObjectValue result = this.doTruncateOrDelete(span);
        child.emitEvents(new TraceChangeRecord<DBTraceObject, Void>(TraceEvents.OBJECT_LIFE_CHANGED, null, child));
        return result;
    }

    DBTraceObjectValue doTruncateOrDelete(Lifespan span) {
        List removed = this.getLifespan().subtract(span);
        if (removed.isEmpty()) {
            this.doDeleteAndEmit();
            return null;
        }
        this.doSetLifespanAndEmit((Lifespan)removed.get(0));
        if (removed.size() == 2) {
            return this.getParent().doCreateValue((Lifespan)removed.get(1), this.getEntryKey(), this.getValue());
        }
        return this;
    }

    @Override
    public DBTraceObject getParent() {
        try (LockHold hold = this.manager.trace.lockRead();){
            DBTraceObject dBTraceObject = this.wrapped.getParent();
            return dBTraceObject;
        }
    }

    protected Stream<? extends TraceObjectValPath> doStreamVisitor(Lifespan span, TreeTraversal.Visitor visitor) {
        return TreeTraversal.INSTANCE.walkValue(visitor, this, span, null);
    }

    public TraceObjectValueStorage getWrapped() {
        return this.wrapped;
    }

    static abstract class ValueLifespanSetter
    extends DBTraceUtils.LifespanMapSetter<DBTraceObjectValue, Object> {
        protected final Lifespan range;
        protected final Object value;
        protected DBTraceObjectValue keep = null;
        protected Collection<DBTraceObjectValue> kept = new ArrayList<DBTraceObjectValue>(2);

        public ValueLifespanSetter(Lifespan range, Object value) {
            this.range = range;
            this.value = value;
        }

        public ValueLifespanSetter(Lifespan range, Object value, DBTraceObjectValue keep) {
            this(range, value);
            this.keep = keep;
        }

        protected Lifespan getRange(DBTraceObjectValue entry) {
            return entry.getLifespan();
        }

        protected Object getValue(DBTraceObjectValue entry) {
            return entry.getValue();
        }

        protected boolean valuesEqual(Object v1, Object v2) {
            Object[] a1;
            if (Objects.equals(v1, v2)) {
                return true;
            }
            if (v1 == null || !v1.getClass().isArray()) {
                return false;
            }
            if (v1 instanceof boolean[]) {
                a1 = (boolean[])v1;
                if (v2 instanceof boolean[]) {
                    boolean[] a2 = (boolean[])v2;
                    return Arrays.equals(a1, a2);
                }
            }
            if (v1 instanceof byte[]) {
                a1 = (byte[])v1;
                if (v2 instanceof byte[]) {
                    byte[] a2 = (byte[])v2;
                    return Arrays.equals((byte[])a1, a2);
                }
            }
            if (v1 instanceof char[]) {
                a1 = (char[])v1;
                if (v2 instanceof char[]) {
                    char[] a2 = (char[])v2;
                    return Arrays.equals((char[])a1, a2);
                }
            }
            if (v1 instanceof double[]) {
                a1 = (double[])v1;
                if (v2 instanceof double[]) {
                    double[] a2 = (double[])v2;
                    return Arrays.equals((double[])a1, a2);
                }
            }
            if (v1 instanceof float[]) {
                a1 = (float[])v1;
                if (v2 instanceof float[]) {
                    float[] a2 = (float[])v2;
                    return Arrays.equals((float[])a1, a2);
                }
            }
            if (v1 instanceof int[]) {
                a1 = (int[])v1;
                if (v2 instanceof int[]) {
                    int[] a2 = (int[])v2;
                    return Arrays.equals((int[])a1, a2);
                }
            }
            if (v1 instanceof long[]) {
                a1 = (long[])v1;
                if (v2 instanceof long[]) {
                    long[] a2 = (long[])v2;
                    return Arrays.equals((long[])a1, a2);
                }
            }
            if (v1 instanceof short[]) {
                a1 = (short[])v1;
                if (v2 instanceof short[]) {
                    short[] a2 = (short[])v2;
                    return Arrays.equals((short[])a1, a2);
                }
            }
            return false;
        }

        protected void remove(DBTraceObjectValue entry) {
            if (this.valuesEqual(entry.getValue(), this.value)) {
                if (this.keep == null) {
                    this.keep = entry;
                } else {
                    entry.doDeleteAndEmit();
                }
            } else {
                DBTraceObjectValue created = entry.doTruncateOrDelete(this.range);
                if (!entry.isDeleted()) {
                    this.kept.add(entry);
                }
                if (created != null) {
                    this.kept.add(created);
                }
            }
        }

        protected DBTraceObjectValue put(Lifespan range, Object value) {
            if (value == null) {
                return null;
            }
            if (this.keep != null && this.valuesEqual(this.value, value)) {
                this.keep.doSetLifespanAndEmit(range);
                return this.keep;
            }
            for (DBTraceObjectValue k : this.kept) {
                if (!this.valuesEqual(value, k.getValue()) || !Objects.equals(range, k.getLifespan())) continue;
                this.kept.remove(k);
                return k;
            }
            return this.create(range, value);
        }

        protected abstract DBTraceObjectValue create(Lifespan var1, Object var2);
    }
}

