/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.target;

import db.Transaction;
import ghidra.async.AsyncReference;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressRangeImpl;
import ghidra.program.model.address.AddressRangeIterator;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.target.DBTraceObjectValueBehind;
import ghidra.trace.database.target.DBTraceObjectValueData;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.util.AbstractAddressSetView;
import ghidra.util.LockHold;
import ghidra.util.Msg;
import ghidra.util.StreamUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.locks.Lock;
import java.util.function.Predicate;
import java.util.stream.Stream;

class DBTraceObjectValueWriteBehindCache {
    public static final int INITIAL_CACHE_SIZE = 1000;
    public static final int BATCH_SIZE = 100;
    public static final int DELAY_MS = 10000;
    private final DBTraceObjectManager manager;
    private final Thread worker;
    private volatile long mark = 0L;
    private final AsyncReference<Boolean, Void> busy = new AsyncReference((Object)false);
    private volatile boolean flushing = false;
    private final Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> cachedValues = new HashMap<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>>();

    public DBTraceObjectValueWriteBehindCache(DBTraceObjectManager manager) {
        this.manager = manager;
        this.worker = new Thread(this::workLoop, "WriteBehind for " + manager.trace.getName());
        this.worker.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void workLoop() {
        while (!this.manager.trace.isClosed()) {
            try {
                Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
                synchronized (map) {
                    long left;
                    if (this.cachedValues.isEmpty()) {
                        this.busy.set((Object)false, null);
                        this.flushing = false;
                        this.cachedValues.wait();
                    }
                    while (!this.flushing && (left = this.mark - System.currentTimeMillis()) > 0L) {
                        Msg.trace((Object)this, (Object)"Waiting %d ms. Cache is %d big".formatted(left, this.cachedValues.size()));
                        this.cachedValues.wait(left);
                    }
                }
                if (this.manager.trace.isClosed()) break;
                this.writeBatch();
                if (this.flushing || this.manager.trace.isClosing()) continue;
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.busy.set((Object)false, null);
        this.flushing = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DBTraceObjectValueBehind> getBatch() {
        Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
        synchronized (map) {
            return this.doStreamAllValues().limit(100L).toList();
        }
    }

    private Stream<DBTraceObjectValueBehind> doStreamAllValues() {
        return this.cachedValues.values().stream().flatMap(v -> v.values().stream()).flatMap(v -> v.values().stream());
    }

    private void doAdd(DBTraceObjectValueBehind behind) {
        Map keys = this.cachedValues.computeIfAbsent(behind.getParent(), k -> new HashMap());
        NavigableMap values = keys.computeIfAbsent(behind.getEntryKey(), k -> new TreeMap());
        values.put((Long)behind.getLifespan().min(), behind);
    }

    NavigableMap<Long, DBTraceObjectValueBehind> doRemoveNoCleanup(DBTraceObjectValueBehind behind) {
        Map<String, NavigableMap<Long, DBTraceObjectValueBehind>> keys = this.cachedValues.get(behind.getParent());
        NavigableMap<Long, DBTraceObjectValueBehind> values = keys.get(behind.getEntryKey());
        values.remove(behind.getLifespan().min());
        return values;
    }

    void doAddDirect(NavigableMap<Long, DBTraceObjectValueBehind> values, DBTraceObjectValueBehind b) {
        values.put((Long)b.getLifespan().min(), b);
    }

    private void doRemove(DBTraceObjectValueBehind behind) {
        Map<String, NavigableMap<Long, DBTraceObjectValueBehind>> keys = this.cachedValues.get(behind.getParent());
        NavigableMap<Long, DBTraceObjectValueBehind> values = keys.get(behind.getEntryKey());
        values.remove(behind.getLifespan().min());
        if (values.isEmpty()) {
            keys.remove(behind.getEntryKey());
            if (keys.isEmpty()) {
                this.cachedValues.remove(behind.getParent());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBatch() {
        try (Transaction tx = this.manager.trace.openTransaction("Write Behind");
             LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            for (DBTraceObjectValueBehind behind : this.getBatch()) {
                Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
                synchronized (map) {
                    this.doRemove(behind);
                }
                DBTraceObjectValueData value = this.manager.doCreateValueData(behind.getLifespan(), behind.getParent(), behind.getEntryKey(), behind.getValue());
                behind.getWrapper().setWrapped(value);
            }
        }
        this.manager.trace.clearUndo();
        Msg.trace((Object)this, (Object)"Wrote a batch. %d parents remain.".formatted(this.cachedValues.size()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTraceObjectValueBehind doCreateValue(Lifespan lifespan, DBTraceObject parent, String key, Object value) {
        if (this.manager.trace.isClosing()) {
            throw new IllegalStateException("Trace is closing");
        }
        DBTraceObjectValueBehind entry = new DBTraceObjectValueBehind(this.manager, parent, key, lifespan, this.manager.validateValue(value));
        Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
        synchronized (map) {
            this.doAdd(entry);
            this.mark = System.currentTimeMillis() + 10000L;
            this.busy.set((Object)true, null);
            this.cachedValues.notify();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(DBTraceObjectValueBehind value) {
        Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
        synchronized (map) {
            this.doRemove(value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
        synchronized (map) {
            this.cachedValues.clear();
        }
    }

    public Stream<DBTraceObjectValueBehind> streamAllValues() {
        return StreamUtils.sync(this.cachedValues, this.doStreamAllValues());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DBTraceObjectValueBehind get(DBTraceObject parent, String key, long snap) {
        Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
        synchronized (map) {
            Map<String, NavigableMap<Long, DBTraceObjectValueBehind>> keys = this.cachedValues.get(parent);
            if (keys == null) {
                return null;
            }
            NavigableMap<Long, DBTraceObjectValueBehind> values = keys.get(key);
            if (values == null) {
                return null;
            }
            Map.Entry<Long, DBTraceObjectValueBehind> floor = values.floorEntry(snap);
            if (floor == null) {
                return null;
            }
            if (!floor.getValue().getLifespan().contains(snap)) {
                return null;
            }
            return floor.getValue();
        }
    }

    public Stream<DBTraceObjectValueBehind> streamParents(DBTraceObject child, Lifespan lifespan) {
        return this.streamAllValues().filter(v -> v.getValue() == child && v.getLifespan().intersects(lifespan));
    }

    private Stream<DBTraceObjectValueBehind> streamSub(NavigableMap<Long, DBTraceObjectValueBehind> map, Lifespan span, boolean forward) {
        Map.Entry<Long, DBTraceObjectValueBehind> floor = map.floorEntry((Long)span.min());
        long min = floor != null && floor.getValue().getLifespan().contains((Long)span.min()) ? floor.getKey().longValue() : ((Long)span.min()).longValue();
        NavigableMap<Long, DBTraceObjectValueBehind> sub = map.subMap(min, true, (Long)span.max(), true);
        if (!forward) {
            sub = sub.descendingMap();
        }
        return sub.values().stream();
    }

    public Stream<DBTraceObjectValueBehind> streamCanonicalParents(DBTraceObject child, Lifespan lifespan) {
        TraceObjectKeyPath path = child.getCanonicalPath();
        TraceObjectKeyPath parentPath = path.parent();
        if (parentPath == null) {
            return Stream.of(new DBTraceObjectValueBehind[0]);
        }
        DBTraceObject parent = this.manager.getObjectByCanonicalPath(parentPath);
        if (parent == null) {
            return Stream.of(new DBTraceObjectValueBehind[0]);
        }
        String entryKey = path.key();
        return this.streamValues(parent, entryKey, lifespan, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<DBTraceObjectValueBehind> streamValues(DBTraceObject parent, Lifespan lifespan) {
        Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
        synchronized (map) {
            Map<String, NavigableMap<Long, DBTraceObjectValueBehind>> keys = this.cachedValues.get(parent);
            if (keys == null) {
                return Stream.of(new DBTraceObjectValueBehind[0]);
            }
            return StreamUtils.sync(this.cachedValues, keys.values().stream().flatMap(v -> this.streamSub((NavigableMap<Long, DBTraceObjectValueBehind>)v, lifespan, true)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Stream<DBTraceObjectValueBehind> streamValues(DBTraceObject parent, String key, Lifespan lifespan, boolean forward) {
        Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
        synchronized (map) {
            Map<String, NavigableMap<Long, DBTraceObjectValueBehind>> keys = this.cachedValues.get(parent);
            if (keys == null) {
                return Stream.of(new DBTraceObjectValueBehind[0]);
            }
            NavigableMap<Long, DBTraceObjectValueBehind> values = keys.get(key);
            if (values == null) {
                return Stream.of(new DBTraceObjectValueBehind[0]);
            }
            return StreamUtils.sync(this.cachedValues, this.streamSub(values, lifespan, forward));
        }
    }

    static boolean intersectsRange(Object value, AddressRange range) {
        AddressRange rv;
        Address av;
        return value instanceof Address && range.contains(av = (Address)value) || value instanceof AddressRange && range.intersects(rv = (AddressRange)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Stream<DBTraceObjectValueBehind> streamValuesIntersectingLifespan(Lifespan lifespan, String entryKey) {
        Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = this.cachedValues;
        synchronized (map) {
            Stream<Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> top = this.cachedValues.values().stream();
            Stream keys = entryKey == null ? top.flatMap(v -> v.values().stream()) : top.flatMap(v -> v.entrySet().stream().filter(e -> entryKey.equals(e.getKey())).map(e -> (NavigableMap)e.getValue()));
            return StreamUtils.sync(this.cachedValues, keys.flatMap(v -> this.streamSub((NavigableMap<Long, DBTraceObjectValueBehind>)v, lifespan, true)));
        }
    }

    public Stream<DBTraceObjectValueBehind> streamValuesIntersecting(Lifespan lifespan, AddressRange range, String entryKey) {
        return this.streamValuesIntersectingLifespan(lifespan, entryKey).filter(v -> DBTraceObjectValueWriteBehindCache.intersectsRange(v.getValue(), range));
    }

    static boolean atAddress(Object value, Address address) {
        AddressRange rv;
        Address av;
        return value instanceof Address && address.equals((Object)(av = (Address)value)) || value instanceof AddressRange && (rv = (AddressRange)value).contains(address);
    }

    public Stream<DBTraceObjectValueBehind> streamValuesAt(long snap, Address address, String entryKey) {
        return this.streamValuesIntersectingLifespan(Lifespan.at(snap), entryKey).filter(v -> DBTraceObjectValueWriteBehindCache.atAddress(v.getValue(), address));
    }

    static AddressRange getIfRangeOrAddress(Object v) {
        if (v instanceof AddressRange) {
            AddressRange rv = (AddressRange)v;
            return rv;
        }
        if (v instanceof Address) {
            Address av = (Address)v;
            return new AddressRangeImpl(av, av);
        }
        return null;
    }

    public <I extends TraceObjectInterface> AddressSetView getObjectsAddressSet(final long snap, final String key, final Class<I> ifaceCls, final Predicate<? super I> predicate) {
        return new AbstractAddressSetView(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            AddressSet collectRanges() {
                AddressSet result = new AddressSet();
                try (LockHold hold = LockHold.lock((Lock)DBTraceObjectValueWriteBehindCache.this.manager.lock.readLock());){
                    Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = DBTraceObjectValueWriteBehindCache.this.cachedValues;
                    synchronized (map) {
                        for (DBTraceObjectValueBehind v : StreamUtils.iter(DBTraceObjectValueWriteBehindCache.this.streamValuesIntersectingLifespan(Lifespan.at(snap), key))) {
                            AddressRange range = DBTraceObjectValueWriteBehindCache.getIfRangeOrAddress(v.getValue());
                            if (range == null || !DBTraceObjectManager.acceptValue(v.getWrapper(), key, ifaceCls, predicate)) continue;
                            result.add(range);
                        }
                    }
                }
                return result;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean contains(Address addr) {
                try (LockHold hold = LockHold.lock((Lock)DBTraceObjectValueWriteBehindCache.this.manager.lock.readLock());){
                    Map<DBTraceObject, Map<String, NavigableMap<Long, DBTraceObjectValueBehind>>> map = DBTraceObjectValueWriteBehindCache.this.cachedValues;
                    synchronized (map) {
                        for (DBTraceObjectValueBehind v : StreamUtils.iter(DBTraceObjectValueWriteBehindCache.this.streamValuesIntersectingLifespan(Lifespan.at(snap), key))) {
                            if (!addr.equals(v.getValue()) || !DBTraceObjectManager.acceptValue(v.getWrapper(), key, ifaceCls, predicate)) continue;
                            boolean bl = true;
                            return bl;
                        }
                    }
                }
                return false;
            }

            public AddressRangeIterator getAddressRanges() {
                return this.collectRanges().getAddressRanges();
            }

            public AddressRangeIterator getAddressRanges(boolean forward) {
                return this.collectRanges().getAddressRanges(forward);
            }

            public AddressRangeIterator getAddressRanges(Address start, boolean forward) {
                return this.collectRanges().getAddressRanges(start, forward);
            }
        };
    }

    public void flush() {
        this.flushing = true;
        this.worker.interrupt();
        try {
            this.busy.waitValue((Object)false).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void waitWorkers() {
        this.worker.interrupt();
        try {
            this.worker.join(10000L);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }
}

