/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.thread;

import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectInterface;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.annot.TraceObjectInterfaceUtils;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

public class DBTraceObjectThread
implements TraceObjectThread,
DBTraceObjectInterface {
    private final DBTraceObject object;
    private final ThreadChangeTranslator translator;

    public DBTraceObjectThread(DBTraceObject object) {
        this.object = object;
        this.translator = new ThreadChangeTranslator(this, object, this);
    }

    @Override
    public DBTraceObject getObject() {
        return this.object;
    }

    @Override
    public Trace getTrace() {
        return this.object.getTrace();
    }

    @Override
    public long getKey() {
        return this.object.getKey();
    }

    @Override
    public String getPath() {
        return this.object.getCanonicalPath().toString();
    }

    @Override
    public String getName() {
        return TraceObjectInterfaceUtils.getValue(this.object, this.getCreationSnap(), "_display", String.class, "");
    }

    @Override
    public void setName(Lifespan lifespan, String name) {
        this.object.setValue(lifespan, "_display", name);
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setName(this.computeSpan(), name);
        }
    }

    @Override
    public void setCreationSnap(long creationSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(creationSnap, this.getDestructionSnap()));
        }
    }

    @Override
    public long getCreationSnap() {
        return this.computeMinSnap();
    }

    @Override
    public void setDestructionSnap(long destructionSnap) throws DuplicateNameException {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.setLifespan(Lifespan.span(this.getCreationSnap(), destructionSnap));
        }
    }

    @Override
    public long getDestructionSnap() {
        return this.computeMaxSnap();
    }

    @Override
    public void setLifespan(Lifespan lifespan) throws DuplicateNameException {
        TraceObjectInterfaceUtils.setLifespan(TraceObjectThread.class, this.object, lifespan);
    }

    @Override
    public Lifespan getLifespan() {
        return this.computeSpan();
    }

    @Override
    public void setComment(String comment) {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.setValue(this.getLifespan(), "_comment", comment);
        }
    }

    @Override
    public String getComment() {
        return TraceObjectInterfaceUtils.getValue(this.object, this.getCreationSnap(), "_comment", String.class, "");
    }

    @Override
    public void delete() {
        try (LockHold hold = this.object.getTrace().lockWrite();){
            this.object.removeTree(this.computeSpan());
        }
    }

    @Override
    public boolean isValid(long snap) {
        return this.object.getCanonicalParent(snap) != null;
    }

    @Override
    public TraceChangeRecord<?, ?> translateEvent(TraceChangeRecord<?, ?> rec) {
        return this.translator.translate(rec);
    }

    protected class ThreadChangeTranslator
    extends DBTraceObjectInterface.Translator<TraceThread> {
        private static final Map<TargetObjectSchema, Set<String>> KEYS_BY_SCHEMA = new WeakHashMap<TargetObjectSchema, Set<String>>();
        private final Set<String> keys;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected ThreadChangeTranslator(DBTraceObjectThread this$0, DBTraceObject object, TraceThread iface) {
            super(null, object, iface);
            TargetObjectSchema schema = object.getTargetSchema();
            Map<TargetObjectSchema, Set<String>> map = KEYS_BY_SCHEMA;
            synchronized (map) {
                this.keys = KEYS_BY_SCHEMA.computeIfAbsent(schema, s -> Set.of(s.checkAliasedAttribute("_comment"), s.checkAliasedAttribute("_display")));
            }
        }

        @Override
        protected TraceEvent<TraceThread, Void> getAddedType() {
            return TraceEvents.THREAD_ADDED;
        }

        @Override
        protected TraceEvent<TraceThread, Lifespan> getLifespanChangedType() {
            return TraceEvents.THREAD_LIFESPAN_CHANGED;
        }

        @Override
        protected TraceEvent<TraceThread, Void> getChangedType() {
            return TraceEvents.THREAD_CHANGED;
        }

        @Override
        protected boolean appliesToKey(String key) {
            return this.keys.contains(key);
        }

        @Override
        protected TraceEvent<TraceThread, Void> getDeletedType() {
            return TraceEvents.THREAD_DELETED;
        }
    }
}

