/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.thread;

import db.DBRecord;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBObjectColumn;
import ghidra.util.database.annot.DBAnnotatedColumn;
import ghidra.util.database.annot.DBAnnotatedField;
import ghidra.util.database.annot.DBAnnotatedObjectInfo;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.concurrent.locks.Lock;

@DBAnnotatedObjectInfo(version=0)
public class DBTraceThread
extends DBAnnotatedObject
implements TraceThread {
    protected static final String TABLE_NAME = "Threads";
    static final String PATH_COLUMN_NAME = "Path";
    static final String NAME_COLUMN_NAME = "Name";
    static final String CREATION_SNAP_COLUMN_NAME = "CreatedAt";
    static final String DESTRUCTION_SNAP_COLUMN_NAME = "DestroyedAt";
    static final String COMMENT_COLUMN_NAME = "Comment";
    @DBAnnotatedColumn(value="Path")
    static DBObjectColumn PATH_COLUMN;
    @DBAnnotatedColumn(value="Name")
    static DBObjectColumn NAME_COLUMN;
    @DBAnnotatedColumn(value="CreatedAt")
    static DBObjectColumn CREATION_SNAP_COLUMN;
    @DBAnnotatedColumn(value="DestroyedAt")
    static DBObjectColumn DESTRUCTION_SNAP_COLUMN;
    @DBAnnotatedColumn(value="Comment")
    static DBObjectColumn COMMENT_COLUMN;
    @DBAnnotatedField(column="Path", indexed=true)
    private String path;
    @DBAnnotatedField(column="Name")
    private String name;
    @DBAnnotatedField(column="CreatedAt")
    private long creationSnap;
    @DBAnnotatedField(column="DestroyedAt")
    private long destructionSnap;
    @DBAnnotatedField(column="Comment")
    private String comment;
    public final DBTraceThreadManager manager;
    private Lifespan lifespan;

    protected DBTraceThread(DBTraceThreadManager manager, DBCachedObjectStore<?> store, DBRecord record) {
        super(store, record);
        this.manager = manager;
    }

    public void set(String path, String name, Lifespan lifespan) {
        this.path = path;
        this.name = name;
        this.creationSnap = lifespan.lmin();
        this.destructionSnap = lifespan.lmax();
        this.update(new DBObjectColumn[]{PATH_COLUMN, NAME_COLUMN, CREATION_SNAP_COLUMN, DESTRUCTION_SNAP_COLUMN});
        this.lifespan = lifespan;
    }

    protected void fresh(boolean created) throws IOException {
        if (created) {
            return;
        }
        this.lifespan = Lifespan.span(this.creationSnap, this.destructionSnap);
    }

    public String toString() {
        return "TraceThread: " + this.getName();
    }

    @Override
    public Trace getTrace() {
        return this.manager.trace;
    }

    @Override
    public String getPath() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            String string = this.path;
            return string;
        }
    }

    @Override
    public String getName() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            String string = this.name;
            return string;
        }
    }

    @Override
    public void setName(String name) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.name = name;
            this.update(NAME_COLUMN);
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceThread, Void>(TraceEvents.THREAD_CHANGED, null, this));
        }
    }

    @Override
    public void setCreationSnap(long creationSnap) throws DuplicateNameException {
        this.setLifespan(Lifespan.span(creationSnap, this.destructionSnap));
    }

    @Override
    public long getCreationSnap() {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            long l = this.creationSnap;
            return l;
        }
    }

    @Override
    public void setDestructionSnap(long destructionSnap) throws DuplicateNameException {
        this.setLifespan(Lifespan.span(this.creationSnap, destructionSnap));
    }

    @Override
    public long getDestructionSnap() {
        return this.destructionSnap;
    }

    @Override
    public void setLifespan(Lifespan newLifespan) throws DuplicateNameException {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.manager.checkConflictingPath(this, this.path, newLifespan);
            Lifespan oldLifespan = this.lifespan;
            this.creationSnap = newLifespan.lmin();
            this.destructionSnap = newLifespan.lmax();
            this.update(CREATION_SNAP_COLUMN, DESTRUCTION_SNAP_COLUMN);
            this.lifespan = newLifespan;
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceThread, Lifespan>(TraceEvents.THREAD_LIFESPAN_CHANGED, null, this, oldLifespan, newLifespan));
        }
    }

    @Override
    public Lifespan getLifespan() {
        return this.lifespan;
    }

    @Override
    public void setComment(String comment) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.writeLock());){
            this.comment = comment;
            this.update(COMMENT_COLUMN);
            this.manager.trace.setChanged(new TraceChangeRecord<DBTraceThread, Void>(TraceEvents.THREAD_CHANGED, null, this));
        }
    }

    @Override
    public String getComment() {
        return this.comment;
    }

    @Override
    public void delete() {
        this.manager.deleteThread(this);
    }

    @Override
    public boolean isValid(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.manager.lock.readLock());){
            boolean bl = this.lifespan.contains(snap);
            return bl;
        }
    }
}

