/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.thread;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.target.DBTraceObject;
import ghidra.trace.database.target.DBTraceObjectManager;
import ghidra.trace.database.thread.DBTraceThread;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.thread.TraceObjectThread;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Collectors;

public class DBTraceThreadManager
implements TraceThreadManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceObjectManager objectManager;
    protected final DBCachedObjectStore<DBTraceThread> threadStore;
    protected final DBCachedObjectIndex<String, DBTraceThread> threadsByPath;

    public DBTraceThreadManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceObjectManager objectManager) throws IOException, VersionException {
        this.lock = lock;
        this.trace = trace;
        this.objectManager = objectManager;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.threadStore = factory.getOrCreateCachedStore("Threads", DBTraceThread.class, (s, r) -> new DBTraceThread(this, s, r), true);
        this.threadsByPath = this.threadStore.getIndex(String.class, DBTraceThread.PATH_COLUMN);
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.threadStore.invalidateCache();
    }

    public TraceThread assertIsMine(TraceThread thread) {
        if (thread == null) {
            return null;
        }
        if (this.objectManager.hasSchema()) {
            return this.objectManager.assertMyThread(thread);
        }
        if (!(thread instanceof DBTraceThread)) {
            throw new IllegalArgumentException("Thread " + String.valueOf(thread) + " is not part of this trace");
        }
        DBTraceThread dbThread = (DBTraceThread)thread;
        if (dbThread.manager != this) {
            throw new IllegalArgumentException("Thread " + String.valueOf(thread) + " is not part of this trace");
        }
        if (!this.getAllThreads().contains(dbThread)) {
            throw new IllegalArgumentException("Thread " + String.valueOf(thread) + " is not part of this trace");
        }
        return dbThread;
    }

    protected void checkConflictingPath(DBTraceThread ignore, String path, Lifespan lifespan) throws DuplicateNameException {
        for (DBTraceThread pc : this.threadsByPath.get((Object)path)) {
            if (pc == ignore || !pc.getLifespan().intersects(lifespan)) continue;
            throw new DuplicateNameException("A thread having path '" + path + "' already exists within an overlapping snap");
        }
    }

    @Override
    public TraceThread addThread(String path, Lifespan lifespan) throws DuplicateNameException {
        return this.addThread(path, path, lifespan);
    }

    @Override
    public TraceThread addThread(String path, String display, Lifespan lifespan) throws DuplicateNameException {
        DBTraceThread thread;
        if (this.objectManager.hasSchema()) {
            return this.objectManager.addThread(path, display, lifespan);
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.checkConflictingPath(null, path, lifespan);
            thread = (DBTraceThread)this.threadStore.create();
            thread.set(path, display, lifespan);
        }
        this.trace.setChanged(new TraceChangeRecord<DBTraceThread, Void>(TraceEvents.THREAD_ADDED, null, thread));
        return thread;
    }

    @Override
    public Collection<? extends TraceThread> getAllThreads() {
        if (this.objectManager.hasSchema()) {
            return this.objectManager.getAllObjects(TraceObjectThread.class);
        }
        return Collections.unmodifiableCollection(this.threadStore.asMap().values());
    }

    @Override
    public Collection<? extends TraceThread> getThreadsByPath(String path) {
        if (this.objectManager.hasSchema()) {
            return this.objectManager.getObjectsByPath(path, TraceObjectThread.class);
        }
        return Collections.unmodifiableCollection(this.threadsByPath.get((Object)path));
    }

    @Override
    public TraceThread getLiveThreadByPath(long snap, String path) {
        if (this.objectManager.hasSchema()) {
            return this.objectManager.getObjectByPath(snap, path, TraceObjectThread.class);
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            TraceThread traceThread = this.threadsByPath.get((Object)path).stream().filter(t -> t.getLifespan().contains(snap)).findAny().orElse(null);
            return traceThread;
        }
    }

    @Override
    public TraceThread getThread(long key) {
        if (this.objectManager.hasSchema()) {
            DBTraceObject object = this.objectManager.getObjectById(key);
            return object == null ? null : (TraceThread)object.queryInterface(TraceObjectThread.class);
        }
        return (TraceThread)this.threadStore.getObjectAt(key);
    }

    @Override
    public Collection<? extends TraceThread> getLiveThreads(long snap) {
        if (this.objectManager.hasSchema()) {
            try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
                Collection collection = this.objectManager.queryAllInterface(Lifespan.at(snap), TraceObjectThread.class).filter(thread -> thread.getCreationSnap() <= snap && snap < thread.getDestructionSnap()).collect(Collectors.toSet());
                return collection;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            LinkedHashSet<DBTraceThread> result = new LinkedHashSet<DBTraceThread>();
            for (DBTraceThread thread2 : this.threadStore.asMap().values()) {
                if (thread2.getCreationSnap() > snap || snap >= thread2.getDestructionSnap()) continue;
                result.add(thread2);
            }
            LinkedHashSet<DBTraceThread> linkedHashSet = result;
            return linkedHashSet;
        }
    }

    public void deleteThread(DBTraceThread thread) {
        this.threadStore.delete((DBAnnotatedObject)thread);
        this.trace.setChanged(new TraceChangeRecord<DBTraceThread, Void>(TraceEvents.THREAD_DELETED, null, thread));
    }
}

