/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.time;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.DBTraceManager;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.database.time.DBTraceSnapshot;
import ghidra.trace.model.time.TraceSnapshot;
import ghidra.trace.model.time.TraceTimeManager;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceChangeRecord;
import ghidra.trace.util.TraceEvents;
import ghidra.util.LockHold;
import ghidra.util.database.DBAnnotatedObject;
import ghidra.util.database.DBCachedObjectIndex;
import ghidra.util.database.DBCachedObjectStore;
import ghidra.util.database.DBCachedObjectStoreFactory;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceTimeManager
implements TraceTimeManager,
DBTraceManager {
    protected final ReadWriteLock lock;
    protected final DBTrace trace;
    protected final DBTraceThreadManager threadManager;
    protected final DBCachedObjectStore<DBTraceSnapshot> snapshotStore;
    protected final DBCachedObjectIndex<String, DBTraceSnapshot> snapshotsBySchedule;

    public DBTraceTimeManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, DBTrace trace, DBTraceThreadManager threadManager) throws VersionException, IOException {
        this.trace = trace;
        this.lock = lock;
        this.threadManager = threadManager;
        DBCachedObjectStoreFactory factory = trace.getStoreFactory();
        this.snapshotStore = factory.getOrCreateCachedStore("Snapshots", DBTraceSnapshot.class, (s, r) -> new DBTraceSnapshot(this, s, r), true);
        this.snapshotsBySchedule = this.snapshotStore.getIndex(String.class, DBTraceSnapshot.SCHEDULE_COLUMN);
    }

    public void dbError(IOException e) {
        this.trace.dbError(e);
    }

    @Override
    public void invalidateCache(boolean all) {
        this.snapshotStore.invalidateCache();
    }

    protected void notifySnapshotAdded(DBTraceSnapshot snapshot) {
        this.trace.updateViewportsSnapshotAdded(snapshot);
        this.trace.setChanged(new TraceChangeRecord<DBTraceSnapshot, Void>(TraceEvents.SNAPSHOT_ADDED, null, snapshot));
    }

    protected void notifySnapshotChanged(DBTraceSnapshot snapshot) {
        this.trace.updateViewportsSnapshotChanged(snapshot);
        this.trace.setChanged(new TraceChangeRecord<DBTraceSnapshot, Void>(TraceEvents.SNAPSHOT_CHANGED, null, snapshot));
    }

    protected void notifySnapshotDeleted(DBTraceSnapshot snapshot) {
        this.trace.updateViewportsSnapshotDeleted(snapshot);
        this.trace.setChanged(new TraceChangeRecord<DBTraceSnapshot, Void>(TraceEvents.SNAPSHOT_DELETED, null, snapshot));
    }

    @Override
    public DBTraceSnapshot createSnapshot(String description) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceSnapshot snapshot = (DBTraceSnapshot)this.snapshotStore.create();
            snapshot.set(System.currentTimeMillis(), description);
            if (snapshot.getKey() == 0L) {
                snapshot.setSchedule(TraceSchedule.snap(0L));
            }
            this.notifySnapshotAdded(snapshot);
            DBTraceSnapshot dBTraceSnapshot = snapshot;
            return dBTraceSnapshot;
        }
    }

    @Override
    public DBTraceSnapshot getSnapshot(long snap, boolean createIfAbsent) {
        if (!createIfAbsent) {
            try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
                DBTraceSnapshot dBTraceSnapshot = (DBTraceSnapshot)this.snapshotStore.getObjectAt(snap);
                return dBTraceSnapshot;
            }
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            DBTraceSnapshot snapshot = (DBTraceSnapshot)this.snapshotStore.getObjectAt(snap);
            if (snapshot == null) {
                snapshot = (DBTraceSnapshot)this.snapshotStore.create(snap);
                snapshot.set(System.currentTimeMillis(), "");
                if (snapshot.getKey() == 0L) {
                    snapshot.setSchedule(TraceSchedule.snap(0L));
                }
                this.notifySnapshotAdded(snapshot);
            }
            DBTraceSnapshot dBTraceSnapshot = snapshot;
            return dBTraceSnapshot;
        }
    }

    @Override
    public DBTraceSnapshot getMostRecentSnapshot(long snap) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            Map.Entry ent = this.snapshotStore.asMap().floorEntry(Long.valueOf(snap));
            DBTraceSnapshot dBTraceSnapshot = ent == null ? null : (DBTraceSnapshot)ent.getValue();
            return dBTraceSnapshot;
        }
    }

    @Override
    public Collection<? extends TraceSnapshot> getSnapshotsWithSchedule(TraceSchedule schedule) {
        return this.snapshotsBySchedule.get((Object)schedule.toString());
    }

    public Collection<? extends DBTraceSnapshot> getAllSnapshots() {
        return Collections.unmodifiableCollection(this.snapshotStore.asMap().values());
    }

    public Collection<? extends DBTraceSnapshot> getSnapshots(long fromSnap, boolean fromInclusive, long toSnap, boolean toInclusive) {
        return Collections.unmodifiableCollection(this.snapshotStore.asMap().subMap(Long.valueOf(fromSnap), fromInclusive, Long.valueOf(toSnap), toInclusive).values());
    }

    @Override
    public Long getMaxSnap() {
        return this.snapshotStore.getMaxKey();
    }

    @Override
    public long getSnapshotCount() {
        return this.snapshotStore.getRecordCount();
    }

    public void deleteSnapshot(DBTraceSnapshot snapshot) {
        try (LockHold hold = LockHold.lock((Lock)this.lock.writeLock());){
            this.snapshotStore.delete((DBAnnotatedObject)snapshot);
            this.notifySnapshotDeleted(snapshot);
        }
    }
}

