/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.memory;

import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.address.AddressRange;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.memory.TraceMemoryFlag;
import ghidra.trace.model.memory.TraceOverlappedRegionException;
import ghidra.util.exception.DuplicateNameException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Set;

public interface TraceMemoryRegion
extends TraceUniqueObject {
    public Trace getTrace();

    public String getPath();

    public void setName(String var1);

    public String getName();

    public void setLifespan(Lifespan var1) throws TraceOverlappedRegionException, DuplicateNameException;

    public Lifespan getLifespan();

    public void setCreationSnap(long var1) throws DuplicateNameException, TraceOverlappedRegionException;

    public long getCreationSnap();

    public void setDestructionSnap(long var1) throws DuplicateNameException, TraceOverlappedRegionException;

    public long getDestructionSnap();

    public void setRange(AddressRange var1) throws TraceOverlappedRegionException;

    public AddressRange getRange();

    public void setMinAddress(Address var1) throws TraceOverlappedRegionException;

    public Address getMinAddress();

    public void setMaxAddress(Address var1) throws TraceOverlappedRegionException;

    public Address getMaxAddress();

    public void setLength(long var1) throws AddressOverflowException, TraceOverlappedRegionException;

    public long getLength();

    public void setFlags(Collection<TraceMemoryFlag> var1);

    default public void setFlags(TraceMemoryFlag ... flags) {
        this.setFlags(Arrays.asList(flags));
    }

    public void addFlags(Collection<TraceMemoryFlag> var1);

    default public void addFlags(TraceMemoryFlag ... flags) {
        this.addFlags(Arrays.asList(flags));
    }

    public void clearFlags(Collection<TraceMemoryFlag> var1);

    default public void clearFlags(TraceMemoryFlag ... flags) {
        this.clearFlags(Arrays.asList(flags));
    }

    public Set<TraceMemoryFlag> getFlags();

    default public void setRead(boolean read) {
        if (read) {
            this.addFlags(TraceMemoryFlag.READ);
        } else {
            this.clearFlags(TraceMemoryFlag.READ);
        }
    }

    default public boolean isRead() {
        return this.getFlags().contains((Object)TraceMemoryFlag.READ);
    }

    default public void setWrite(boolean write) {
        if (write) {
            this.addFlags(TraceMemoryFlag.WRITE);
        } else {
            this.clearFlags(TraceMemoryFlag.WRITE);
        }
    }

    default public boolean isWrite() {
        return this.getFlags().contains((Object)TraceMemoryFlag.WRITE);
    }

    default public void setExecute(boolean execute) {
        if (execute) {
            this.addFlags(TraceMemoryFlag.EXECUTE);
        } else {
            this.clearFlags(TraceMemoryFlag.EXECUTE);
        }
    }

    default public boolean isExecute() {
        return this.getFlags().contains((Object)TraceMemoryFlag.EXECUTE);
    }

    default public void setVolatile(boolean vol) {
        if (vol) {
            this.addFlags(TraceMemoryFlag.VOLATILE);
        } else {
            this.clearFlags(TraceMemoryFlag.VOLATILE);
        }
    }

    default public boolean isVolatile() {
        return this.getFlags().contains((Object)TraceMemoryFlag.VOLATILE);
    }

    public void delete();

    public boolean isValid(long var1);
}

