/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target;

import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;

public final class TraceObjectKeyPath
implements Comparable<TraceObjectKeyPath> {
    private final List<String> keyList;
    private final int hash;

    public static TraceObjectKeyPath of(List<String> keyList) {
        return new TraceObjectKeyPath(List.copyOf(keyList));
    }

    public static TraceObjectKeyPath of(String ... keys) {
        return new TraceObjectKeyPath(List.of(keys));
    }

    public static TraceObjectKeyPath parse(String path) {
        return new TraceObjectKeyPath(PathUtils.parse((String)path));
    }

    private TraceObjectKeyPath(List<String> keyList) {
        this.keyList = keyList;
        this.hash = Objects.hash(keyList);
    }

    public int hashCode() {
        return this.hash;
    }

    @Override
    public int compareTo(TraceObjectKeyPath that) {
        if (this == that) {
            return 0;
        }
        return PathUtils.PathComparator.KEYED.compare(this.keyList, that.keyList);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof TraceObjectKeyPath)) {
            return false;
        }
        TraceObjectKeyPath that = (TraceObjectKeyPath)obj;
        return this.keyList.equals(that.keyList);
    }

    public List<String> getKeyList() {
        return this.keyList;
    }

    public boolean isRoot() {
        return this.keyList.isEmpty();
    }

    public TraceObjectKeyPath key(String name) {
        return new TraceObjectKeyPath(PathUtils.extend(this.keyList, (String)name));
    }

    public String key() {
        return PathUtils.getKey(this.keyList);
    }

    public TraceObjectKeyPath index(long index) {
        return this.index(PathUtils.makeIndex((long)index));
    }

    public TraceObjectKeyPath index(String index) {
        return new TraceObjectKeyPath(PathUtils.index(this.keyList, (String)index));
    }

    public String index() {
        return PathUtils.getIndex(this.keyList);
    }

    public String toString() {
        return PathUtils.toString(this.keyList);
    }

    public TraceObjectKeyPath parent() {
        List pkl = PathUtils.parent(this.keyList);
        return pkl == null ? null : new TraceObjectKeyPath(pkl);
    }

    public TraceObjectKeyPath extend(List<String> subKeyList) {
        return new TraceObjectKeyPath(PathUtils.extend(this.keyList, subKeyList));
    }

    public TraceObjectKeyPath extend(String ... subKeyList) {
        return this.extend(Arrays.asList(subKeyList));
    }

    public Stream<TraceObjectKeyPath> streamMatchingAncestry(PathPredicates predicates) {
        Stream<TraceObjectKeyPath> ancestry;
        if (!predicates.ancestorMatches(this.keyList, false)) {
            return Stream.of(new TraceObjectKeyPath[0]);
        }
        Stream<TraceObjectKeyPath> stream = ancestry = this.isRoot() ? Stream.of(new TraceObjectKeyPath[0]) : this.parent().streamMatchingAncestry(predicates);
        if (predicates.matches(this.keyList)) {
            return Stream.concat(Stream.of(this), ancestry);
        }
        return ancestry;
    }

    public boolean isAncestor(TraceObjectKeyPath that) {
        return PathUtils.isAncestor(this.keyList, that.keyList);
    }

    public TraceObjectKeyPath relativize(TraceObjectKeyPath successor) {
        return TraceObjectKeyPath.of(PathUtils.relativize(this.keyList, successor.keyList));
    }
}

