/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.target;

import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;

public interface TraceObjectValue {
    public Trace getTrace();

    public TraceObject getParent();

    public String getEntryKey();

    default public boolean hasEntryKey(String keyOrAlias) {
        TraceObject parent = this.getParent();
        if (parent == null) {
            return this.getEntryKey().equals(keyOrAlias);
        }
        return this.getEntryKey().equals(parent.getTargetSchema().checkAliasedAttribute(keyOrAlias));
    }

    public TraceObjectKeyPath getCanonicalPath();

    public Object getValue();

    default public <T> T castValue() {
        return (T)this.getValue();
    }

    public TraceObject getChild();

    public boolean isObject();

    public boolean isCanonical();

    default public TargetObjectSchema getTargetSchema() {
        return this.getParent().getTargetSchema().getChildSchema(this.getEntryKey());
    }

    public void setLifespan(Lifespan var1);

    public void setLifespan(Lifespan var1, TraceObject.ConflictResolution var2);

    public Lifespan getLifespan();

    public void setMinSnap(long var1);

    public long getMinSnap();

    public void setMaxSnap(long var1);

    public long getMaxSnap();

    public void delete();

    public boolean isDeleted();

    public TraceObjectValue truncateOrDelete(Lifespan var1);

    default public boolean isHidden() {
        TraceObject parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getTargetSchema().isHidden(this.getEntryKey());
    }
}

