/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.model.time.schedule;

import ghidra.pcode.emu.PcodeMachine;
import ghidra.pcode.emu.PcodeThread;
import ghidra.program.model.lang.Language;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.thread.TraceThreadManager;
import ghidra.trace.model.time.schedule.CompareResult;
import ghidra.trace.model.time.schedule.PatchStep;
import ghidra.trace.model.time.schedule.SkipStep;
import ghidra.trace.model.time.schedule.Stepper;
import ghidra.trace.model.time.schedule.TickStep;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.List;

public interface Step
extends Comparable<Step> {
    public static Step parse(String stepSpec) {
        String tPart;
        if ("".equals(stepSpec)) {
            return Step.nop();
        }
        String[] parts = stepSpec.split("-");
        if (parts.length == 1) {
            return Step.parse(-1L, parts[0].trim());
        }
        if (parts.length == 2 && (tPart = parts[0].trim()).startsWith("t")) {
            return Step.parse(Long.parseLong(tPart.substring(1)), parts[1].trim());
        }
        throw new IllegalArgumentException("Cannot parse step: '" + stepSpec + "'");
    }

    public static Step parse(long threadKey, String stepSpec) {
        if (stepSpec.startsWith("s")) {
            return SkipStep.parse(threadKey, stepSpec);
        }
        if (stepSpec.startsWith("{")) {
            return PatchStep.parse(threadKey, stepSpec);
        }
        return TickStep.parse(threadKey, stepSpec);
    }

    public static TickStep nop() {
        return new TickStep(-1L, 0L);
    }

    public StepType getType();

    default public int getTypeOrder() {
        return this.getType().ordinal();
    }

    public boolean isNop();

    public long getThreadKey();

    default public boolean isEventThread() {
        return this.getThreadKey() == -1L;
    }

    default public TraceThread getThread(TraceThreadManager tm, TraceThread eventThread) {
        TraceThread thread;
        TraceThread traceThread = thread = this.isEventThread() ? eventThread : tm.getThread(this.getThreadKey());
        if (thread == null) {
            if (this.isEventThread()) {
                throw new IllegalArgumentException("Thread must be given, e.g., 0:t1-3, since the last thread or snapshot event thread is not given.");
            }
            throw new IllegalArgumentException("Thread with key " + this.getThreadKey() + " does not exist in given trace");
        }
        return thread;
    }

    public long getTickCount();

    public long getSkipCount();

    public long getPatchCount();

    public boolean isCompatible(Step var1);

    public void addTo(Step var1);

    public Step subtract(Step var1);

    public Step clone();

    public long rewind(long var1);

    public CompareResult compareStep(Step var1);

    default public CompareResult compareStepType(Step that) {
        return CompareResult.unrelated(Integer.compare(this.getTypeOrder(), that.getTypeOrder()));
    }

    @Override
    default public int compareTo(Step that) {
        return this.compareStep((Step)that).compareTo;
    }

    default public TraceThread execute(TraceThreadManager tm, TraceThread eventThread, PcodeMachine<?> machine, Stepper stepper, TaskMonitor monitor) throws CancelledException {
        TraceThread thread = this.getThread(tm, eventThread);
        if (machine == null) {
            return thread;
        }
        PcodeThread emuThread = machine.getThread(thread.getPath(), true);
        this.execute(emuThread, stepper, monitor);
        return thread;
    }

    public void execute(PcodeThread<?> var1, Stepper var2, TaskMonitor var3) throws CancelledException;

    public long coalescePatches(Language var1, List<Step> var2);

    public static enum StepType {
        TICK,
        SKIP,
        PATCH;

    }
}

