/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.event;

import ghidra.framework.plugintool.PluginEvent;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.program.TraceProgramView;
import java.util.Objects;

public class TraceLocationPluginEvent
extends PluginEvent {
    public static final String NAME = "TraceLocation";
    private final ProgramLocation loc;
    private final TraceProgramView view;

    public TraceLocationPluginEvent(String src, ProgramLocation loc) {
        super(src, NAME);
        this.loc = Objects.requireNonNull(loc);
        this.view = (TraceProgramView)loc.getProgram();
    }

    public ProgramLocation getLocation() {
        return this.loc;
    }

    public TraceProgramView getTraceProgramView() {
        return this.view;
    }

    protected String getDetails() {
        return String.valueOf(this.loc.getClass()) + " addr==> " + String.valueOf(this.loc.getAddress());
    }
}

