/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.control.TargetActionTask;
import ghidra.debug.api.action.InstanceUtils;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.options.SaveState;
import ghidra.framework.plugintool.AutoConfigState;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressSetView;
import ghidra.util.classfinder.ClassSearcher;
import ghidra.util.classfinder.ExtensionPoint;
import ghidra.util.task.TaskMonitor;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public interface AutoReadMemorySpec
extends ExtensionPoint {
    public static final Private PRIVATE = new Private();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static AutoReadMemorySpec fromConfigName(String name) {
        Private private_ = PRIVATE;
        synchronized (private_) {
            return AutoReadMemorySpec.PRIVATE.specsByName.get(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, AutoReadMemorySpec> allSpecs() {
        Private private_ = PRIVATE;
        synchronized (private_) {
            return new TreeMap<String, AutoReadMemorySpec>(AutoReadMemorySpec.PRIVATE.specsByName);
        }
    }

    public String getConfigName();

    public String getMenuName();

    public Icon getMenuIcon();

    public CompletableFuture<Boolean> readMemory(PluginTool var1, DebuggerCoordinates var2, AddressSetView var3);

    default public CompletableFuture<Boolean> doRead(PluginTool tool, Function<TaskMonitor, CompletableFuture<Void>> reader) {
        return TargetActionTask.executeTask(tool, this.getMenuName(), true, true, false, m -> (CompletableFuture)reader.apply((TaskMonitor)m)).thenApply(__ -> true);
    }

    public static class Private {
        private final Map<String, AutoReadMemorySpec> specsByName = new TreeMap<String, AutoReadMemorySpec>();
        private final ChangeListener classListener = this::classesChanged;

        private Private() {
            ClassSearcher.addChangeListener((ChangeListener)this.classListener);
            this.classesChanged(null);
        }

        private synchronized void classesChanged(ChangeEvent evt) {
            InstanceUtils.collectUniqueInstances(AutoReadMemorySpec.class, this.specsByName, AutoReadMemorySpec::getConfigName);
        }
    }

    public static class AutoReadMemorySpecConfigFieldCodec
    implements AutoConfigState.ConfigFieldCodec<AutoReadMemorySpec> {
        public AutoReadMemorySpec read(SaveState state, String name, AutoReadMemorySpec current) {
            String specName = state.getString(name, null);
            return AutoReadMemorySpec.fromConfigName(specName);
        }

        public void write(SaveState state, String name, AutoReadMemorySpec value) {
            state.putString(name, value.getConfigName());
        }
    }
}

