/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.services.DebuggerStaticMappingService;
import ghidra.app.services.ProgramManager;
import ghidra.debug.api.action.AutoMapSpec;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceConflictedMappingException;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.util.TraceEvent;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;

public class OneToOneAutoMapSpec
implements AutoMapSpec {
    public static final String CONFIG_NAME = "2_MAP_ONE_TO_ONE";

    public String getConfigName() {
        return CONFIG_NAME;
    }

    public String getMenuName() {
        return "Auto-Map Identically (1-to-1)";
    }

    public Icon getMenuIcon() {
        return DebuggerResources.ICON_CONFIG;
    }

    public Collection<TraceEvent<?, ?>> getChangeTypes() {
        return List.of();
    }

    public boolean objectHasType(TraceObjectValue value) {
        return false;
    }

    public String getInfoForObjects(Trace trace) {
        return "";
    }

    public List<Program> programs(ProgramManager programManager) {
        Program program = programManager.getCurrentProgram();
        if (program == null) {
            return List.of();
        }
        return List.of(program);
    }

    public boolean performMapping(DebuggerStaticMappingService mappingService, Trace trace, List<Program> programs, TaskMonitor monitor) throws CancelledException {
        boolean result = false;
        for (Program program : programs) {
            try {
                mappingService.addIdentityMapping(trace, program, Lifespan.nowOn((long)trace.getProgramView().getSnap()), false);
                result = true;
            }
            catch (TraceConflictedMappingException traceConflictedMappingException) {}
        }
        return result;
    }
}

