/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.action;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.action.AutoReadMemorySpec;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.TraceAddressSnapRange;
import ghidra.trace.model.memory.TraceMemoryManager;
import ghidra.trace.model.memory.TraceMemoryRegion;
import ghidra.trace.model.memory.TraceMemoryState;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.swing.Icon;

public class VisibleROOnceAutoReadMemorySpec
implements AutoReadMemorySpec {
    public static final String CONFIG_NAME = "1_READ_VIS_RO_ONCE";

    public boolean equals(Object obj) {
        return this.getClass() == obj.getClass();
    }

    @Override
    public String getConfigName() {
        return CONFIG_NAME;
    }

    @Override
    public String getMenuName() {
        return "Read Visible Memory, RO Once";
    }

    @Override
    public Icon getMenuIcon() {
        return DebuggerResources.AutoReadMemoryAction.ICON_VIS_RO_ONCE;
    }

    @Override
    public CompletableFuture<Boolean> readMemory(PluginTool tool, DebuggerCoordinates coordinates, AddressSetView visible) {
        if (!coordinates.isAliveAndReadsPresent()) {
            return CompletableFuture.completedFuture(false);
        }
        Target target = coordinates.getTarget();
        TraceMemoryManager mm = coordinates.getTrace().getMemoryManager();
        AddressSetView alreadyKnown = mm.getAddressesWithState(coordinates.getSnap(), visible, s -> s == TraceMemoryState.KNOWN || s == TraceMemoryState.ERROR);
        AddressSet toRead = visible.subtract(alreadyKnown);
        if (toRead.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        AddressSet everKnown = new AddressSet();
        for (AddressRange range : visible) {
            for (Map.Entry ent : mm.getMostRecentStates(coordinates.getSnap(), range)) {
                everKnown.add(((TraceAddressSnapRange)ent.getKey()).getRange());
            }
        }
        AddressSet readOnly = new AddressSet();
        for (AddressRange range : visible) {
            for (TraceMemoryRegion region : mm.getRegionsIntersecting(Lifespan.at((long)coordinates.getSnap()), range)) {
                if (region.isWrite()) continue;
                readOnly.add(region.getRange());
            }
        }
        toRead.delete((AddressSetView)everKnown.intersect((AddressSetView)readOnly));
        if (toRead.isEmpty()) {
            return CompletableFuture.completedFuture(false);
        }
        return this.doRead(tool, monitor -> target.readMemoryAsync((AddressSetView)toRead, monitor));
    }
}

