/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.breakpoint;

import docking.DialogComponentProvider;
import ghidra.app.services.DebuggerLogicalBreakpointService;
import ghidra.async.AsyncUtils;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.util.MessageType;
import ghidra.util.Swing;
import ghidra.util.layout.PairLayout;
import java.awt.LayoutManager;
import java.util.Collection;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class DebuggerPlaceBreakpointDialog
extends DialogComponentProvider {
    private DebuggerLogicalBreakpointService service;
    private Program program;
    private Address address;
    private long length;
    private Set<TraceBreakpointKind> kinds;
    private String name;
    private JTextField fieldAddress;
    private JTextField fieldLength;
    private JComboBox<String> fieldKinds;
    private JTextField fieldName;
    private PluginTool tool;
    private String statusText = null;

    public DebuggerPlaceBreakpointDialog() {
        super("Set Breakpoint", true, true, true, false);
        this.populateComponents();
    }

    protected boolean validateAddress() {
        this.address = this.program.getAddressFactory().getAddress(this.fieldAddress.getText());
        if (this.address == null) {
            this.setStatusText("Invalid address: " + this.fieldAddress.getText());
            return false;
        }
        Instruction instruction = this.program.getListing().getInstructionContaining(this.address);
        if (instruction != null && !this.address.equals((Object)instruction.getAddress())) {
            this.setStatusText("Warning: breakpoint is offset within an instruction.");
        } else {
            this.clearStatusText();
        }
        return true;
    }

    protected void populateComponents() {
        JPanel panel = new JPanel((LayoutManager)new PairLayout(5, 5));
        panel.setBorder(new EmptyBorder(10, 10, 10, 10));
        JLabel labelAddress = new JLabel("Address");
        this.fieldAddress = new JTextField();
        panel.add(labelAddress);
        panel.add(this.fieldAddress);
        this.fieldAddress.setInputVerifier(new InputVerifier(){

            @Override
            public boolean verify(JComponent input) {
                return DebuggerPlaceBreakpointDialog.this.validateAddress();
            }
        });
        this.fieldAddress.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                DebuggerPlaceBreakpointDialog.this.validateAddress();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                DebuggerPlaceBreakpointDialog.this.validateAddress();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                DebuggerPlaceBreakpointDialog.this.validateAddress();
            }
        });
        JLabel labelLength = new JLabel("Length");
        this.fieldLength = new JTextField();
        panel.add(labelLength);
        panel.add(this.fieldLength);
        JLabel labelKinds = new JLabel("Kinds");
        DefaultComboBoxModel<String> kindModel = new DefaultComboBoxModel<String>();
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.SW_EXECUTE)));
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.HW_EXECUTE)));
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.READ)));
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.WRITE)));
        kindModel.addElement(TraceBreakpointKind.TraceBreakpointKindSet.encode(Set.of(TraceBreakpointKind.READ, TraceBreakpointKind.WRITE)));
        this.fieldKinds = new JComboBox(kindModel);
        this.fieldKinds.setEditable(true);
        panel.add(labelKinds);
        panel.add(this.fieldKinds);
        JLabel labelName = new JLabel("Name");
        this.fieldName = new JTextField();
        panel.add(labelName);
        panel.add(this.fieldName);
        this.addWorkPanel(panel);
        this.addOKButton();
        this.addCancelButton();
    }

    public void prompt(PluginTool tool, DebuggerLogicalBreakpointService service, String title, ProgramLocation loc, long length, Collection<TraceBreakpointKind> kinds, String name) {
        this.service = service;
        this.program = loc.getProgram();
        this.address = DebuggerLogicalBreakpointService.addressFromLocation((ProgramLocation)loc);
        this.length = length;
        this.kinds = Set.copyOf(kinds);
        this.name = name;
        this.fieldAddress.setText(this.address.toString());
        this.fieldLength.setText(Long.toUnsignedString(length));
        this.fieldKinds.setSelectedItem(TraceBreakpointKind.TraceBreakpointKindSet.encode(kinds));
        this.fieldName.setText("");
        this.tool = tool;
        this.validateAddress();
        this.setTitle(title);
        this.statusText = null;
        tool.showDialog((DialogComponentProvider)this);
    }

    protected void okCallback() {
        if (!this.validateAddress()) {
            return;
        }
        try {
            this.length = Long.parseUnsignedLong(this.fieldLength.getText());
        }
        catch (NumberFormatException e) {
            this.setStatusText("Invalid length: " + String.valueOf(e));
            return;
        }
        try {
            this.kinds = TraceBreakpointKind.TraceBreakpointKindSet.decode((String)((String)this.fieldKinds.getSelectedItem()), (boolean)true);
        }
        catch (IllegalArgumentException e) {
            this.setStatusText("Invalid kinds: " + String.valueOf(e));
            return;
        }
        this.name = this.fieldName.getText();
        ProgramLocation loc = new ProgramLocation(this.program, this.address);
        this.service.placeBreakpointAt(loc, this.length, this.kinds, this.name).exceptionally(ex -> {
            ex = AsyncUtils.unwrapThrowable((Throwable)ex);
            this.statusText = ex.getMessage();
            this.tool.showDialog((DialogComponentProvider)this);
            return null;
        });
        this.close();
    }

    protected void dialogShown() {
        if (this.statusText != null) {
            this.setStatusText(this.statusText, MessageType.ERROR, true);
        }
    }

    void setName(String name) {
        this.name = name;
        Swing.runNow(() -> this.fieldName.setText(name));
    }
}

