/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.console;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.Tool;
import docking.WindowPosition;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.ToolBarData;
import docking.action.builder.ActionBuilder;
import docking.actions.PopupActionProvider;
import docking.widgets.table.ColumnSortState;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.RowObjectTableModel;
import generic.theme.GIcon;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.console.ConsoleActionsCellEditor;
import ghidra.app.plugin.core.debug.gui.console.ConsoleActionsCellRenderer;
import ghidra.app.plugin.core.debug.gui.console.DebuggerConsolePlugin;
import ghidra.app.plugin.core.debug.gui.console.HtmlOrProgressCellRenderer;
import ghidra.app.plugin.core.debug.gui.console.LogRowConsoleActionContext;
import ghidra.app.plugin.core.debug.gui.console.MonitorRowConsoleActionContext;
import ghidra.app.plugin.core.debug.utils.DebouncedRowWrappedEnumeratedColumnTableModel;
import ghidra.app.services.ProgressService;
import ghidra.debug.api.progress.MonitorReceiver;
import ghidra.debug.api.progress.ProgressListener;
import ghidra.framework.options.AutoOptions;
import ghidra.framework.options.annotation.AutoOptionConsumed;
import ghidra.framework.options.annotation.AutoOptionDefined;
import ghidra.framework.options.annotation.HelpInfo;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.util.HTMLUtilities;
import ghidra.util.HelpLocation;
import ghidra.util.Msg;
import ghidra.util.Swing;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import ghidra.util.table.column.GColumnRenderer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Date;
import java.util.Deque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ChangeEvent;
import javax.swing.event.TableModelEvent;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LogEvent;
import resources.Icons;

public class DebuggerConsoleProvider
extends ComponentProviderAdapter
implements PopupActionProvider {
    static final int ACTION_BUTTON_SIZE = 32;
    static final Dimension ACTION_BUTTON_DIM = new Dimension(32, 32);
    static final int MIN_ROW_HEIGHT = 16;
    private final DebuggerConsolePlugin plugin;
    private ProgressService progressService;
    private final AutoService.Wiring autoServiceWiring;
    @AutoOptionDefined(name={"Log Buffer Size"}, description="The maximum number of entries in the console log (0 or less for unlimited)", help=@HelpInfo(anchor="buffer_limit"))
    private int logBufferLimit = 20;
    private final AutoOptions.Wiring autoOptionsWiring;
    protected final Map<String, Map<String, DockingActionIf>> actionsByOwnerThenName = new LinkedHashMap<String, Map<String, DockingActionIf>>();
    protected final LogTableModel logTableModel;
    protected GhidraTable logTable;
    private GhidraTableFilterPanel<LogRow<?>> logFilterPanel;
    private Deque<LogRow<?>> buffer = new ArrayDeque();
    private final JPanel mainPanel = new JPanel(new BorderLayout());
    private final ListenerForProgress progressListener;
    DockingAction actionClear;
    DockingAction actionSelectNone;

    public DebuggerConsoleProvider(DebuggerConsolePlugin plugin) {
        super(plugin.getTool(), "Debug Console", plugin.getName());
        this.plugin = plugin;
        this.progressListener = new ListenerForProgress();
        this.logTableModel = new LogTableModel(this.tool);
        this.tool.addPopupActionProvider((PopupActionProvider)this);
        this.setIcon(DebuggerResources.ICON_PROVIDER_CONSOLE);
        this.setHelpLocation(DebuggerResources.HELP_PROVIDER_CONSOLE);
        this.setWindowMenuGroup("Debugger");
        this.buildMainPanel();
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)((Object)this));
        this.autoOptionsWiring = AutoOptions.wireOptions((Plugin)plugin, (Object)((Object)this));
        this.setDefaultWindowPosition(WindowPosition.BOTTOM);
        this.setVisible(true);
        this.createActions();
    }

    protected void dispose() {
        this.tool.removePopupActionProvider((PopupActionProvider)this);
    }

    protected void buildMainPanel() {
        this.logTable = new LogTable(this.logTableModel);
        this.logTable.setSelectionMode(2);
        this.mainPanel.add(new JScrollPane((Component)this.logTable));
        this.logFilterPanel = new GhidraTableFilterPanel((JTable)this.logTable, (RowObjectTableModel)this.logTableModel);
        this.mainPanel.add((Component)this.logFilterPanel, "North");
        String namePrefix = "Debug Console";
        this.logTable.setAccessibleNamePrefix(namePrefix);
        this.logFilterPanel.setAccessibleNamePrefix(namePrefix);
        this.logTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (e.getButton() == 1 & e.getClickCount() == 2 && DebuggerConsoleProvider.this.activateSelectedRow()) {
                    e.consume();
                }
            }
        });
        this.logTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && DebuggerConsoleProvider.this.activateSelectedRow()) {
                    e.consume();
                }
            }
        });
        this.logTable.setRowHeight(34);
        TableColumnModel columnModel = this.logTable.getColumnModel();
        TableColumn iconCol = columnModel.getColumn(LogTableColumns.ICON.ordinal());
        iconCol.setMaxWidth(24);
        iconCol.setMinWidth(24);
        TableColumn msgCol = columnModel.getColumn(LogTableColumns.MESSAGE.ordinal());
        msgCol.setPreferredWidth(150);
        TableColumn actCol = columnModel.getColumn(LogTableColumns.ACTIONS.ordinal());
        actCol.setPreferredWidth(50);
        actCol.setCellEditor(new ConsoleActionsCellEditor());
        TableColumn timeCol = columnModel.getColumn(LogTableColumns.TIME.ordinal());
        timeCol.setPreferredWidth(15);
    }

    protected boolean activateSelectedRow() {
        LogRow row = (LogRow)this.logFilterPanel.getSelectedItem();
        if (row == null) {
            return false;
        }
        return row.activated();
    }

    protected void createActions() {
        this.actionClear = (DockingAction)((ActionBuilder)DebuggerResources.ClearAction.builder(this.plugin).onAction(this::activatedClear)).buildAndInstallLocal((ComponentProvider)this);
        this.actionSelectNone = (DockingAction)((ActionBuilder)((ActionBuilder)DebuggerResources.SelectNoneAction.builder(this.plugin).popupWhen(ctx -> ctx.getSourceComponent() == this.logTable)).onAction(this::activatedSelectNone)).buildAndInstallLocal((ComponentProvider)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activatedClear(ActionContext ctx) {
        Deque<LogRow<?>> deque = this.buffer;
        synchronized (deque) {
            this.logTableModel.deleteItemsWith(r -> !(r instanceof MonitorLogRow));
            this.buffer.removeIf(r -> !(r instanceof MonitorLogRow));
        }
    }

    private void activatedSelectNone(ActionContext ctx) {
        this.logTable.clearSelection();
    }

    public ActionContext getActionContext(MouseEvent event) {
        if (this.logTable.getSelectedRowCount() != 1) {
            return super.getActionContext(event);
        }
        LogRow sel = (LogRow)this.logFilterPanel.getSelectedItem();
        if (sel == null) {
            return super.getActionContext(event);
        }
        return sel.actionContext();
    }

    @AutoOptionConsumed(name={"Log Buffer Size"})
    private void setLogBufferLimit(int logBufferLimit) {
        this.truncateLog();
    }

    public JComponent getComponent() {
        return this.mainPanel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void truncateLog() {
        Deque<LogRow<?>> deque = this.buffer;
        synchronized (deque) {
            while (this.logBufferLimit > 0 && this.buffer.size() > this.logBufferLimit) {
                this.logTableModel.deleteItem(this.buffer.removeFirst());
            }
        }
    }

    protected void log(Icon icon, String message) {
        this.log(icon, message, null, (ActionContext)new LogRowConsoleActionContext());
    }

    protected void log(Icon icon, String message, ActionContext context) {
        this.log(icon, message, null, context);
    }

    protected void log(Icon icon, String message, Throwable error) {
        this.log(icon, message, error, (ActionContext)new LogRowConsoleActionContext());
    }

    protected void log(Icon icon, String message, Throwable error, ActionContext context) {
        this.logRow(new MessageLogRow(icon, message, new Date(), error, context, this.computeToolbarActions(context)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void logRow(LogRow<?> row) {
        Deque<LogRow<?>> deque = this.buffer;
        synchronized (deque) {
            LogRow old = (LogRow)this.logTableModel.deleteKey(row.actionContext());
            if (old != null) {
                this.buffer.remove(old);
            }
            this.logTableModel.addItem(row);
            this.buffer.addLast(row);
            this.truncateLog();
        }
    }

    protected Icon iconForLevel(Level level) {
        if (level == Level.FATAL) {
            return DebuggerResources.ICON_LOG_FATAL;
        }
        if (level == Level.ERROR) {
            return DebuggerResources.ICON_LOG_ERROR;
        }
        if (level == Level.WARN) {
            return DebuggerResources.ICON_LOG_WARN;
        }
        return null;
    }

    protected void logEvent(LogEvent event) {
        LogRowConsoleActionContext context = new LogRowConsoleActionContext();
        this.logRow(new MessageLogRow(this.iconForLevel(event.getLevel()), "<html>" + HTMLUtilities.escapeHTML((String)event.getMessage().getFormattedMessage()), new Date(event.getTimeMillis()), event.getThrown(), (ActionContext)context, this.computeToolbarActions((ActionContext)context)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromLog(ActionContext context) {
        Deque<LogRow<?>> deque = this.buffer;
        synchronized (deque) {
            LogRow r = (LogRow)this.logTableModel.deleteKey(context);
            this.buffer.remove(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean logContains(ActionContext context) {
        Deque<LogRow<?>> deque = this.buffer;
        synchronized (deque) {
            return this.logTableModel.getMap().containsKey(context);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<ActionContext> getActionContexts() {
        Deque<LogRow<?>> deque = this.buffer;
        synchronized (deque) {
            return List.copyOf(this.logTableModel.getMap().keySet());
        }
    }

    protected void addResolutionAction(DockingActionIf action) {
        DockingActionIf replaced = this.actionsByOwnerThenName.computeIfAbsent(action.getOwner(), o -> new LinkedHashMap()).put(action.getName(), action);
        if (replaced != null) {
            Msg.warn((Object)((Object)this), (Object)("Duplicate resolution action registered: " + action.getFullName()));
        }
    }

    protected void removeResolutionAction(DockingActionIf action) {
        Map<String, DockingActionIf> byName = this.actionsByOwnerThenName.get(action.getOwner());
        if (byName == null) {
            Msg.warn((Object)((Object)this), (Object)("Action to remove was never added: " + action.getFullName()));
            return;
        }
        DockingActionIf removed = byName.get(action.getName());
        if (removed != action) {
            if (removed != null) {
                Msg.warn((Object)((Object)this), (Object)("Action to remove did not match that added: " + action.getFullName()));
            } else {
                Msg.warn((Object)((Object)this), (Object)("Action to removed was never added: " + action.getFullName()));
            }
            return;
        }
        if (byName.isEmpty()) {
            this.actionsByOwnerThenName.remove(action.getOwner());
        }
    }

    protected Stream<DockingActionIf> streamActions(ActionContext context) {
        return this.actionsByOwnerThenName.values().stream().flatMap(m -> m.values().stream()).filter(a -> a.isValidContext(context));
    }

    protected ActionList computeToolbarActions(ActionContext context) {
        return this.streamActions(context).filter(a -> a.getToolBarData() != null).map(a -> new BoundAction((DockingActionIf)a, context)).collect(Collectors.toCollection(ActionList::new));
    }

    public List<DockingActionIf> getPopupActions(Tool tool, ActionContext context) {
        return this.streamActions(context).filter(a -> a.isAddToPopup(context)).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected long getRowCount(Class<? extends ActionContext> ctxCls) {
        Deque<LogRow<?>> deque = this.buffer;
        synchronized (deque) {
            return this.logTableModel.getModelData().stream().filter(r -> ctxCls.isInstance(r.actionContext())).count();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LogRow<?> getLogRow(ActionContext ctx) {
        Deque<LogRow<?>> deque = this.buffer;
        synchronized (deque) {
            return (LogRow)this.logTableModel.getMap().get(ctx);
        }
    }

    @AutoServiceConsumed
    private void setProgressService(ProgressService progressService) {
        if (this.progressService != null) {
            this.progressService.removeProgressListener((ProgressListener)this.progressListener);
        }
        this.progressService = progressService;
        if (this.progressService != null) {
            this.progressService.addProgressListener((ProgressListener)this.progressListener);
        }
        this.resyncProgressRows();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resyncProgressRows() {
        Deque<LogRow<?>> deque = this.buffer;
        synchronized (deque) {
            this.logTableModel.deleteItemsWith(r -> r instanceof MonitorLogRow);
            if (this.progressService == null) {
                return;
            }
            for (MonitorReceiver monitor : this.progressService.getAllMonitors()) {
                if (!monitor.isValid()) continue;
                this.progressListener.monitorCreated(monitor);
            }
        }
    }

    private class ListenerForProgress
    implements ProgressListener {
        final Map<MonitorReceiver, MonitorRowConsoleActionContext> contexts = new HashMap<MonitorReceiver, MonitorRowConsoleActionContext>();
        CancelAction cancelAction;

        private ListenerForProgress() {
            this.cancelAction = new CancelAction(DebuggerConsoleProvider.this.plugin);
        }

        ActionContext contextFor(MonitorReceiver monitor) {
            return (ActionContext)this.contexts.computeIfAbsent(monitor, MonitorRowConsoleActionContext::new);
        }

        ActionList bindActions(ActionContext context) {
            ActionList actions = new ActionList();
            actions.add(new BoundAction((DockingActionIf)this.cancelAction, context));
            return actions;
        }

        public void monitorCreated(MonitorReceiver monitor) {
            ActionContext context = this.contextFor(monitor);
            DebuggerConsoleProvider.this.logRow(new MonitorLogRow(monitor, new Date(), context, this.bindActions(context)));
        }

        public void monitorDisposed(MonitorReceiver monitor, ProgressListener.Disposal disposal) {
            Object context = (ActionContext)this.contexts.remove(monitor);
            if (context == null) {
                context = new MonitorRowConsoleActionContext(monitor);
            }
            DebuggerConsoleProvider.this.removeFromLog((ActionContext)context);
        }

        public void messageUpdated(MonitorReceiver monitor, String message) {
            LogRow logRow = (LogRow)DebuggerConsoleProvider.this.logTableModel.getMap().get(this.contextFor(monitor));
            DebuggerConsoleProvider.this.logTableModel.updateItem(logRow);
        }

        public void errorReported(MonitorReceiver monitor, Throwable error) {
            DebuggerConsoleProvider.this.log(DebuggerResources.ICON_LOG_ERROR, error.getMessage(), error);
        }

        public void progressUpdated(MonitorReceiver monitor, long progress) {
            LogRow logRow = (LogRow)DebuggerConsoleProvider.this.logTableModel.getMap().get(this.contextFor(monitor));
            DebuggerConsoleProvider.this.logTableModel.updateItem(logRow);
        }

        public void attributeUpdated(MonitorReceiver monitor) {
            LogRow logRow = (LogRow)DebuggerConsoleProvider.this.logTableModel.getMap().get(this.contextFor(monitor));
            DebuggerConsoleProvider.this.logTableModel.updateItem(logRow);
        }
    }

    protected static class LogTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<LogTableColumns, ActionContext, LogRow<?>, LogRow<?>> {
        public LogTableModel(PluginTool tool) {
            super(tool, "Log", LogTableColumns.class, r -> r == null ? null : r.actionContext(), r -> r, r -> r);
        }

        public List<LogTableColumns> defaultSortOrder() {
            return List.of(LogTableColumns.ACTIONS, LogTableColumns.TIME);
        }
    }

    protected static class LogTable
    extends GhidraTable {
        public LogTable(LogTableModel model) {
            super((TableModel)((Object)model));
        }

        public void tableChanged(TableModelEvent e) {
            super.tableChanged(e);
            Swing.runIfSwingOrRunLater(() -> this.updateRowHeights());
        }

        public void columnMarginChanged(ChangeEvent e) {
            super.columnMarginChanged(e);
            Swing.runIfSwingOrRunLater(() -> this.updateRowHeights());
        }

        protected void updateRowHeights() {
            TableModel model = this.getModel();
            int rows = model.getRowCount();
            int cols = this.getColumnCount();
            for (int r = 0; r < rows; ++r) {
                int height = 16;
                for (int c = 0; c < cols; ++c) {
                    height = Math.max(height, this.computePreferredHeight(r, c));
                }
                this.setRowHeight(r, height);
            }
        }

        protected int computePreferredHeight(int r, int c) {
            TableCellRenderer renderer = this.getCellRenderer(r, c);
            if (renderer instanceof ConsoleActionsCellRenderer) {
                ActionList actions = (ActionList)this.getModel().getValueAt(r, this.convertColumnIndexToModel(c));
                if (actions != null && !actions.isEmpty()) {
                    return 34;
                }
                return 0;
            }
            if (renderer instanceof HtmlOrProgressCellRenderer) {
                HtmlOrProgressCellRenderer custom = (HtmlOrProgressCellRenderer)((Object)renderer);
                int colWidth = this.getColumnModel().getColumn(c).getWidth();
                this.prepareRenderer(renderer, r, c);
                return custom.getRowHeight(colWidth);
            }
            return 0;
        }
    }

    protected static enum LogTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<LogTableColumns, LogRow<?>>
    {
        ICON("Icon", Icon.class, LogRow::icon, ColumnSortState.SortDirection.ASCENDING, false),
        MESSAGE("Message", Object.class, LogRow::message, ColumnSortState.SortDirection.ASCENDING, false){

            public GColumnRenderer<?> getRenderer() {
                return HtmlOrProgressCellRenderer.INSTANCE;
            }
        }
        ,
        ACTIONS("Actions", ActionList.class, LogRow::actions, ColumnSortState.SortDirection.DESCENDING, true){
            private static final ConsoleActionsCellRenderer RENDERER = new ConsoleActionsCellRenderer();

            public GColumnRenderer<?> getRenderer() {
                return RENDERER;
            }
        }
        ,
        TIME("Time", Date.class, LogRow::date, ColumnSortState.SortDirection.DESCENDING, false){

            public GColumnRenderer<?> getRenderer() {
                return CustomToStringCellRenderer.TIME_24HMSms;
            }
        };

        private final String header;
        private final Function<LogRow<?>, ?> getter;
        private final Class<?> cls;
        private final ColumnSortState.SortDirection defaultSortDirection;
        private final boolean editable;

        private <T> LogTableColumns(String header, Class<T> cls, Function<LogRow<?>, T> getter, ColumnSortState.SortDirection defaultSortDirection, boolean editable) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.defaultSortDirection = defaultSortDirection;
            this.editable = editable;
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(LogRow<?> row) {
            return this.getter.apply(row);
        }

        public boolean isEditable(LogRow<?> row) {
            return this.editable;
        }

        public void setValueOf(LogRow<?> row, Object value) {
        }

        public ColumnSortState.SortDirection defaultSortDirection() {
            return this.defaultSortDirection;
        }
    }

    public static interface LogRow<T> {
        public Icon icon();

        public T message();

        public ActionList actions();

        public Date date();

        public ActionContext actionContext();

        default public boolean activated() {
            return false;
        }
    }

    static final class MessageLogRow
    extends Record
    implements LogRow<String> {
        private final Icon icon;
        private final String message;
        private final Date date;
        private final Throwable error;
        private final ActionContext actionContext;
        private final ActionList actions;

        public MessageLogRow(Icon icon, String message, Date date, Throwable error, ActionContext actionContext, ActionList actions) {
            this.icon = icon;
            this.message = message;
            this.date = date;
            this.error = error;
            this.actionContext = actionContext;
            this.actions = Objects.requireNonNull(actions);
        }

        @Override
        public boolean activated() {
            Msg.showError((Object)this, null, (String)"Inspect error", (Object)this.message, (Throwable)this.error);
            return true;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{MessageLogRow.class, "icon;message;date;error;actionContext;actions", "icon", "message", "date", "error", "actionContext", "actions"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MessageLogRow.class, "icon;message;date;error;actionContext;actions", "icon", "message", "date", "error", "actionContext", "actions"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MessageLogRow.class, "icon;message;date;error;actionContext;actions", "icon", "message", "date", "error", "actionContext", "actions"}, this, o);
        }

        @Override
        public Icon icon() {
            return this.icon;
        }

        @Override
        public String message() {
            return this.message;
        }

        @Override
        public Date date() {
            return this.date;
        }

        public Throwable error() {
            return this.error;
        }

        @Override
        public ActionContext actionContext() {
            return this.actionContext;
        }

        @Override
        public ActionList actions() {
            return this.actions;
        }
    }

    public static class ActionList
    extends ArrayList<BoundAction> {
    }

    static final class MonitorLogRow
    extends Record
    implements LogRow<MonitorReceiver> {
        private final MonitorReceiver message;
        private final Date date;
        private final ActionContext actionContext;
        private final ActionList actions;
        static final GIcon ICON = new GIcon("icon.pending");

        public MonitorLogRow(MonitorReceiver message, Date date, ActionContext actionContext, ActionList actions) {
            this.message = message;
            this.date = date;
            this.actionContext = actionContext;
            this.actions = Objects.requireNonNull(actions);
        }

        @Override
        public Icon icon() {
            return ICON;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{MonitorLogRow.class, "message;date;actionContext;actions", "message", "date", "actionContext", "actions"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{MonitorLogRow.class, "message;date;actionContext;actions", "message", "date", "actionContext", "actions"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{MonitorLogRow.class, "message;date;actionContext;actions", "message", "date", "actionContext", "actions"}, this, o);
        }

        @Override
        public MonitorReceiver message() {
            return this.message;
        }

        @Override
        public Date date() {
            return this.date;
        }

        @Override
        public ActionContext actionContext() {
            return this.actionContext;
        }

        @Override
        public ActionList actions() {
            return this.actions;
        }
    }

    public static class BoundAction {
        public final DockingActionIf action;
        public final ActionContext context;

        public BoundAction(DockingActionIf action, ActionContext context) {
            this.action = action;
            this.context = context;
        }

        public String toString() {
            return this.getName();
        }

        public String getName() {
            return this.action.getName();
        }

        public Icon getIcon() {
            return this.action.getToolBarData().getIcon();
        }

        public boolean isEnabled() {
            return this.action.isEnabledForContext(this.context);
        }

        public String getTooltipText() {
            return this.action.getDescription();
        }

        public void perform() {
            this.action.actionPerformed(this.context);
        }
    }

    static class CancelAction
    extends DockingAction {
        static final Icon ICON = Icons.STOP_ICON;
        static final String HELP_ANCHOR = "cancel";

        public CancelAction(Plugin owner) {
            super("Cancel", owner.getName());
            this.setToolBarData(new ToolBarData(ICON));
            this.setHelpLocation(new HelpLocation(owner.getName(), HELP_ANCHOR));
        }

        public void actionPerformed(ActionContext context) {
            if (!(context instanceof MonitorRowConsoleActionContext)) {
                return;
            }
            MonitorRowConsoleActionContext ctx = (MonitorRowConsoleActionContext)context;
            ctx.getMonitor().cancel();
        }

        public boolean isEnabledForContext(ActionContext context) {
            if (!(context instanceof MonitorRowConsoleActionContext)) {
                return false;
            }
            MonitorRowConsoleActionContext ctx = (MonitorRowConsoleActionContext)context;
            MonitorReceiver monitor = ctx.getMonitor();
            return monitor.isCancelEnabled() && !monitor.isCancelled();
        }
    }
}

