/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.control;

import docking.ActionContext;
import docking.DockingContextListener;
import docking.action.DockingAction;
import docking.action.DockingActionIf;
import docking.action.builder.ActionBuilder;
import docking.menu.ActionState;
import docking.menu.MultiStateDockingAction;
import docking.widgets.EventTrigger;
import ghidra.app.context.ProgramLocationActionContext;
import ghidra.app.plugin.core.debug.AbstractDebuggerPlugin;
import ghidra.app.plugin.core.debug.event.TraceActivatedPluginEvent;
import ghidra.app.plugin.core.debug.event.TraceClosedPluginEvent;
import ghidra.app.plugin.core.debug.gui.control.ControlModeAction;
import ghidra.app.plugin.core.debug.gui.control.DisconnectAction;
import ghidra.app.plugin.core.debug.gui.control.DisconnectTask;
import ghidra.app.plugin.core.debug.gui.control.EmulateInterruptAction;
import ghidra.app.plugin.core.debug.gui.control.EmulateResumeAction;
import ghidra.app.plugin.core.debug.gui.control.EmulateSkipOverAction;
import ghidra.app.plugin.core.debug.gui.control.EmulateStepBackAction;
import ghidra.app.plugin.core.debug.gui.control.EmulateStepIntoAction;
import ghidra.app.plugin.core.debug.gui.control.TargetActionTask;
import ghidra.app.plugin.core.debug.gui.control.TargetInterruptAction;
import ghidra.app.plugin.core.debug.gui.control.TargetKillAction;
import ghidra.app.plugin.core.debug.gui.control.TargetResumeAction;
import ghidra.app.plugin.core.debug.gui.control.TargetStepExtAction;
import ghidra.app.plugin.core.debug.gui.control.TargetStepIntoAction;
import ghidra.app.plugin.core.debug.gui.control.TargetStepOutAction;
import ghidra.app.plugin.core.debug.gui.control.TargetStepOverAction;
import ghidra.app.plugin.core.debug.gui.control.TraceSnapBackwardAction;
import ghidra.app.plugin.core.debug.gui.control.TraceSnapForwardAction;
import ghidra.app.services.DebuggerControlService;
import ghidra.app.services.DebuggerEmulationService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.app.services.ProgressService;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.control.ControlMode;
import ghidra.debug.api.emulation.DebuggerPcodeMachine;
import ghidra.debug.api.model.DebuggerObjectActionContext;
import ghidra.debug.api.target.ActionName;
import ghidra.debug.api.target.Target;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.plugintool.PluginEvent;
import ghidra.framework.plugintool.PluginInfo;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.framework.plugintool.util.PluginStatus;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.trace.model.thread.TraceThread;
import ghidra.trace.model.time.schedule.Scheduler;
import ghidra.trace.model.time.schedule.TraceSchedule;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.Msg;
import ghidra.util.Swing;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;

@PluginInfo(shortDescription="Debugger global controls", description="GUI to control target, trace, and emulator; and edit machine state", category="Debugger", packageName="Debugger", status=PluginStatus.RELEASED, eventsConsumed={TraceActivatedPluginEvent.class, TraceClosedPluginEvent.class}, servicesRequired={DebuggerControlService.class, DebuggerTraceManagerService.class})
public class DebuggerControlPlugin
extends AbstractDebuggerPlugin
implements DockingContextListener {
    private final TraceDomainObjectListener listenerForObjects = new TraceDomainObjectListener(){
        {
            this.listenFor((TraceEvent)TraceEvents.VALUE_CREATED, this::valueChanged);
            this.listenFor((TraceEvent)TraceEvents.VALUE_DELETED, this::valueChanged);
            this.listenFor((TraceEvent)TraceEvents.VALUE_LIFESPAN_CHANGED, this::valueLifespanChanged);
        }

        private void valueChanged(TraceObjectValue value) {
            if (value.getLifespan().contains(DebuggerControlPlugin.this.current.getSnap())) {
                Swing.runIfSwingOrRunLater(() -> DebuggerControlPlugin.this.updateActionsEnabled());
            }
        }

        private void valueLifespanChanged(TraceObjectValue value, Lifespan oldLife, Lifespan newLife) {
            if (newLife.contains(DebuggerControlPlugin.this.current.getSnap()) != oldLife.contains(DebuggerControlPlugin.this.current.getSnap())) {
                Swing.runIfSwingOrRunLater(() -> DebuggerControlPlugin.this.updateActionsEnabled());
            }
        }
    };
    private final DebuggerControlService.ControlModeChangeListener listenerForModeChanges = this::modeChanged;
    private final DebuggerEmulationService.EmulatorStateListener listenerForEmuStateChanges = new DebuggerEmulationService.EmulatorStateListener(){

        public void running(DebuggerEmulationService.CachedEmulator emu) {
            Swing.runIfSwingOrRunLater(() -> DebuggerControlPlugin.this.updateActions());
        }

        public void stopped(DebuggerEmulationService.CachedEmulator emu) {
            Swing.runIfSwingOrRunLater(() -> DebuggerControlPlugin.this.updateActions());
        }
    };
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected MultiStateDockingAction<ControlMode> actionControlMode;
    DockingAction actionTargetResume;
    DockingAction actionTargetInterrupt;
    DockingAction actionTargetKill;
    DockingAction actionTargetStepInto;
    DockingAction actionTargetStepOver;
    DockingAction actionTargetStepOut;
    DockingAction actionTargetDisconnect;
    Set<DockingAction> actionsTarget;
    final Set<DockingAction> actionsTargetStepExt = new HashSet<DockingAction>();
    final Set<DockingAction> actionsTargetAll = new HashSet<DockingAction>();
    DockingAction actionEmulateResume;
    DockingAction actionEmulateInterrupt;
    DockingAction actionEmulateStepBack;
    DockingAction actionEmulateStepInto;
    DockingAction actionEmulateSkipOver;
    Set<DockingAction> actionsEmulate;
    DockingAction actionTraceSnapBackward;
    DockingAction actionTraceSnapForward;
    Set<DockingAction> actionsTrace;
    Set<Set<DockingAction>> actionSets;
    ActionContext context;
    @AutoServiceConsumed
    private DebuggerTraceManagerService traceManager;
    private DebuggerControlService controlService;
    private DebuggerEmulationService emulationService;
    @AutoServiceConsumed
    private ProgressService progressService;

    public DebuggerControlPlugin(PluginTool tool) {
        super(tool);
        tool.addContextListener((DockingContextListener)this);
        this.createActions();
    }

    protected Set<DockingAction> getActionSet(ControlMode mode) {
        switch (mode) {
            case RO_TARGET: 
            case RW_TARGET: {
                return this.actionsTargetAll;
            }
            case RO_TRACE: 
            case RW_TRACE: {
                return this.actionsTrace;
            }
            case RW_EMULATOR: {
                return this.actionsEmulate;
            }
        }
        throw new AssertionError();
    }

    protected Set<DockingAction> getActionSet() {
        return this.getActionSet(this.computeCurrentControlMode());
    }

    protected void updateActionsEnabled(ControlMode mode) {
        for (DockingAction action : this.getActionSet(mode)) {
            action.setEnabled(action.isEnabledForContext(this.context));
        }
    }

    protected void updateActionsEnabled() {
        this.updateActionsEnabled(this.computeCurrentControlMode());
    }

    protected static boolean isSameContext(ActionContext ctx1, ActionContext ctx2) {
        if (ctx1 instanceof ProgramLocationActionContext) {
            Address addr2;
            ProgramLocationActionContext locCtx1 = (ProgramLocationActionContext)ctx1;
            if (!(ctx2 instanceof ProgramLocationActionContext)) {
                return false;
            }
            ProgramLocationActionContext locCtx2 = (ProgramLocationActionContext)ctx2;
            Program prog1 = locCtx1.getProgram();
            Program prog2 = locCtx2.getProgram();
            if (prog1 != prog2) {
                return false;
            }
            Address addr1 = locCtx1.getAddress();
            return Objects.equals(addr1, addr2 = locCtx2.getAddress());
        }
        if (ctx1 instanceof DebuggerObjectActionContext) {
            DebuggerObjectActionContext objCtx1 = (DebuggerObjectActionContext)ctx1;
            if (!(ctx2 instanceof DebuggerObjectActionContext)) {
                return false;
            }
            DebuggerObjectActionContext objCtx2 = (DebuggerObjectActionContext)ctx2;
            return Objects.equals(objCtx1.getObjectValues(), objCtx2.getObjectValues());
        }
        return true;
    }

    public void contextChanged(ActionContext context) {
        boolean same = DebuggerControlPlugin.isSameContext(this.context, context);
        this.context = context;
        if (same) {
            return;
        }
        this.updateTargetStepExtActions();
        this.updateActions();
    }

    protected void createActions() {
        this.actionControlMode = new ControlModeAction(this);
        this.tool.addAction(this.actionControlMode);
        this.actionTargetResume = TargetResumeAction.builder(this).build();
        this.actionTargetInterrupt = TargetInterruptAction.builder(this).build();
        this.actionTargetKill = TargetKillAction.builder(this).build();
        this.actionTargetStepInto = TargetStepIntoAction.builder(this).build();
        this.actionTargetStepOver = TargetStepOverAction.builder(this).build();
        this.actionTargetStepOut = TargetStepOutAction.builder(this).build();
        this.actionTargetDisconnect = ((ActionBuilder)((ActionBuilder)DisconnectAction.builder(this).enabledWhen(this::isActionTargetDisconnectEnabled)).onAction(this::activatedTargetDisconnect)).build();
        this.actionsTarget = Set.of(this.actionTargetResume, this.actionTargetInterrupt, this.actionTargetKill, this.actionTargetStepInto, this.actionTargetStepOver, this.actionTargetStepOut, this.actionTargetDisconnect);
        this.updateTargetStepExtActions();
        this.actionEmulateResume = ((ActionBuilder)((ActionBuilder)EmulateResumeAction.builder(this).enabledWhen(this::isActionEmulateResumeEnabled)).onAction(this::activateEmulateResume)).build();
        this.actionEmulateInterrupt = ((ActionBuilder)((ActionBuilder)EmulateInterruptAction.builder(this).enabledWhen(this::isActionEmulateInterruptEnabled)).onAction(this::activateEmulateInterrupt)).build();
        this.actionEmulateStepBack = ((ActionBuilder)((ActionBuilder)EmulateStepBackAction.builder(this).enabledWhen(this::isActionEmulateStepBackEnabled)).onAction(this::activateEmulateStepBack)).build();
        this.actionEmulateStepInto = ((ActionBuilder)((ActionBuilder)EmulateStepIntoAction.builder(this).enabledWhen(this::isActionEmulateStepIntoEnabled)).onAction(this::activateEmulateStepInto)).build();
        this.actionEmulateSkipOver = ((ActionBuilder)((ActionBuilder)EmulateSkipOverAction.builder(this).enabledWhen(this::isActionEmulateSkipOverEnabled)).onAction(this::activateEmulateSkipOver)).build();
        this.actionsEmulate = Set.of(this.actionEmulateResume, this.actionEmulateInterrupt, this.actionEmulateStepBack, this.actionEmulateStepInto, this.actionEmulateSkipOver);
        this.actionTraceSnapBackward = ((ActionBuilder)((ActionBuilder)TraceSnapBackwardAction.builder(this).enabledWhen(this::isActionTraceSnapBackwardEnabled)).onAction(this::activateTraceSnapBackward)).build();
        this.actionTraceSnapForward = ((ActionBuilder)((ActionBuilder)TraceSnapForwardAction.builder(this).enabledWhen(this::isActionTraceSnapForwardEnabled)).onAction(this::activateTraceSnapForward)).build();
        this.actionsTrace = Set.of(this.actionTraceSnapBackward, this.actionTraceSnapForward);
        this.actionSets = Set.of(this.actionsTargetAll, this.actionsEmulate, this.actionsTrace);
        this.updateActions();
    }

    protected void addTargetStepExtActions(Target target) {
        for (Target.ActionEntry entry : target.collectActions(ActionName.STEP_EXT, this.context).values()) {
            if (entry.requiresPrompt()) continue;
            this.actionsTargetStepExt.add(((ActionBuilder)((ActionBuilder)((ActionBuilder)TargetStepExtAction.builder(entry.display(), this).description(entry.details())).enabledWhen(ctx -> entry.isEnabled())).onAction(ctx -> TargetActionTask.runAction(this.tool, entry.display(), entry))).build());
        }
    }

    DockingAction getTargetStepExtAction(String name) {
        for (DockingAction action : this.actionsTargetStepExt) {
            if (!name.equals(action.getName())) continue;
            return action;
        }
        return null;
    }

    protected void updateTargetStepExtActions() {
        this.hideActions(this.actionsTargetStepExt);
        this.actionsTargetStepExt.clear();
        this.actionsTargetAll.clear();
        this.actionsTargetAll.addAll(this.actionsTarget);
        Target target = this.current.getTarget();
        if (target == null || !target.isValid()) {
            return;
        }
        this.addTargetStepExtActions(target);
        this.actionsTargetAll.addAll(this.actionsTargetStepExt);
    }

    protected void activateControlMode(ActionState<ControlMode> state, EventTrigger trigger) {
        if (this.current.getTrace() == null) {
            return;
        }
        if (this.controlService == null) {
            return;
        }
        this.controlService.setCurrentMode(this.current.getTrace(), (ControlMode)state.getUserData());
    }

    private void modeChanged(Trace trace, ControlMode mode) {
        Swing.runIfSwingOrRunLater(() -> {
            if (this.current.getTrace() == trace) {
                this.updateActions();
            }
        });
    }

    private boolean isActionTargetDisconnectEnabled(ActionContext context) {
        return this.current.isAlive();
    }

    private void activatedTargetDisconnect(ActionContext context) {
        Target target = this.current.getTarget();
        if (target == null) {
            return;
        }
        TargetActionTask.executeTask(this.tool, new DisconnectTask(this.tool, List.of(target)));
    }

    private boolean haveEmuAndTrace() {
        if (this.emulationService == null) {
            return false;
        }
        return this.current.getTrace() != null;
    }

    private boolean haveEmuAndThread() {
        if (this.emulationService == null) {
            return false;
        }
        return this.current.getThread() != null;
    }

    private DebuggerPcodeMachine<?> getBusyEmulator() {
        Iterator iterator = this.emulationService.getBusyEmulators().iterator();
        if (iterator.hasNext()) {
            DebuggerEmulationService.CachedEmulator ce = (DebuggerEmulationService.CachedEmulator)iterator.next();
            return ce.emulator();
        }
        return null;
    }

    private boolean isActionEmulateResumeEnabled(ActionContext context) {
        if (!this.haveEmuAndThread()) {
            return false;
        }
        return this.getBusyEmulator() == null;
    }

    private void activateEmulateResume(ActionContext context) {
        if (!this.haveEmuAndThread()) {
            return;
        }
        if (this.getBusyEmulator() != null) {
            return;
        }
        DebuggerCoordinates current = this.current;
        TraceSchedule time = current.getTime();
        ((CompletableFuture)this.emulationService.backgroundRun(current.getPlatform(), time.steppedForward(null, 0L), Scheduler.oneThread((TraceThread)current.getThread())).thenAcceptAsync(r -> this.traceManager.activate(current.time(r.schedule()), DebuggerTraceManagerService.ActivationCause.USER), (Executor)AsyncUtils.SWING_EXECUTOR)).exceptionally(ex -> {
            Msg.showError((Object)((Object)this), null, (String)"Emulate", (Object)"Error emulating", (Throwable)ex);
            return null;
        });
    }

    private boolean isActionEmulateInterruptEnabled(ActionContext context) {
        if (!this.haveEmuAndThread()) {
            return false;
        }
        return this.getBusyEmulator() != null;
    }

    private void activateEmulateInterrupt(ActionContext context) {
        if (this.emulationService == null) {
            return;
        }
        DebuggerPcodeMachine<?> emu = this.getBusyEmulator();
        emu.setSuspended(true);
    }

    private boolean isActionEmulateStepBackEnabled(ActionContext context) {
        if (!this.haveEmuAndTrace()) {
            return false;
        }
        return this.current.getTime().steppedBackward(this.current.getTrace(), 1L) != null;
    }

    private void activateEmulateStepBack(ActionContext context) {
        this.traceManager.activateTime(this.current.getTime().steppedBackward(this.current.getTrace(), 1L));
    }

    private boolean isActionEmulateStepIntoEnabled(ActionContext context) {
        return this.haveEmuAndThread();
    }

    private void activateEmulateStepInto(ActionContext context) {
        this.traceManager.activateTime(this.current.getTime().steppedForward(this.current.getThread(), 1L));
    }

    private boolean isActionEmulateSkipOverEnabled(ActionContext context) {
        return this.haveEmuAndThread();
    }

    private void activateEmulateSkipOver(ActionContext context) {
        this.traceManager.activateTime(this.current.getTime().skippedForward(this.current.getThread(), 1L));
    }

    private boolean isActionTraceSnapBackwardEnabled(ActionContext context) {
        if (this.current.getTrace() == null) {
            return false;
        }
        if (!this.current.getTime().isSnapOnly()) {
            return true;
        }
        return this.current.getSnap() > 0L;
    }

    private void activateTraceSnapBackward(ActionContext context) {
        if (this.current.getTime().isSnapOnly()) {
            this.traceManager.activateSnap(this.current.getSnap() - 1L);
        } else {
            this.traceManager.activateSnap(this.current.getSnap());
        }
    }

    private boolean isActionTraceSnapForwardEnabled(ActionContext context) {
        Trace curTrace = this.current.getTrace();
        if (curTrace == null) {
            return false;
        }
        Long maxSnap = curTrace.getTimeManager().getMaxSnap();
        return maxSnap != null && this.current.getSnap() < maxSnap;
    }

    private void activateTraceSnapForward(ActionContext contetxt) {
        this.traceManager.activateSnap(this.current.getSnap() + 1L);
    }

    protected void coordinatesActivated(DebuggerCoordinates coords) {
        boolean sameTrace = true;
        if (this.current.getTrace() != coords.getTrace()) {
            sameTrace = false;
            if (this.current.getTrace() != null) {
                this.current.getTrace().removeListener((DomainObjectListener)this.listenerForObjects);
            }
            if (coords.getTrace() != null) {
                coords.getTrace().addListener((DomainObjectListener)this.listenerForObjects);
            }
        }
        this.current = coords;
        if (!sameTrace) {
            this.updateTargetStepExtActions();
        }
        this.updateActions();
    }

    private ControlMode computeCurrentControlMode() {
        if (this.controlService == null) {
            return ControlMode.DEFAULT;
        }
        if (this.current.getTrace() == null) {
            return ControlMode.DEFAULT;
        }
        return this.controlService.getCurrentMode(this.current.getTrace());
    }

    private void hideActions(Collection<? extends DockingActionIf> actions) {
        if (this.tool == null) {
            return;
        }
        for (DockingActionIf dockingActionIf : actions) {
            this.tool.removeAction(dockingActionIf);
        }
    }

    private void showActions(Collection<? extends DockingActionIf> actions) {
        if (this.tool == null) {
            return;
        }
        Set already = this.tool.getDockingActionsByOwnerName(this.name);
        for (DockingActionIf dockingActionIf : actions) {
            if (already.contains(dockingActionIf)) continue;
            this.tool.addAction(dockingActionIf);
        }
    }

    private void updateActions() {
        ControlMode mode = this.computeCurrentControlMode();
        this.actionControlMode.setCurrentActionStateByUserData((Object)mode);
        Set<DockingAction> actions = this.getActionSet(mode);
        for (Set<DockingAction> set : this.actionSets) {
            if (set == actions) {
                this.showActions(set);
                continue;
            }
            this.hideActions(set);
        }
        this.updateActionsEnabled(mode);
    }

    protected void traceClosed(Trace trace) {
        if (this.current.getTrace() == trace) {
            trace.removeListener((DomainObjectListener)this.listenerForObjects);
            this.current = DebuggerCoordinates.NOWHERE;
            this.updateTargetStepExtActions();
        }
        this.updateActions();
    }

    @AutoServiceConsumed
    private void setControlService(DebuggerControlService editingService) {
        if (this.controlService != null) {
            this.controlService.removeModeChangeListener(this.listenerForModeChanges);
        }
        this.controlService = editingService;
        if (this.controlService != null) {
            this.controlService.addModeChangeListener(this.listenerForModeChanges);
        }
        this.updateActions();
    }

    @AutoServiceConsumed
    private void setEmulationService(DebuggerEmulationService emulationService) {
        if (this.emulationService != null) {
            this.emulationService.removeStateListener(this.listenerForEmuStateChanges);
        }
        this.emulationService = emulationService;
        if (this.emulationService != null) {
            this.emulationService.addStateListener(this.listenerForEmuStateChanges);
        }
        this.updateActions();
    }

    public void processEvent(PluginEvent event) {
        super.processEvent(event);
        if (event instanceof TraceActivatedPluginEvent) {
            TraceActivatedPluginEvent ev = (TraceActivatedPluginEvent)event;
            this.coordinatesActivated(ev.getActiveCoordinates());
        } else if (event instanceof TraceClosedPluginEvent) {
            TraceClosedPluginEvent ev = (TraceClosedPluginEvent)event;
            this.traceClosed(ev.getTrace());
        }
    }
}

