/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.control;

import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.services.DebuggerConsoleService;
import ghidra.app.services.ProgressService;
import ghidra.async.AsyncUtils;
import ghidra.debug.api.target.Target;
import ghidra.framework.plugintool.PluginTool;
import ghidra.util.Msg;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.function.Function;

public class TargetActionTask
extends Task {
    private final PluginTool tool;
    private final Target.ActionEntry entry;

    public static CompletableFuture<Void> executeTask(PluginTool tool, Task task) {
        ProgressService progressService = (ProgressService)tool.getService(ProgressService.class);
        if (progressService != null) {
            return progressService.execute(task);
        }
        FutureTask wrapper = new FutureTask(task);
        tool.execute((Task)wrapper);
        return wrapper.future;
    }

    public static <T> CompletableFuture<T> executeTask(PluginTool tool, String title, boolean canCancel, boolean hasProgress, boolean isModal, Function<TaskMonitor, CompletableFuture<T>> futureSupplier) {
        ProgressService progressService = (ProgressService)tool.getService(ProgressService.class);
        if (progressService != null) {
            return progressService.execute(canCancel, hasProgress, isModal, futureSupplier);
        }
        FutureAsTask<T> task = new FutureAsTask<T>(title, canCancel, hasProgress, isModal, futureSupplier);
        tool.execute(task);
        return task.future;
    }

    public static CompletableFuture<Void> runAction(PluginTool tool, String title, Target.ActionEntry entry) {
        return TargetActionTask.executeTask(tool, new TargetActionTask(tool, title, entry));
    }

    public TargetActionTask(PluginTool tool, String title, Target.ActionEntry entry) {
        super(title, false, false, false);
        this.tool = tool;
        this.entry = entry;
    }

    public void run(TaskMonitor monitor) throws CancelledException {
        try {
            this.entry.run(this.entry.requiresPrompt());
        }
        catch (Throwable e) {
            this.reportError(e);
        }
    }

    private void reportError(Throwable error) {
        DebuggerConsoleService consoleService = (DebuggerConsoleService)this.tool.getService(DebuggerConsoleService.class);
        if (consoleService != null) {
            consoleService.log(DebuggerResources.ICON_LOG_ERROR, error.getMessage(), error);
        } else {
            Msg.showError((Object)((Object)this), null, (String)"Control Error", (Object)error.getMessage(), (Throwable)error);
        }
    }

    static class FutureTask
    extends Task {
        private final Task delegate;
        final CompletableFuture<Void> future = new CompletableFuture();

        public FutureTask(Task delegate) {
            super(delegate.getTaskTitle(), delegate.canCancel(), delegate.hasProgress(), delegate.isModal(), delegate.getWaitForTaskCompleted());
            this.delegate = delegate;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            try {
                this.delegate.run(monitor);
                this.future.complete(null);
            }
            catch (CancelledException e) {
                this.future.cancel(false);
            }
            catch (Throwable e) {
                this.future.completeExceptionally(e);
            }
        }
    }

    static class FutureAsTask<T>
    extends Task {
        final CompletableFuture<T> future = new CompletableFuture();
        private final Function<TaskMonitor, CompletableFuture<T>> futureSupplier;

        public FutureAsTask(String title, boolean canCancel, boolean hasProgress, boolean isModal, Function<TaskMonitor, CompletableFuture<T>> futureSupplier) {
            super(title, canCancel, hasProgress, isModal);
            this.futureSupplier = futureSupplier;
        }

        public void run(TaskMonitor monitor) throws CancelledException {
            CompletableFuture<T> future = this.futureSupplier.apply(monitor);
            future.handle(AsyncUtils.copyTo(this.future));
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
    }
}

