/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.memory;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.widgets.table.GTable;
import ghidra.app.plugin.core.debug.gui.memory.DebuggerRegionsProvider;
import ghidra.app.plugin.core.debug.gui.memory.RegionRow;
import ghidra.trace.model.memory.TraceMemoryRegion;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class DebuggerRegionActionContext
extends DefaultActionContext {
    private final Set<TraceMemoryRegion> selectedRegions;
    private final boolean forcedSingle;

    private static Set<TraceMemoryRegion> toRegions(Collection<RegionRow> rows) {
        return rows.stream().map(RegionRow::getRegion).collect(Collectors.toUnmodifiableSet());
    }

    public DebuggerRegionActionContext(DebuggerRegionsProvider provider, Collection<RegionRow> rows, GTable table) {
        this((ComponentProvider)provider, DebuggerRegionActionContext.toRegions(rows), (Component)table, false);
    }

    public DebuggerRegionActionContext(ComponentProvider provider, Set<TraceMemoryRegion> selected, Component sourceComponent, boolean forcedSingle) {
        super(provider, selected, sourceComponent);
        this.selectedRegions = selected;
        this.forcedSingle = forcedSingle;
    }

    public Set<TraceMemoryRegion> getSelectedRegions() {
        return this.selectedRegions;
    }

    public boolean isForcedSingle() {
        return this.forcedSingle;
    }
}

