/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.ComponentProvider;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTablePanel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectDefaultActionsMixin;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.ObjectsTablePanel;
import ghidra.app.services.DebuggerListingService;
import ghidra.app.services.DebuggerTraceManagerService;
import ghidra.debug.api.model.DebuggerObjectActionContext;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.plugintool.AutoService;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.annotation.AutoServiceConsumed;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectInterface;
import ghidra.trace.model.target.TraceObjectKeyPath;
import java.awt.Component;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public abstract class AbstractObjectsTableBasedPanel<U extends TraceObjectInterface>
extends ObjectsTablePanel
implements ListSelectionListener,
AbstractQueryTablePanel.CellActivationListener,
ObjectDefaultActionsMixin {
    private final ComponentProvider provider;
    private final Class<U> objType;
    @AutoServiceConsumed
    protected DebuggerTraceManagerService traceManager;
    @AutoServiceConsumed
    protected DebuggerListingService listingService;
    private final AutoService.Wiring autoServiceWiring;
    protected DebuggerObjectActionContext myActionContext;

    public AbstractObjectsTableBasedPanel(Plugin plugin, ComponentProvider provider, Class<U> objType) {
        super(plugin);
        this.provider = provider;
        this.objType = objType;
        this.autoServiceWiring = AutoService.wireServicesConsumed((Plugin)plugin, (Object)this);
        this.setLimitToSnap(true);
        this.setShowHidden(false);
        this.addSelectionListener(this);
        this.addCellActivationListener(this);
    }

    public boolean isContextNonEmpty(DebuggerObjectActionContext ctx) {
        return this.getSelected(ctx).findAny().isPresent();
    }

    public Stream<U> getSelected(DebuggerObjectActionContext ctx) {
        return ctx == null ? null : ctx.getObjectValues().stream().filter(v -> v.isObject()).map(v -> v.getChild().queryInterface(this.objType)).filter(r -> r != null);
    }

    public DebuggerObjectActionContext getActionContext() {
        return this.myActionContext;
    }

    protected abstract ModelQuery computeQuery(TraceObject var1);

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        Trace trace;
        TraceObject object = coordinates.getObject();
        if (object == null && (trace = coordinates.getTrace()) != null) {
            object = trace.getObjectManager().getRootObject();
        }
        this.setQuery(object == null ? ModelQuery.EMPTY : this.computeQuery(object));
        this.goToCoordinates(coordinates);
    }

    protected void setSelected(Set<?> sel) {
        this.trySelect(sel.stream().filter(s -> this.objType.isInstance(s)).map(s -> ((TraceObjectInterface)this.objType.cast(s)).getObject()).collect(Collectors.toSet()));
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        if (e.getValueIsAdjusting()) {
            return;
        }
        List sel = this.getSelectedItems();
        if (!sel.isEmpty()) {
            this.myActionContext = new DebuggerObjectActionContext((Collection)sel.stream().map(r -> r.getValue()).collect(Collectors.toList()), this.provider, (Component)this.table);
        }
    }

    @Override
    public void cellActivated(JTable table) {
        if (this.performElementCellDefaultAction(table)) {
            return;
        }
        this.performValueRowDefaultAction((ObjectTableModel.ValueRow)this.getSelectedItem());
    }

    @Override
    public DebuggerCoordinates getCurrent() {
        return this.current;
    }

    @Override
    public PluginTool getTool() {
        return this.plugin.getTool();
    }

    @Override
    public void activatePath(TraceObjectKeyPath path) {
        if (this.current.getTrace() == null) {
            return;
        }
        try {
            this.traceManager.activate(this.current.pathNonCanonical(path));
        }
        catch (IllegalArgumentException e) {
            this.plugin.getTool().setStatusInfo(e.getMessage(), true);
        }
    }
}

