/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.HTMLUtilities;
import ghidra.util.NumericUtilities;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;

public interface DisplaysObjectValues {
    public long getSnap();

    default public String getNullDisplay() {
        return "";
    }

    default public String getBoolsDisplay(boolean[] bools) {
        return Stream.of(ArrayUtils.toObject((boolean[])bools)).map(b -> b != false ? "T" : "F").collect(Collectors.joining(":"));
    }

    default public String getBytesDisplay(byte[] bytes) {
        return NumericUtilities.convertBytesToString((byte[])bytes, (String)":");
    }

    default public String getCharsDisplay(char[] chars) {
        return new String(chars);
    }

    default public String getShortsDisplay(short[] shorts) {
        return Stream.of(ArrayUtils.toObject((short[])shorts)).map(s -> "%04x".formatted(s)).collect(Collectors.joining(":"));
    }

    default public String getIntsDisplay(int[] ints) {
        return IntStream.of(ints).mapToObj(i -> "%08x".formatted(i)).collect(Collectors.joining(":"));
    }

    default public String getLongsDisplay(long[] longs) {
        return LongStream.of(longs).mapToObj(l -> "%016x".formatted(l)).collect(Collectors.joining(":"));
    }

    default public String getStringsDisplay(String[] strings) {
        return Stream.of(strings).collect(Collectors.joining(":"));
    }

    default public String getPrimitiveValueDisplay(Object value) {
        if (!1.$assertionsDisabled && value instanceof TraceObject) {
            throw new AssertionError();
        }
        if (!1.$assertionsDisabled && value instanceof TraceObjectValue) {
            throw new AssertionError();
        }
        if (value == null) {
            return this.getNullDisplay();
        }
        if (value instanceof boolean[]) {
            boolean[] bools = (boolean[])value;
            return this.getBoolsDisplay(bools);
        }
        if (value instanceof byte[]) {
            byte[] bytes = (byte[])value;
            return this.getBytesDisplay(bytes);
        }
        if (value instanceof char[]) {
            char[] chars = (char[])value;
            return this.getCharsDisplay(chars);
        }
        if (value instanceof short[]) {
            short[] shorts = (short[])value;
            return this.getShortsDisplay(shorts);
        }
        if (value instanceof int[]) {
            int[] ints = (int[])value;
            return this.getIntsDisplay(ints);
        }
        if (value instanceof long[]) {
            long[] longs = (long[])value;
            return this.getLongsDisplay(longs);
        }
        if (value instanceof String[]) {
            String[] strings = (String[])value;
            return this.getStringsDisplay(strings);
        }
        return value.toString();
    }

    default public String getPrimitiveEdgeType(TraceObjectValue edge) {
        return String.valueOf(edge.getTargetSchema().getName()) + ":" + edge.getValue().getClass().getSimpleName();
    }

    default public String getPrimitiveEdgeToolTip(TraceObjectValue edge) {
        return this.getPrimitiveValueDisplay(edge.getValue()) + " (" + this.getPrimitiveEdgeType(edge) + ")";
    }

    default public String getObjectLinkDisplay(TraceObjectValue edge) {
        return this.getObjectDisplay(edge);
    }

    default public String getObjectType(TraceObjectValue edge) {
        TraceObject object = edge.getChild();
        return object.getTargetSchema().getName().toString();
    }

    default public String getObjectLinkToolTip(TraceObjectValue edge) {
        return "Link to " + this.getObjectToolTip(edge);
    }

    default public String getRawObjectDisplay(TraceObjectValue edge) {
        TraceObject object = edge.getChild();
        if (object.isRoot()) {
            return "<root>";
        }
        return object.getCanonicalPath().toString();
    }

    default public String getObjectDisplay(TraceObjectValue edge) {
        TraceObject object = edge.getChild();
        TraceObjectValue displayAttr = object.getAttribute(this.getSnap(), "_display");
        if (displayAttr != null) {
            return displayAttr.getValue().toString();
        }
        return this.getRawObjectDisplay(edge);
    }

    default public String getObjectToolTip(TraceObjectValue edge) {
        String raw;
        String display = this.getObjectDisplay(edge);
        if (display.equals(raw = this.getRawObjectDisplay(edge))) {
            return display + " (" + this.getObjectType(edge) + ")";
        }
        return display + " (" + this.getObjectType(edge) + ":" + raw + ")";
    }

    default public String getEdgeDisplay(TraceObjectValue edge) {
        if (edge == null) {
            return "";
        }
        if (edge.isCanonical()) {
            return this.getObjectDisplay(edge);
        }
        if (edge.isObject()) {
            return this.getObjectLinkDisplay(edge);
        }
        return this.getPrimitiveValueDisplay(edge.getValue());
    }

    default public String getEdgeHtmlDisplay(TraceObjectValue edge) {
        if (edge == null) {
            return "";
        }
        if (!edge.isObject()) {
            return "<html>" + HTMLUtilities.escapeHTML((String)this.getPrimitiveValueDisplay(edge.getValue()), (boolean)true);
        }
        if (edge.isCanonical()) {
            return "<html>" + HTMLUtilities.escapeHTML((String)this.getObjectDisplay(edge), (boolean)true);
        }
        return "<html><em>" + HTMLUtilities.escapeHTML((String)this.getObjectLinkDisplay(edge), (boolean)true) + "</em>";
    }

    default public String getEdgeToolTip(TraceObjectValue edge) {
        if (edge == null) {
            return null;
        }
        if (edge.isCanonical()) {
            return this.getObjectToolTip(edge);
        }
        if (edge.isObject()) {
            return this.getObjectLinkToolTip(edge);
        }
        return this.getPrimitiveEdgeToolTip(edge);
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
    }
}

