/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import generic.Span;
import ghidra.dbg.target.schema.EnumerableTargetObjectSchema;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathPattern;
import ghidra.dbg.util.PathPredicates;
import ghidra.dbg.util.PathUtils;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectManager;
import ghidra.trace.model.target.TraceObjectValPath;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ModelQuery {
    public static final ModelQuery EMPTY = new ModelQuery(PathPredicates.EMPTY);
    private final PathPredicates predicates;

    public static ModelQuery parse(String queryString) {
        return new ModelQuery(PathPredicates.parse((String)queryString));
    }

    public static ModelQuery elementsOf(TraceObjectKeyPath path) {
        return new ModelQuery((PathPredicates)new PathPattern(PathUtils.extend((List)path.getKeyList(), (String)"[]")));
    }

    public static ModelQuery attributesOf(TraceObjectKeyPath path) {
        return new ModelQuery((PathPredicates)new PathPattern(PathUtils.extend((List)path.getKeyList(), (String)"")));
    }

    public ModelQuery(PathPredicates predicates) {
        this.predicates = predicates;
    }

    public String toString() {
        return "<ModelQuery: " + this.predicates.toString() + ">";
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ModelQuery)) {
            return false;
        }
        ModelQuery that = (ModelQuery)obj;
        return Objects.equals(this.predicates, that.predicates);
    }

    public String toQueryString() {
        return this.predicates.getSingletonPattern().toPatternString();
    }

    public Stream<TraceObject> streamObjects(Trace trace, Lifespan span) {
        TraceObjectManager objects = trace.getObjectManager();
        TraceObject root = objects.getRootObject();
        return objects.getValuePaths(span, this.predicates).map(p -> p.getDestinationValue((Object)root)).filter(v -> v instanceof TraceObject).map(v -> (TraceObject)v);
    }

    public Stream<TraceObjectValue> streamValues(Trace trace, Lifespan span) {
        TraceObjectManager objects = trace.getObjectManager();
        return objects.getValuePaths(span, this.predicates).map(p -> {
            TraceObjectValue last = p.getLastEntry();
            return last == null ? objects.getRootObject().getCanonicalParent(0L) : last;
        });
    }

    public Stream<TraceObjectValPath> streamPaths(Trace trace, Lifespan span) {
        return trace.getObjectManager().getValuePaths(span, this.predicates).map(p -> p);
    }

    public List<TargetObjectSchema> computeSchemas(Trace trace) {
        TargetObjectSchema rootSchema = trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return List.of();
        }
        return this.predicates.getPatterns().stream().map(p -> rootSchema.getSuccessorSchema(p.asPath())).distinct().collect(Collectors.toList());
    }

    public TargetObjectSchema computeSingleSchema(Trace trace) {
        List<TargetObjectSchema> schemas = this.computeSchemas(trace);
        if (schemas.size() != 1) {
            return EnumerableTargetObjectSchema.OBJECT;
        }
        return schemas.get(0);
    }

    public Stream<TargetObjectSchema.AttributeSchema> computeAttributes(Trace trace) {
        TargetObjectSchema schema = this.computeSingleSchema(trace);
        return schema.getAttributeSchemas().entrySet().stream().filter(ent -> {
            String attrName = ((TargetObjectSchema.AttributeSchema)ent.getValue()).getName();
            return !"".equals(attrName) && ((String)ent.getKey()).equals(attrName);
        }).map(e -> (TargetObjectSchema.AttributeSchema)e.getValue());
    }

    protected static boolean includes(Lifespan span, PathPattern pattern, TraceObjectValue value) {
        List asPath = pattern.asPath();
        if (asPath.isEmpty()) {
            return value.getParent() == null;
        }
        if (!PathPredicates.keyMatches((String)PathUtils.getKey((List)asPath), (String)value.getEntryKey())) {
            return false;
        }
        TraceObject parent = value.getParent();
        if (parent == null) {
            return false;
        }
        return parent.getAncestors(span, (PathPredicates)pattern.removeRight(1)).anyMatch(v -> v.getSource(parent).isRoot());
    }

    public boolean includes(Lifespan span, TraceObjectValue value) {
        if (!span.intersects((Span)value.getLifespan())) {
            return false;
        }
        for (PathPattern pattern : this.predicates.getPatterns()) {
            if (!ModelQuery.includes(span, pattern, value)) continue;
            return true;
        }
        return false;
    }

    protected static boolean involves(Lifespan span, PathPattern pattern, TraceObjectValue value) {
        TraceObject parent = value.getParent();
        if (parent == null) {
            return true;
        }
        ArrayList asPath = new ArrayList(pattern.asPath());
        while (!asPath.isEmpty()) {
            if (!PathPredicates.keyMatches((String)PathUtils.getKey(asPath), (String)value.getEntryKey())) {
                asPath.remove(asPath.size() - 1);
                continue;
            }
            asPath.remove(asPath.size() - 1);
            if (!parent.getAncestors(span, (PathPredicates)new PathPattern(asPath)).anyMatch(v -> v.getSource(parent).isRoot())) continue;
            return true;
        }
        return false;
    }

    public boolean involves(Lifespan span, TraceObjectValue value) {
        if (!span.intersects((Span)value.getLifespan())) {
            return false;
        }
        for (PathPattern pattern : this.predicates.getPatterns()) {
            if (!ModelQuery.involves(span, pattern, value)) continue;
            return true;
        }
        return false;
    }
}

