/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.GTableColumnModel;
import docking.widgets.table.GTableTextCellEditor;
import ghidra.app.plugin.core.debug.gui.model.AbstractQueryTablePanel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.framework.plugintool.Plugin;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import java.awt.Component;
import java.util.List;
import java.util.stream.Collectors;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class ObjectsTablePanel
extends AbstractQueryTablePanel<ObjectTableModel.ValueRow, ObjectTableModel> {
    private static final String DEFAULT_PREF_KEY = "DEFAULT";

    public ObjectsTablePanel(Plugin plugin) {
        super(plugin);
        this.table.setDefaultEditor(ObjectTableModel.ValueProperty.class, (TableCellEditor)((Object)new PropertyEditor()));
    }

    @Override
    protected ObjectTableModel createModel() {
        return new ObjectTableModel(this.plugin);
    }

    public boolean trySelectAncestor(TraceObject successor) {
        ObjectTableModel.ValueRow row = ((ObjectTableModel)this.tableModel).findTraceObjectAncestor(successor);
        if (row == null) {
            return false;
        }
        this.setSelectedItem(row);
        return true;
    }

    protected String computePreferenceKey() {
        Trace trace = ((ObjectTableModel)this.tableModel).getTrace();
        if (trace == null) {
            return DEFAULT_PREF_KEY;
        }
        ModelQuery query = ((ObjectTableModel)this.tableModel).getQuery();
        if (query == null) {
            return DEFAULT_PREF_KEY;
        }
        List<TargetObjectSchema> schemas = query.computeSchemas(trace);
        if (schemas.isEmpty()) {
            return DEFAULT_PREF_KEY;
        }
        TargetObjectSchema rootSchema = trace.getObjectManager().getRootSchema();
        if (rootSchema == null) {
            return DEFAULT_PREF_KEY;
        }
        return String.valueOf(rootSchema.getName()) + ":" + schemas.stream().map(s -> s.getName().toString()).collect(Collectors.joining(",")) + ":" + (this.isShowHidden() ? "show" : "hide");
    }

    protected void showHiddenColumns(boolean show) {
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        if (tableColumnModel instanceof GTableColumnModel) {
            GTableColumnModel columnModel = (GTableColumnModel)tableColumnModel;
            for (TableColumn tCol : columnModel.getAllColumns()) {
                ObjectTableModel.AutoAttributeColumn attrCol;
                int modelIndex = tCol.getModelIndex();
                DynamicTableColumn dynamicTableColumn = ((ObjectTableModel)this.tableModel).getColumn(modelIndex);
                if (!(dynamicTableColumn instanceof ObjectTableModel.AutoAttributeColumn) || !(attrCol = (ObjectTableModel.AutoAttributeColumn)dynamicTableColumn).isHidden()) continue;
                columnModel.setVisible(tCol, show);
            }
        }
    }

    protected void reloadPreferences() {
        String prefKey = this.computePreferenceKey();
        if (!prefKey.equals(this.table.getPreferenceKey())) {
            this.table.setPreferenceKey(prefKey);
        }
    }

    protected void resyncAttributeVisibility() {
        this.showHiddenColumns(this.isShowHidden());
    }

    @Override
    protected void coordinatesChanged() {
        super.coordinatesChanged();
        this.reloadPreferences();
    }

    @Override
    protected void queryChanged() {
        super.queryChanged();
        this.reloadPreferences();
    }

    @Override
    protected void showHiddenChanged() {
        super.showHiddenChanged();
        this.resyncAttributeVisibility();
    }

    private static class PropertyEditor
    extends GTableTextCellEditor {
        private final JTextField textField = (JTextField)this.getComponent();

        public PropertyEditor() {
            super(new JTextField());
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            super.getTableCellEditorComponent(table, value, isSelected, row, column);
            if (value instanceof ObjectTableModel.ValueProperty) {
                ObjectTableModel.ValueProperty property = (ObjectTableModel.ValueProperty)value;
                this.textField.setText(property.getDisplay());
            } else {
                this.textField.setText(value.toString());
            }
            return this.textField;
        }

        public Object getCellEditorValue() {
            Object value = super.getCellEditorValue();
            return new ObjectTableModel.ValueFixedProperty<Object>(value);
        }
    }
}

