/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.model;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.support.GTreeRenderer;
import docking.widgets.tree.support.GTreeSelectionEvent;
import docking.widgets.tree.support.GTreeSelectionListener;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.model.ColorsModified;
import ghidra.app.plugin.core.debug.gui.model.KeepTreeState;
import ghidra.app.plugin.core.debug.gui.model.ObjectTreeModel;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.Trace;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectKeyPath;
import ghidra.trace.model.target.TraceObjectValue;
import ghidra.util.Swing;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.tree.TreePath;

public class ObjectsTreePanel
extends JPanel {
    protected final ObjectTreeModel treeModel;
    protected final ObjectGTree tree;
    protected boolean showing = false;
    protected Set<TraceObjectKeyPath> savedSelection = null;
    protected DebuggerCoordinates current = DebuggerCoordinates.NOWHERE;
    protected DebuggerCoordinates previous = DebuggerCoordinates.NOWHERE;
    protected boolean limitToSnap = true;
    protected boolean showHidden = false;
    protected boolean showPrimitives = false;
    protected boolean showMethods = false;
    protected Color diffColor = DebuggerResources.COLOR_VALUE_CHANGED;
    protected Color diffColorSel = DebuggerResources.COLOR_VALUE_CHANGED_SEL;
    protected final ListenerForShowing listenerForShowing = new ListenerForShowing();

    public ObjectsTreePanel() {
        super(new BorderLayout());
        this.addAncestorListener(this.listenerForShowing);
        this.treeModel = this.createModel();
        this.tree = new ObjectGTree((GTreeNode)this.treeModel.getRoot());
        this.tree.setCellRenderer(new ObjectsTreeRenderer());
        this.add((Component)((Object)this.tree), "Center");
    }

    protected ObjectTreeModel createModel() {
        return new ObjectTreeModel();
    }

    protected KeepTreeState keepTreeState() {
        return new KeepTreeState(this.tree);
    }

    protected void showingChanged(boolean showing) {
        if (!showing) {
            this.savedSelection = this.getSelectedKeyPaths();
        }
        this.showing = showing;
        this.updateTreeModelForCoordinates();
        this.updateTreeModelForSpan();
        this.updateTreeModelForShowHidden();
        this.updateTreeModelForShowPrimitives();
        this.updateTreeModelForShowMethods();
        if (showing && this.savedSelection != null) {
            this.setSelectedKeyPaths(this.savedSelection, GTreeSelectionEvent.EventOrigin.INTERNAL_GENERATED);
        }
    }

    protected Trace computeDiffTrace(Trace current, Trace previous) {
        if (current == null) {
            return null;
        }
        if (previous == null) {
            return current;
        }
        return previous;
    }

    public void goToCoordinates(DebuggerCoordinates coords) {
        if (DebuggerCoordinates.equalsIgnoreRecorderAndView((DebuggerCoordinates)this.current, (DebuggerCoordinates)coords)) {
            return;
        }
        this.previous = this.current;
        this.current = coords;
        if (this.previous.getSnap() == this.current.getSnap() && this.previous.getTrace() == this.current.getTrace() && this.previous.getObject() == this.current.getObject()) {
            return;
        }
        this.updateTreeModelForCoordinates();
    }

    protected void updateTreeModelForCoordinates() {
        if (!this.showing) {
            this.treeModel.setTrace(null);
            return;
        }
        try (KeepTreeState keep = this.keepTreeState();){
            ObjectTreeModel.AbstractNode node;
            TraceObjectKeyPath path;
            this.treeModel.setDiffTrace(this.computeDiffTrace(this.current.getTrace(), this.previous.getTrace()));
            this.treeModel.setTrace(this.current.getTrace());
            this.treeModel.setDiffSnap(this.previous.getSnap());
            this.treeModel.setSnap(this.current.getSnap());
            if (this.limitToSnap) {
                this.treeModel.setSpan(Lifespan.at((long)this.current.getSnap()));
            }
            for (path = this.current.getPath(); path != null; path = path.parent()) {
                node = this.treeModel.getNode(path);
                if (node == null) continue;
                node.fireNodeChanged();
            }
            for (path = this.previous.getPath(); path != null; path = path.parent()) {
                node = this.treeModel.getNode(path);
                if (node == null) continue;
                node.fireNodeChanged();
            }
        }
    }

    public void setLimitToSnap(boolean limitToSnap) {
        if (this.limitToSnap == limitToSnap) {
            return;
        }
        this.limitToSnap = limitToSnap;
        this.updateTreeModelForSpan();
    }

    protected void updateTreeModelForSpan() {
        if (!this.showing) {
            return;
        }
        try (KeepTreeState keep = this.keepTreeState();){
            this.treeModel.setSpan((Lifespan)(this.limitToSnap ? Lifespan.at((long)this.current.getSnap()) : Lifespan.ALL));
        }
    }

    public boolean isLimitToSnap() {
        return this.limitToSnap;
    }

    public void setShowHidden(boolean showHidden) {
        if (this.showHidden == showHidden) {
            return;
        }
        this.showHidden = showHidden;
        this.updateTreeModelForShowHidden();
    }

    protected void updateTreeModelForShowHidden() {
        if (!this.showing) {
            return;
        }
        try (KeepTreeState keep = this.keepTreeState();){
            this.treeModel.setShowHidden(this.showHidden);
        }
    }

    public boolean isShowHidden() {
        return this.showHidden;
    }

    public void setShowPrimitives(boolean showPrimitives) {
        if (this.showPrimitives == showPrimitives) {
            return;
        }
        this.showPrimitives = showPrimitives;
        this.updateTreeModelForShowPrimitives();
    }

    protected void updateTreeModelForShowPrimitives() {
        if (!this.showing) {
            return;
        }
        try (KeepTreeState keep = this.keepTreeState();){
            this.treeModel.setShowPrimitives(this.showPrimitives);
        }
    }

    public boolean isShowPrimitives() {
        return this.showPrimitives;
    }

    public void setShowMethods(boolean showMethods) {
        if (this.showMethods == showMethods) {
            return;
        }
        this.showMethods = showMethods;
        this.updateTreeModelForShowMethods();
    }

    protected void updateTreeModelForShowMethods() {
        if (!this.showing) {
            return;
        }
        try (KeepTreeState keep = this.keepTreeState();){
            this.treeModel.setShowMethods(this.showMethods);
        }
    }

    public boolean isShowMethods() {
        return this.showMethods;
    }

    public void setDiffColor(Color diffColor) {
        if (Objects.equals(this.diffColor, diffColor)) {
            return;
        }
        this.diffColor = diffColor;
        this.repaint();
    }

    public void setDiffColorSel(Color diffColorSel) {
        if (Objects.equals(this.diffColorSel, diffColorSel)) {
            return;
        }
        this.diffColorSel = diffColorSel;
        this.repaint();
    }

    public void addTreeSelectionListener(GTreeSelectionListener listener) {
        this.tree.addGTreeSelectionListener(listener);
    }

    public void removeTreeSelectionListener(GTreeSelectionListener listener) {
        this.tree.removeGTreeSelectionListener(listener);
    }

    public void setSelectionMode(int selectionMode) {
        this.tree.getSelectionModel().setSelectionMode(selectionMode);
    }

    public int getSelectionMode() {
        return this.tree.getSelectionModel().getSelectionMode();
    }

    protected <R, A> R getItemsFromPaths(TreePath[] paths, Collector<? super ObjectTreeModel.AbstractNode, A, R> collector) {
        return Stream.of(paths).mapMulti((path, consumer) -> {
            Object patt0$temp = path.getLastPathComponent();
            if (patt0$temp instanceof ObjectTreeModel.AbstractNode) {
                ObjectTreeModel.AbstractNode node = (ObjectTreeModel.AbstractNode)((Object)((Object)patt0$temp));
                consumer.accept(node);
            }
        }).collect(collector);
    }

    protected ObjectTreeModel.AbstractNode getItemFromPath(TreePath path) {
        if (path == null) {
            return null;
        }
        return (ObjectTreeModel.AbstractNode)((Object)path.getLastPathComponent());
    }

    public List<ObjectTreeModel.AbstractNode> getSelectedItems() {
        return this.getItemsFromPaths(this.tree.getSelectionPaths(), Collectors.toList());
    }

    public ObjectTreeModel.AbstractNode getSelectedItem() {
        return this.getItemFromPath(this.tree.getSelectionPath());
    }

    public ObjectTreeModel.AbstractNode getNode(TraceObjectKeyPath path) {
        return this.treeModel.getNode(path);
    }

    public void setSelectedKeyPaths(Collection<TraceObjectKeyPath> keyPaths, GTreeSelectionEvent.EventOrigin origin) {
        Set s;
        this.savedSelection = keyPaths instanceof Set ? (s = (Set)keyPaths) : Set.copyOf(keyPaths);
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        for (TraceObjectKeyPath path : keyPaths) {
            ObjectTreeModel.AbstractNode node = this.getNode(path);
            if (node == null) continue;
            treePaths.add(node.getTreePath());
        }
        this.tree.setSelectionPaths((TreePath[])treePaths.toArray(TreePath[]::new), origin);
    }

    public Set<TraceObjectKeyPath> getSelectedKeyPaths() {
        HashSet<TraceObjectKeyPath> result = new HashSet<TraceObjectKeyPath>();
        for (ObjectTreeModel.AbstractNode node : this.getSelectedItems()) {
            TraceObjectValue value = node.getValue();
            if (value == null) {
                result.add(TraceObjectKeyPath.of((String[])new String[0]));
                continue;
            }
            result.add(value.getCanonicalPath());
        }
        return result;
    }

    public void setSelectedKeyPaths(Collection<TraceObjectKeyPath> keyPaths) {
        this.setSelectedKeyPaths(keyPaths, GTreeSelectionEvent.EventOrigin.API_GENERATED);
    }

    public void expandCurrent() {
        TraceObject object = this.current.getObject();
        if (object == null) {
            return;
        }
        ObjectTreeModel.AbstractNode node = this.getNode(object.getCanonicalPath());
        TreePath parentPath = node.getTreePath().getParentPath();
        if (parentPath != null) {
            this.tree.expandPath(parentPath);
        }
    }

    public void setSelectedObject(TraceObject object) {
        if (object == null) {
            this.tree.clearSelectionPaths();
            return;
        }
        ObjectTreeModel.AbstractNode node = this.getNode(object.getCanonicalPath());
        if (node != null) {
            this.tree.addSelectionPath(node.getTreePath());
        }
    }

    public void selectCurrent() {
        this.setSelectedObject(this.current.getObject());
    }

    protected class ListenerForShowing
    implements AncestorListener {
        boolean showing = false;
        int version = 0;

        protected ListenerForShowing() {
        }

        @Override
        public void ancestorRemoved(AncestorEvent event) {
            this.updateShowing();
        }

        @Override
        public void ancestorMoved(AncestorEvent event) {
            this.updateShowing();
        }

        @Override
        public void ancestorAdded(AncestorEvent event) {
            this.updateShowing();
        }

        public void updateShowing() {
            int v = ++this.version;
            DelayedSwingHack.runWayLater(2, () -> {
                if (v == this.version) {
                    this.version = 0;
                    this.setShowing(ObjectsTreePanel.this.isShowing());
                }
            });
        }

        private void setShowing(boolean showing) {
            if (this.showing == showing) {
                return;
            }
            this.showing = showing;
            ObjectsTreePanel.this.showingChanged(showing);
        }
    }

    static class ObjectGTree
    extends GTree {
        public ObjectGTree(GTreeNode root) {
            super(root);
            this.getJTree().setToggleClickCount(0);
        }

        JTree tree() {
            return this.getJTree();
        }
    }

    protected class ObjectsTreeRenderer
    extends GTreeRenderer
    implements ColorsModified.InTree {
        protected ObjectsTreeRenderer() {
            this.setHTMLRenderingEnabled(true);
        }

        private boolean isOnCurrentPath(TraceObjectValue value) {
            TraceObject child;
            if (value == null) {
                return false;
            }
            Object object = value.getValue();
            return object instanceof TraceObject && this.isOnCurrentPath(child = (TraceObject)object);
        }

        private boolean isOnCurrentPath(TraceObject object) {
            TraceObject cur = ObjectsTreePanel.this.current.getObject();
            if (cur == null) {
                return false;
            }
            return object.getCanonicalPath().isAncestor(cur.getCanonicalPath());
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            super.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
            if (!(value instanceof ObjectTreeModel.AbstractNode)) {
                return this;
            }
            ObjectTreeModel.AbstractNode node = (ObjectTreeModel.AbstractNode)((Object)value);
            this.setForeground(this.getForegroundFor(tree, node.isModified(), selected));
            this.setFont(this.getFont(this.isOnCurrentPath(node.getValue())));
            return this;
        }

        @Override
        public Color getDiffForeground(JTree tree) {
            return ObjectsTreePanel.this.diffColor;
        }

        @Override
        public Color getDiffSelForeground(JTree tree) {
            return ObjectsTreePanel.this.diffColorSel;
        }
    }

    protected static class DelayedSwingHack
    implements Runnable {
        private int delay;
        private final Runnable runnable;

        public static void runWayLater(int delay, Runnable runnable) {
            Swing.runLater((Runnable)new DelayedSwingHack(delay, runnable));
        }

        public DelayedSwingHack(int delay, Runnable runnable) {
            this.delay = delay;
            this.runnable = runnable;
        }

        @Override
        public void run() {
            if (--this.delay == 0) {
                this.runnable.run();
            } else {
                Swing.runLater((Runnable)this);
            }
        }
    }
}

