/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTable;
import docking.widgets.table.RowObjectTableModel;
import docking.widgets.table.TableFilter;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerSectionActionContext;
import ghidra.app.plugin.core.debug.gui.modules.ModuleRow;
import ghidra.app.plugin.core.debug.gui.modules.SectionRow;
import ghidra.app.plugin.core.debug.utils.DebouncedRowWrappedEnumeratedColumnTableModel;
import ghidra.debug.api.tracemgr.DebuggerCoordinates;
import ghidra.framework.model.DomainObjectEvent;
import ghidra.framework.model.DomainObjectListener;
import ghidra.framework.model.EventType;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.model.Trace;
import ghidra.trace.model.TraceDomainObjectListener;
import ghidra.trace.model.TraceUniqueObject;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceModuleManager;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.util.TraceEvent;
import ghidra.trace.util.TraceEvents;
import ghidra.util.database.ObjectKey;
import ghidra.util.table.GhidraTable;
import ghidra.util.table.GhidraTableFilterPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class DebuggerLegacySectionsPanel
extends JPanel {
    private final DebuggerModulesProvider provider;
    private Trace currentTrace;
    private final SectionsListener sectionsListener = new SectionsListener();
    protected final SectionTableModel sectionTableModel;
    protected final GhidraTable sectionTable;
    protected final GhidraTableFilterPanel<SectionRow> sectionFilterPanel;
    private final SectionsBySelectedModulesTableFilter filterSectionsBySelectedModules = new SectionsBySelectedModulesTableFilter();
    private DebuggerSectionActionContext myActionContext;

    protected static Set<TraceModule> getSelectedModulesFromContext(DebuggerSectionActionContext context) {
        return context.getSelectedSections(false).stream().map(r -> r.getModule()).collect(Collectors.toSet());
    }

    protected static Set<TraceSection> getSelectedSectionsFromContext(DebuggerSectionActionContext context, boolean allowExpansion) {
        return context.getSelectedSections(allowExpansion);
    }

    protected static AddressSetView getSelectedAddressesFromContext(DebuggerSectionActionContext context) {
        AddressSet sel = new AddressSet();
        for (TraceSection section : DebuggerLegacySectionsPanel.getSelectedSectionsFromContext(context, false)) {
            sel.add(section.getRange());
        }
        return sel;
    }

    public DebuggerLegacySectionsPanel(DebuggerModulesProvider provider) {
        super(new BorderLayout());
        this.provider = provider;
        this.sectionTableModel = new SectionTableModel(provider.getTool());
        this.sectionTable = new GhidraTable((TableModel)((Object)this.sectionTableModel));
        this.sectionTable.setSelectionMode(2);
        this.add(new JScrollPane((Component)this.sectionTable));
        this.sectionFilterPanel = new GhidraTableFilterPanel((JTable)this.sectionTable, (RowObjectTableModel)this.sectionTableModel);
        this.add((Component)this.sectionFilterPanel, "South");
        this.sectionTable.getSelectionModel().addListSelectionListener(evt -> {
            if (evt.getValueIsAdjusting()) {
                return;
            }
            this.myActionContext = new DebuggerSectionActionContext(provider, this.sectionFilterPanel.getSelectedItems(), (GTable)this.sectionTable);
            provider.legacySectionsPanelContextChanged();
        });
        this.sectionTable.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    DebuggerLegacySectionsPanel.this.navigateToSelectedSection();
                }
            }
        });
        this.sectionTable.addKeyListener((KeyListener)new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    DebuggerLegacySectionsPanel.this.navigateToSelectedSection();
                    e.consume();
                }
            }
        });
        TableColumnModel colModel = this.sectionTable.getColumnModel();
        TableColumn startCol = colModel.getColumn(SectionTableColumns.START.ordinal());
        startCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn endCol = colModel.getColumn(SectionTableColumns.END.ordinal());
        endCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn lenCol = colModel.getColumn(SectionTableColumns.LENGTH.ordinal());
        lenCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
    }

    protected void contextChanged() {
        this.provider.contextChanged();
    }

    protected void navigateToSelectedSection() {
        int selectedColumn;
        int selectedRow;
        Object value;
        if (this.provider.listingService != null && (value = this.sectionTable.getValueAt(selectedRow = this.sectionTable.getSelectedRow(), selectedColumn = this.sectionTable.getSelectedColumn())) instanceof Address) {
            Address address = (Address)value;
            this.provider.listingService.goTo(address, true);
        }
    }

    public DebuggerSectionActionContext getActionContext() {
        return this.myActionContext;
    }

    void loadSections() {
        this.sectionTable.getSelectionModel().clearSelection();
        this.sectionTableModel.clear();
        if (this.currentTrace == null) {
            return;
        }
        TraceModuleManager moduleManager = this.currentTrace.getModuleManager();
        this.sectionTableModel.addAllItems(moduleManager.getAllSections());
    }

    public void setTrace(Trace trace) {
        if (this.currentTrace == trace) {
            return;
        }
        this.removeOldListeners();
        this.currentTrace = trace;
        this.addNewListeners();
        this.loadSections();
        this.contextChanged();
    }

    public void coordinatesActivated(DebuggerCoordinates coordinates) {
        this.setTrace(coordinates.getTrace());
    }

    private void removeOldListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.removeListener((DomainObjectListener)this.sectionsListener);
    }

    private void addNewListeners() {
        if (this.currentTrace == null) {
            return;
        }
        this.currentTrace.addListener((DomainObjectListener)this.sectionsListener);
    }

    public void setSelectedSections(Set<TraceSection> sel) {
        DebuggerResources.setSelectedRows(sel, arg_0 -> ((SectionTableModel)this.sectionTableModel).getRow(arg_0), (GTable)this.sectionTable, this.sectionTableModel, this.sectionFilterPanel);
    }

    public void setFilteredBySelectedModules(boolean filtered) {
        this.sectionFilterPanel.setSecondaryFilter((TableFilter)(filtered ? this.filterSectionsBySelectedModules : null));
    }

    private class SectionsListener
    extends TraceDomainObjectListener {
        public SectionsListener() {
            this.listenForUntyped((EventType)DomainObjectEvent.RESTORED, e -> this.objectRestored());
            this.listenFor((TraceEvent)TraceEvents.MODULE_CHANGED, this::moduleChanged);
            this.listenFor((TraceEvent)TraceEvents.MODULE_LIFESPAN_CHANGED, this::moduleChanged);
            this.listenFor((TraceEvent)TraceEvents.MODULE_DELETED, this::moduleDeleted);
            this.listenFor((TraceEvent)TraceEvents.SECTION_ADDED, this::sectionAdded);
            this.listenFor((TraceEvent)TraceEvents.SECTION_CHANGED, this::sectionChanged);
            this.listenFor((TraceEvent)TraceEvents.SECTION_DELETED, this::sectionDeleted);
        }

        private void objectRestored() {
            DebuggerLegacySectionsPanel.this.loadSections();
        }

        private void moduleChanged(TraceModule module) {
            DebuggerLegacySectionsPanel.this.sectionTableModel.fireTableDataChanged();
        }

        private void moduleDeleted(TraceModule module) {
            DebuggerLegacySectionsPanel.this.sectionTableModel.deleteAllItems(DebuggerLegacySectionsPanel.this.sectionTableModel.getMap().values().stream().filter(r -> r.getModule() == module).map(r -> r.getSection()).collect(Collectors.toList()));
        }

        private void sectionAdded(TraceSection section) {
            DebuggerLegacySectionsPanel.this.sectionTableModel.addItem(section);
        }

        private void sectionChanged(TraceSection section) {
            DebuggerLegacySectionsPanel.this.sectionTableModel.updateItem(section);
        }

        private void sectionDeleted(TraceSection section) {
            DebuggerLegacySectionsPanel.this.sectionTableModel.deleteItem(section);
        }
    }

    class SectionsBySelectedModulesTableFilter
    implements TableFilter<SectionRow> {
        SectionsBySelectedModulesTableFilter() {
        }

        public boolean acceptsRow(SectionRow sectionRow) {
            List selModuleRows = DebuggerLegacySectionsPanel.this.provider.legacyModulesPanel.moduleFilterPanel.getSelectedItems();
            if (selModuleRows == null || selModuleRows.isEmpty()) {
                return true;
            }
            for (ModuleRow moduleRow : selModuleRows) {
                if (moduleRow.getModule() != sectionRow.getModule()) continue;
                return true;
            }
            return false;
        }

        public boolean isSubFilterOf(TableFilter<?> tableFilter) {
            return false;
        }
    }

    protected static class SectionTableModel
    extends DebouncedRowWrappedEnumeratedColumnTableModel<SectionTableColumns, ObjectKey, SectionRow, TraceSection> {
        public SectionTableModel(PluginTool tool) {
            super(tool, "Sections", SectionTableColumns.class, TraceUniqueObject::getObjectKey, SectionRow::new, SectionRow::getSection);
        }

        public List<SectionTableColumns> defaultSortOrder() {
            return List.of(SectionTableColumns.START);
        }
    }

    protected static enum SectionTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<SectionTableColumns, SectionRow>
    {
        START("Start Address", Address.class, SectionRow::getStart),
        END("End Address", Address.class, SectionRow::getEnd),
        NAME("Section Name", String.class, SectionRow::getName, SectionRow::setName),
        MODULE("Module Name", String.class, SectionRow::getModuleName),
        LENGTH("Length", Long.class, SectionRow::getLength);

        private final String header;
        private final Function<SectionRow, ?> getter;
        private final BiConsumer<SectionRow, Object> setter;
        private final Class<?> cls;

        private <T> SectionTableColumns(String header, Class<T> cls, Function<SectionRow, T> getter, BiConsumer<SectionRow, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> SectionTableColumns(String header, Class<T> cls, Function<SectionRow, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public boolean isEditable(SectionRow row) {
            return this.setter != null;
        }

        public void setValueOf(SectionRow row, Object value) {
            this.setter.accept(row, value);
        }

        public Object getValueOf(SectionRow row) {
            return this.getter.apply(row);
        }
    }
}

