/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ComponentProvider;
import docking.DefaultActionContext;
import docking.widgets.table.GTable;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.plugin.core.debug.gui.modules.ModuleRow;
import ghidra.trace.model.modules.TraceModule;
import java.awt.Component;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;

public class DebuggerModuleActionContext
extends DefaultActionContext {
    private final Set<TraceModule> selectedModules;
    private final boolean forcedSingle;

    private static Set<TraceModule> toModules(Collection<ModuleRow> rows) {
        return rows.stream().map(ModuleRow::getModule).collect(Collectors.toUnmodifiableSet());
    }

    public DebuggerModuleActionContext(DebuggerModulesProvider provider, Collection<ModuleRow> rows, GTable table) {
        this((ComponentProvider)provider, DebuggerModuleActionContext.toModules(rows), (Component)table, false);
    }

    public DebuggerModuleActionContext(ComponentProvider provider, Set<TraceModule> selected, Component sourceComponent, boolean forcedSingle) {
        super(provider, selected, sourceComponent);
        this.selectedModules = selected;
        this.forcedSingle = forcedSingle;
    }

    public Set<TraceModule> getSelectedModules() {
        return this.selectedModules;
    }

    public boolean isForcedSingle() {
        return this.forcedSingle;
    }
}

