/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.widgets.table.CellEditorUtils;
import docking.widgets.table.CustomToStringCellRenderer;
import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.GTableFilterPanel;
import ghidra.app.plugin.core.debug.gui.AbstractDebuggerMapProposalDialog;
import ghidra.app.plugin.core.debug.gui.DebuggerResources;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.debug.api.modules.ModuleMapProposal;
import ghidra.framework.model.DomainFile;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Program;
import ghidra.util.Swing;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;

public class DebuggerModuleMapProposalDialog
extends AbstractDebuggerMapProposalDialog<ModuleMapProposal.ModuleMapEntry> {
    static final int BUTTON_SIZE = 32;
    private final DebuggerModulesProvider provider;

    protected DebuggerModuleMapProposalDialog(DebuggerModulesProvider provider) {
        super(provider.getTool(), "Map Modules");
        this.provider = provider;
    }

    protected ModuleMapPropsalTableModel createTableModel(PluginTool tool) {
        return new ModuleMapPropsalTableModel(tool);
    }

    @Override
    protected void populateComponents() {
        super.populateComponents();
        this.setPreferredSize(600, 300);
        TableColumnModel columnModel = this.table.getColumnModel();
        TableColumn removeCol = columnModel.getColumn(ModuleMapTableColumns.REMOVE.ordinal());
        CellEditorUtils.installButton((JTable)this.table, (GTableFilterPanel)this.filterPanel, (TableColumn)removeCol, (Icon)DebuggerResources.ICON_DELETE, (int)32, x$0 -> this.removeEntry(x$0));
        TableColumn dynBaseCol = columnModel.getColumn(ModuleMapTableColumns.DYNAMIC_BASE.ordinal());
        dynBaseCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn chooseCol = columnModel.getColumn(ModuleMapTableColumns.CHOOSE.ordinal());
        CellEditorUtils.installButton((JTable)this.table, (GTableFilterPanel)this.filterPanel, (TableColumn)chooseCol, (Icon)DebuggerResources.ICON_PROGRAM, (int)32, this::chooseAndSetProgram);
        TableColumn stBaseCol = columnModel.getColumn(ModuleMapTableColumns.STATIC_BASE.ordinal());
        stBaseCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_OBJECT);
        TableColumn sizeCol = columnModel.getColumn(ModuleMapTableColumns.SIZE.ordinal());
        sizeCol.setCellRenderer((TableCellRenderer)CustomToStringCellRenderer.MONO_ULONG_HEX);
    }

    private void chooseAndSetProgram(ModuleMapProposal.ModuleMapEntry entry) {
        DomainFile file = this.provider.askProgram(entry.getToProgram());
        if (file == null) {
            return;
        }
        if (this.provider.programManager == null) {
            return;
        }
        Program program = this.provider.programManager.openProgram(file);
        Swing.runIfSwingOrRunLater(() -> {
            entry.setProgram(program);
            this.tableModel.notifyUpdated((Object)entry);
        });
    }

    protected static class ModuleMapPropsalTableModel
    extends DefaultEnumeratedColumnTableModel<ModuleMapTableColumns, ModuleMapProposal.ModuleMapEntry> {
        public ModuleMapPropsalTableModel(PluginTool tool) {
            super(tool, "Module Map", ModuleMapTableColumns.class);
        }

        public List<ModuleMapTableColumns> defaultSortOrder() {
            return List.of(ModuleMapTableColumns.MODULE_NAME);
        }
    }

    protected static enum ModuleMapTableColumns implements DefaultEnumeratedColumnTableModel.EnumeratedTableColumn<ModuleMapTableColumns, ModuleMapProposal.ModuleMapEntry>
    {
        REMOVE("Remove", String.class, e -> "Remove Proposed Entry", (e, v) -> ModuleMapTableColumns.nop()),
        MODULE_NAME("Module", String.class, e -> e.getModule().getName()),
        DYNAMIC_BASE("Dynamic Base", Address.class, e -> e.getFromRange().getMinAddress()),
        CHOOSE("Choose", String.class, e -> "Choose Program", (e, v) -> ModuleMapTableColumns.nop()),
        PROGRAM_NAME("Program", String.class, e -> e.getToProgram().getDomainFile() == null ? e.getToProgram().getName() : e.getToProgram().getDomainFile().getName()),
        STATIC_BASE("Static Base", Address.class, e -> e.getToRange().getMinAddress()),
        SIZE("Size", Long.class, e -> e.getFromRange().getLength()),
        MEMORIZE("Memorize", Boolean.class, ModuleMapProposal.ModuleMapEntry::isMemorize, ModuleMapProposal.ModuleMapEntry::setMemorize);

        private final String header;
        private final Class<?> cls;
        private final Function<ModuleMapProposal.ModuleMapEntry, ?> getter;
        private final BiConsumer<ModuleMapProposal.ModuleMapEntry, Object> setter;

        private static void nop() {
        }

        private <T> ModuleMapTableColumns(String header, Class<T> cls, Function<ModuleMapProposal.ModuleMapEntry, T> getter, BiConsumer<ModuleMapProposal.ModuleMapEntry, T> setter) {
            this.header = header;
            this.cls = cls;
            this.getter = getter;
            this.setter = setter;
        }

        private <T> ModuleMapTableColumns(String header, Class<T> cls, Function<ModuleMapProposal.ModuleMapEntry, T> getter) {
            this(header, cls, getter, null);
        }

        public String getHeader() {
            return this.header;
        }

        public Class<?> getValueClass() {
            return this.cls;
        }

        public Object getValueOf(ModuleMapProposal.ModuleMapEntry row) {
            return this.getter.apply(row);
        }

        public boolean isEditable(ModuleMapProposal.ModuleMapEntry row) {
            return this.setter != null;
        }

        public void setValueOf(ModuleMapProposal.ModuleMapEntry row, Object value) {
            this.setter.accept(row, value);
        }
    }
}

