/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.debug.gui.modules;

import docking.ComponentProvider;
import docking.widgets.table.DynamicTableColumn;
import docking.widgets.table.TableColumnDescriptor;
import ghidra.app.plugin.core.debug.gui.model.AbstractObjectsTableBasedPanel;
import ghidra.app.plugin.core.debug.gui.model.ModelQuery;
import ghidra.app.plugin.core.debug.gui.model.ObjectTableModel;
import ghidra.app.plugin.core.debug.gui.model.columns.AbstractTraceValueObjectAddressColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.AbstractTraceValueObjectLengthColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueKeyColumn;
import ghidra.app.plugin.core.debug.gui.model.columns.TraceValueObjectAttributeColumn;
import ghidra.app.plugin.core.debug.gui.modules.DebuggerModulesProvider;
import ghidra.app.plugin.core.debug.service.modules.DebuggerStaticMappingUtils;
import ghidra.dbg.target.TargetModule;
import ghidra.dbg.target.TargetProcess;
import ghidra.dbg.target.schema.TargetObjectSchema;
import ghidra.dbg.util.PathPredicates;
import ghidra.debug.api.model.DebuggerObjectActionContext;
import ghidra.docking.settings.Settings;
import ghidra.framework.plugintool.Plugin;
import ghidra.framework.plugintool.ServiceProvider;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.trace.database.module.TraceObjectSection;
import ghidra.trace.model.Trace;
import ghidra.trace.model.modules.TraceModule;
import ghidra.trace.model.modules.TraceObjectModule;
import ghidra.trace.model.modules.TraceSection;
import ghidra.trace.model.target.TraceObject;
import ghidra.trace.model.target.TraceObjectValue;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.event.ListSelectionEvent;

public class DebuggerModulesPanel
extends AbstractObjectsTableBasedPanel<TraceObjectModule> {
    private final DebuggerModulesProvider provider;

    protected static Set<TraceModule> getSelectedModulesFromContext(DebuggerObjectActionContext ctx) {
        HashSet<TraceModule> result = new HashSet<TraceModule>();
        for (TraceObjectValue value : ctx.getObjectValues()) {
            if (!value.isObject()) continue;
            TraceObject child = value.getChild();
            TraceObjectModule module = (TraceObjectModule)child.queryInterface(TraceObjectModule.class);
            if (module != null) {
                result.add((TraceModule)module);
                continue;
            }
            TraceObjectSection section = (TraceObjectSection)child.queryInterface(TraceObjectSection.class);
            if (section == null) continue;
            result.add(section.getModule());
        }
        return result;
    }

    protected static Set<TraceSection> getSelectedSectionsFromContext(DebuggerObjectActionContext ctx) {
        HashSet<TraceSection> result = new HashSet<TraceSection>();
        for (TraceObjectValue value : ctx.getObjectValues()) {
            if (!value.isObject()) continue;
            TraceObject child = value.getChild();
            TraceObjectModule module = (TraceObjectModule)child.queryInterface(TraceObjectModule.class);
            if (module != null) {
                result.addAll(module.getSections());
                continue;
            }
            TraceObjectSection section = (TraceObjectSection)child.queryInterface(TraceObjectSection.class);
            if (section == null) continue;
            result.add((TraceSection)section);
        }
        return result;
    }

    public static AddressSetView getSelectedAddressesFromContext(DebuggerObjectActionContext ctx) {
        AddressSet result = new AddressSet();
        for (TraceObjectValue value : ctx.getObjectValues()) {
            TraceObject child = value.getChild();
            TraceObjectModule module = (TraceObjectModule)child.queryInterface(TraceObjectModule.class);
            if (module != null) {
                result.add(module.getRange());
                continue;
            }
            TraceObjectSection section = (TraceObjectSection)child.queryInterface(TraceObjectSection.class);
            if (section == null) continue;
            result.add(section.getRange());
        }
        return result;
    }

    protected static ModelQuery successorModules(TargetObjectSchema rootSchema, List<String> path) {
        TargetObjectSchema schema = rootSchema.getSuccessorSchema(path);
        return new ModelQuery((PathPredicates)schema.searchFor(TargetModule.class, path, true));
    }

    public DebuggerModulesPanel(DebuggerModulesProvider provider) {
        super(provider.plugin, (ComponentProvider)provider, TraceObjectModule.class);
        this.provider = provider;
    }

    @Override
    protected ObjectTableModel createModel() {
        return new ModuleTableModel(this.plugin);
    }

    @Override
    protected ModelQuery computeQuery(TraceObject object) {
        List seedPath;
        TargetObjectSchema rootSchema = object.getRoot().getTargetSchema();
        List processPath = rootSchema.searchForAncestor(TargetProcess.class, seedPath = object.getCanonicalPath().getKeyList());
        if (processPath != null) {
            return DebuggerModulesPanel.successorModules(rootSchema, processPath);
        }
        List containerPath = rootSchema.searchForSuitableContainer(TargetModule.class, seedPath);
        if (containerPath != null) {
            return DebuggerModulesPanel.successorModules(rootSchema, containerPath);
        }
        return DebuggerModulesPanel.successorModules(rootSchema, List.of());
    }

    public void setSelectedModules(Set<TraceModule> sel) {
        this.setSelected(sel);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        super.valueChanged(e);
        if (e.getValueIsAdjusting()) {
            return;
        }
        this.provider.modulesPanelContextChanged();
    }

    private static class ModuleTableModel
    extends ObjectTableModel {
        protected ModuleTableModel(Plugin plugin) {
            super(plugin);
        }

        @Override
        protected TableColumnDescriptor<ObjectTableModel.ValueRow> createTableColumnDescriptor() {
            TableColumnDescriptor descriptor = new TableColumnDescriptor();
            descriptor.addHiddenColumn((DynamicTableColumn)new ModulePathColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ModuleBaseColumn(), 1, true);
            descriptor.addVisibleColumn((DynamicTableColumn)new ModuleMaxColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ModuleNameColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ModuleMappingColumn());
            descriptor.addVisibleColumn((DynamicTableColumn)new ModuleLengthColumn());
            return descriptor;
        }
    }

    private static class ModuleLengthColumn
    extends AbstractTraceValueObjectLengthColumn {
        public ModuleLengthColumn() {
            super("_range");
        }

        public String getColumnName() {
            return "Length";
        }
    }

    private static class ModulePathColumn
    extends TraceValueKeyColumn {
        private ModulePathColumn() {
        }

        @Override
        public String getColumnName() {
            return "Path";
        }

        @Override
        public String getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            return rowObject.getValue().getCanonicalPath().toString();
        }
    }

    private static class ModuleMappingColumn
    extends TraceValueKeyColumn {
        private ModuleMappingColumn() {
        }

        @Override
        public String getColumnName() {
            return "Mapping";
        }

        @Override
        public String getValue(ObjectTableModel.ValueRow rowObject, Settings settings, Trace data, ServiceProvider serviceProvider) throws IllegalArgumentException {
            if (data == null) {
                return "";
            }
            ObjectTableModel.ValueAttribute<AddressRange> attr = rowObject.getAttribute("_range", AddressRange.class);
            if (attr == null) {
                return "";
            }
            AddressRange range = attr.getValue();
            if (range == null) {
                return "";
            }
            return DebuggerStaticMappingUtils.computeMappedFiles(data, rowObject.currentSnap(), range);
        }
    }

    private static class ModuleNameColumn
    extends TraceValueObjectAttributeColumn<String> {
        public ModuleNameColumn() {
            super("_module_name", String.class);
        }

        @Override
        public String getColumnName() {
            return "Name";
        }
    }

    private static class ModuleMaxColumn
    extends AbstractTraceValueObjectAddressColumn {
        public ModuleMaxColumn() {
            super("_range");
        }

        public String getColumnName() {
            return "Max";
        }

        @Override
        protected Address fromRange(AddressRange range) {
            return range.getMaxAddress();
        }
    }

    private static class ModuleBaseColumn
    extends AbstractTraceValueObjectAddressColumn {
        public ModuleBaseColumn() {
            super("_range");
        }

        public String getColumnName() {
            return "Base";
        }

        @Override
        protected Address fromRange(AddressRange range) {
            return range.getMinAddress();
        }
    }
}

